/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.AssertionFailureBuilder;

class AssertTrue {
    private AssertTrue() {
    }

    static void assertTrue(boolean condition) {
        AssertTrue.assertTrue(condition, (String)null);
    }

    static void assertTrue(boolean condition, @Nullable String message) {
        if (!condition) {
            AssertTrue.failNotTrue(message);
        }
    }

    static void assertTrue(boolean condition, Supplier<@Nullable String> messageSupplier) {
        if (!condition) {
            AssertTrue.failNotTrue(messageSupplier);
        }
    }

    static void assertTrue(BooleanSupplier booleanSupplier) {
        AssertTrue.assertTrue(booleanSupplier.getAsBoolean(), (String)null);
    }

    static void assertTrue(BooleanSupplier booleanSupplier, @Nullable String message) {
        AssertTrue.assertTrue(booleanSupplier.getAsBoolean(), message);
    }

    static void assertTrue(BooleanSupplier booleanSupplier, Supplier<@Nullable String> messageSupplier) {
        AssertTrue.assertTrue(booleanSupplier.getAsBoolean(), messageSupplier);
    }

    private static void failNotTrue(@Nullable Object messageOrSupplier) {
        AssertionFailureBuilder.assertionFailure().message(messageOrSupplier).expected(true).actual(false).buildAndThrow();
    }
}

