/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.extension;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExecutableInvoker;
import org.junit.jupiter.api.extension.MediaType;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.jupiter.api.function.ThrowingConsumer;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.STABLE, since="5.0")
public interface ExtensionContext {
    public Optional<ExtensionContext> getParent();

    public ExtensionContext getRoot();

    public String getUniqueId();

    public String getDisplayName();

    public Set<String> getTags();

    public Optional<AnnotatedElement> getElement();

    public Optional<Class<?>> getTestClass();

    default public Class<?> getRequiredTestClass() {
        return (Class)Preconditions.notNull((Object)this.getTestClass().orElse(null), (String)"Illegal state: required test class is not present in the current ExtensionContext");
    }

    @API(status=API.Status.MAINTAINED, since="5.13.3")
    public List<Class<?>> getEnclosingTestClasses();

    @API(status=API.Status.STABLE, since="5.1")
    public Optional<TestInstance.Lifecycle> getTestInstanceLifecycle();

    public Optional<Object> getTestInstance();

    default public Object getRequiredTestInstance() {
        return Preconditions.notNull(this.getTestInstance().orElse(null), (String)"Illegal state: required test instance is not present in the current ExtensionContext");
    }

    @API(status=API.Status.STABLE, since="5.7")
    public Optional<TestInstances> getTestInstances();

    @API(status=API.Status.STABLE, since="5.7")
    default public TestInstances getRequiredTestInstances() {
        return (TestInstances)Preconditions.notNull((Object)this.getTestInstances().orElse(null), (String)"Illegal state: required test instances are not present in the current ExtensionContext");
    }

    public Optional<Method> getTestMethod();

    default public Method getRequiredTestMethod() {
        return (Method)Preconditions.notNull((Object)this.getTestMethod().orElse(null), (String)"Illegal state: required test method is not present in the current ExtensionContext");
    }

    public Optional<Throwable> getExecutionException();

    @API(status=API.Status.STABLE, since="5.1")
    public Optional<String> getConfigurationParameter(String var1);

    @API(status=API.Status.STABLE, since="5.10")
    public <T> Optional<T> getConfigurationParameter(String var1, Function<? super String, ? extends @Nullable T> var2);

    public void publishReportEntry(Map<String, String> var1);

    default public void publishReportEntry(String key, String value) {
        this.publishReportEntry(Collections.singletonMap(key, value));
    }

    @API(status=API.Status.STABLE, since="5.3")
    default public void publishReportEntry(String value) {
        this.publishReportEntry("value", value);
    }

    @API(status=API.Status.MAINTAINED, since="5.13.3")
    public void publishFile(String var1, MediaType var2, ThrowingConsumer<Path> var3);

    @API(status=API.Status.MAINTAINED, since="5.13.3")
    public void publishDirectory(String var1, ThrowingConsumer<Path> var2);

    public Store getStore(Namespace var1);

    @API(status=API.Status.EXPERIMENTAL, since="6.0")
    public Store getStore(StoreScope var1, Namespace var2);

    @API(status=API.Status.STABLE, since="5.8.1")
    public ExecutionMode getExecutionMode();

    @API(status=API.Status.STABLE, since="5.11")
    public ExecutableInvoker getExecutableInvoker();

    @API(status=API.Status.EXPERIMENTAL, since="6.0")
    public static enum StoreScope {
        LAUNCHER_SESSION,
        EXECUTION_REQUEST,
        EXTENSION_CONTEXT;

    }

    public static final class Namespace {
        public static final Namespace GLOBAL = Namespace.create(new Object());
        private final List<Object> parts;

        public static Namespace create(Object ... parts) {
            Preconditions.notEmpty((Object[])parts, (String)"parts array must not be null or empty");
            Preconditions.containsNoNullElements((Object[])parts, (String)"individual parts must not be null");
            return new Namespace(List.of(parts));
        }

        private Namespace(List<Object> parts) {
            this.parts = List.copyOf(parts);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Namespace that = (Namespace)o;
            return this.parts.equals(that.parts);
        }

        public int hashCode() {
            return this.parts.hashCode();
        }

        @API(status=API.Status.STABLE, since="5.10")
        public Namespace append(Object ... parts) {
            Preconditions.notEmpty((Object[])parts, (String)"parts array must not be null or empty");
            Preconditions.containsNoNullElements((Object[])parts, (String)"individual parts must not be null");
            ArrayList<Object> newParts = new ArrayList<Object>(this.parts.size() + parts.length);
            newParts.addAll(this.parts);
            Collections.addAll(newParts, parts);
            return new Namespace(newParts);
        }

        @API(status=API.Status.INTERNAL, since="5.13")
        public List<Object> getParts() {
            return this.parts;
        }
    }

    public static interface Store {
        public @Nullable Object get(Object var1);

        public <V> @Nullable V get(Object var1, Class<V> var2);

        @API(status=API.Status.STABLE, since="5.5")
        default public <V> V getOrDefault(Object key, Class<V> requiredType, V defaultValue) {
            V value = this.get(key, requiredType);
            return value != null ? value : defaultValue;
        }

        @Deprecated(since="6.0")
        @API(status=API.Status.DEPRECATED, since="6.0")
        default public <V> V getOrComputeIfAbsent(Class<V> type) {
            return this.computeIfAbsent(type);
        }

        @API(status=API.Status.MAINTAINED, since="6.0")
        default public <V> V computeIfAbsent(Class<V> type) {
            return (V)this.computeIfAbsent(type, x$0 -> ReflectionSupport.newInstance((Class)x$0, (Object[])new Object[0]), type);
        }

        @Deprecated(since="6.0")
        @API(status=API.Status.DEPRECATED, since="6.0")
        public <K, V> @Nullable Object getOrComputeIfAbsent(K var1, Function<? super K, ? extends V> var2);

        @API(status=API.Status.MAINTAINED, since="6.0")
        public <K, V> Object computeIfAbsent(K var1, Function<? super K, ? extends V> var2);

        @Deprecated(since="6.0")
        @API(status=API.Status.DEPRECATED, since="6.0")
        public <K, V> @Nullable V getOrComputeIfAbsent(K var1, Function<? super K, ? extends V> var2, Class<V> var3);

        @API(status=API.Status.MAINTAINED, since="6.0")
        public <K, V> V computeIfAbsent(K var1, Function<? super K, ? extends V> var2, Class<V> var3);

        public void put(Object var1, @Nullable Object var2);

        public @Nullable Object remove(Object var1);

        public <V> @Nullable V remove(Object var1, Class<V> var2);

        @Deprecated(since="5.13")
        @API(status=API.Status.DEPRECATED, since="5.13")
        public static interface CloseableResource {
            public void close() throws Throwable;
        }
    }
}

