/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.AssertionFailureBuilder;
import org.junit.platform.commons.annotation.Contract;

class AssertInstanceOf {
    private AssertInstanceOf() {
    }

    @Contract(value="_, null -> fail")
    static <T> T assertInstanceOf(Class<T> expectedType, @Nullable Object actualValue) {
        return AssertInstanceOf.assertInstanceOf(expectedType, actualValue, null);
    }

    @Contract(value="_, null, _ -> fail")
    static <T> T assertInstanceOf(Class<T> expectedType, @Nullable Object actualValue, @Nullable String message) {
        return AssertInstanceOf.assertInstanceOf(expectedType, actualValue, (Object)message);
    }

    @Contract(value="_, null, _ -> fail")
    static <T> T assertInstanceOf(Class<T> expectedType, @Nullable Object actualValue, Supplier<@Nullable String> messageSupplier) {
        return AssertInstanceOf.assertInstanceOf(expectedType, actualValue, messageSupplier);
    }

    private static <T> T assertInstanceOf(Class<T> expectedType, @Nullable Object actualValue, @Nullable Object messageOrSupplier) {
        if (!expectedType.isInstance(actualValue)) {
            Throwable t;
            AssertionFailureBuilder.assertionFailure().message(messageOrSupplier).reason(actualValue == null ? "Unexpected null value" : "Unexpected type").expected(expectedType).actual(actualValue == null ? null : actualValue.getClass()).cause(actualValue instanceof Throwable ? (t = (Throwable)actualValue) : null).buildAndThrow();
        }
        return expectedType.cast(actualValue);
    }
}

