/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.Method;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.engine.descriptor.TestMethodTestDescriptor;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.meta.API;
import org.junit.platform.engine.UniqueId;

@API(value=API.Usage.Internal)
public class TestTemplateInvocationTestDescriptor
extends TestMethodTestDescriptor {
    public static final String SEGMENT_TYPE = "test-template-invocation";
    private TestTemplateInvocationContext invocationContext;

    TestTemplateInvocationTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method templateMethod, TestTemplateInvocationContext invocationContext, int index) {
        super(uniqueId, invocationContext.getDisplayName(index), testClass, templateMethod);
        this.invocationContext = invocationContext;
    }

    @Override
    protected ExtensionRegistry populateNewExtensionRegistry(JupiterEngineExecutionContext context) {
        ExtensionRegistry registry = super.populateNewExtensionRegistry(context);
        this.invocationContext.getAdditionalExtensions().forEach(extension -> registry.registerExtension((Extension)extension, this.invocationContext));
        return registry;
    }

    public void after(JupiterEngineExecutionContext context) {
        this.invocationContext = null;
    }
}

