/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Optional;
import javax.script.Bindings;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.api.condition.EnabledIf;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ScriptEvaluationException;
import org.junit.jupiter.engine.script.Script;
import org.junit.jupiter.engine.script.ScriptAccessor;
import org.junit.jupiter.engine.script.ScriptExecutionManager;
import org.junit.platform.commons.util.AnnotationUtils;

class ScriptExecutionCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_NO_ELEMENT = ConditionEvaluationResult.enabled((String)"AnnotatedElement not present");
    private static final ConditionEvaluationResult ENABLED_NO_ANNOTATION = ConditionEvaluationResult.enabled((String)"Annotation not present");
    private static final ConditionEvaluationResult ENABLED_ALL = ConditionEvaluationResult.enabled((String)"All results are enabled");
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{ScriptExecutionCondition.class});

    ScriptExecutionCondition() {
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional element = context.getElement();
        if (!element.isPresent()) {
            return ENABLED_NO_ELEMENT;
        }
        AnnotatedElement annotatedElement = (AnnotatedElement)element.get();
        ArrayList scripts = new ArrayList();
        this.createDisabledIfScript(annotatedElement).ifPresent(scripts::add);
        this.createEnabledIfScript(annotatedElement).ifPresent(scripts::add);
        if (scripts.isEmpty()) {
            return ENABLED_NO_ANNOTATION;
        }
        ScriptExecutionManager scriptExecutionManager = this.getScriptExecutionManager(context);
        Bindings bindings = this.createBindings(context);
        for (Script script : scripts) {
            ConditionEvaluationResult result = this.evaluate(scriptExecutionManager, script, bindings);
            if (!result.isDisabled()) continue;
            return result;
        }
        return ENABLED_ALL;
    }

    private Optional<Script> createDisabledIfScript(AnnotatedElement annotatedElement) {
        Optional disabled = AnnotationUtils.findAnnotation((AnnotatedElement)annotatedElement, DisabledIf.class);
        if (!disabled.isPresent()) {
            return Optional.empty();
        }
        DisabledIf annotation = (DisabledIf)disabled.get();
        String source = this.createSource(annotation.value());
        Script script = new Script((Annotation)annotation, annotation.engine(), source, annotation.reason());
        return Optional.of(script);
    }

    private Optional<Script> createEnabledIfScript(AnnotatedElement annotatedElement) {
        Optional enabled = AnnotationUtils.findAnnotation((AnnotatedElement)annotatedElement, EnabledIf.class);
        if (!enabled.isPresent()) {
            return Optional.empty();
        }
        EnabledIf annotation = (EnabledIf)enabled.get();
        String source = this.createSource(annotation.value());
        Script script = new Script((Annotation)annotation, annotation.engine(), source, annotation.reason());
        return Optional.of(script);
    }

    private String createSource(String[] lines) {
        return String.join((CharSequence)System.lineSeparator(), lines);
    }

    private ScriptExecutionManager getScriptExecutionManager(ExtensionContext context) {
        return (ScriptExecutionManager)context.getRoot().getStore(NAMESPACE).getOrComputeIfAbsent(ScriptExecutionManager.class);
    }

    private Bindings createBindings(ExtensionContext context) {
        ScriptAccessor.ConfigurationParameterAccessor configurationParameterAccessor = new ScriptAccessor.ConfigurationParameterAccessor(context);
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("junitTags", (Object)context.getTags());
        bindings.put("junitUniqueId", (Object)context.getUniqueId());
        bindings.put("junitDisplayName", (Object)context.getDisplayName());
        bindings.put("junitConfigurationParameter", (Object)configurationParameterAccessor);
        return bindings;
    }

    ConditionEvaluationResult evaluate(ScriptExecutionManager manager, Script script, Bindings bindings) {
        if (script == null) {
            return null;
        }
        try {
            Object result = manager.evaluate(script, bindings);
            return this.computeConditionEvaluationResult(script, result);
        }
        catch (ScriptException e) {
            throw new ScriptEvaluationException("Script evaluation failed for: " + script.getAnnotationAsString(), (Throwable)e);
        }
    }

    ConditionEvaluationResult computeConditionEvaluationResult(Script script, Object result) {
        if (result == null) {
            throw new ScriptEvaluationException("Script returned `null`: " + script.getAnnotationAsString());
        }
        if (result instanceof ConditionEvaluationResult) {
            return (ConditionEvaluationResult)result;
        }
        String resultAsString = String.valueOf(result);
        String reason = script.toReasonString(resultAsString);
        boolean isTrue = result instanceof Boolean ? (Boolean)result : Boolean.parseBoolean(resultAsString);
        if (script.getAnnotationType() == EnabledIf.class) {
            return isTrue ? ConditionEvaluationResult.enabled((String)reason) : ConditionEvaluationResult.disabled((String)reason);
        }
        if (script.getAnnotationType() == DisabledIf.class) {
            return isTrue ? ConditionEvaluationResult.disabled((String)reason) : ConditionEvaluationResult.enabled((String)reason);
        }
        throw new ScriptEvaluationException("Unsupported annotation type: " + script.getAnnotationType());
    }
}

