/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.migrationsupport.rules;

import java.util.function.Function;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.migrationsupport.rules.TestRuleFieldSupport;
import org.junit.jupiter.migrationsupport.rules.TestRuleMethodSupport;
import org.junit.jupiter.migrationsupport.rules.adapter.AbstractTestRuleAdapter;
import org.junit.jupiter.migrationsupport.rules.adapter.ExpectedExceptionAdapter;
import org.junit.jupiter.migrationsupport.rules.member.TestRuleAnnotatedMember;
import org.junit.platform.commons.meta.API;
import org.junit.rules.ExpectedException;

@API(value=API.Usage.Experimental)
public class ExpectedExceptionSupport
implements AfterEachCallback,
TestExecutionExceptionHandler {
    private static final String EXCEPTION_WAS_HANDLED = "exceptionWasHandled";
    private final Function<TestRuleAnnotatedMember, AbstractTestRuleAdapter> adapterGenerator = ExpectedExceptionAdapter::new;
    private final TestRuleFieldSupport fieldSupport = new TestRuleFieldSupport(this.adapterGenerator, ExpectedException.class);
    private final TestRuleMethodSupport methodSupport = new TestRuleMethodSupport(this.adapterGenerator, ExpectedException.class);

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        this.getStore(context).put((Object)EXCEPTION_WAS_HANDLED, (Object)Boolean.TRUE);
        this.methodSupport.handleTestExecutionException(context, throwable);
        this.fieldSupport.handleTestExecutionException(context, throwable);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        boolean exceptionWasHandled = (Boolean)this.getStore(context).getOrComputeIfAbsent((Object)EXCEPTION_WAS_HANDLED, key -> Boolean.FALSE, Boolean.class);
        if (!exceptionWasHandled) {
            this.methodSupport.afterEach(context);
            this.fieldSupport.afterEach(context);
        }
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{ExpectedExceptionSupport.class, context.getUniqueId()}));
    }
}

