/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ContainerExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.ParameterizedTestInvocationContext;
import org.junit.jupiter.params.ParameterizedTestNameFormatter;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.support.AnnotationInitializer;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;

class ParameterizedTestExtension
implements TestTemplateInvocationContextProvider {
    private static final Logger logger = Logger.getLogger(ParameterizedTestExtension.class.getName());

    ParameterizedTestExtension() {
    }

    public boolean supports(ContainerExtensionContext context) {
        return AnnotationUtils.isAnnotated((Optional)context.getTestMethod(), ParameterizedTest.class);
    }

    public Stream<TestTemplateInvocationContext> provide(ContainerExtensionContext context) {
        Method templateMethod = (Method)Preconditions.notNull(context.getTestMethod().orElse(null), (String)"test method must not be null");
        ParameterizedTestNameFormatter formatter = this.createNameFormatter(templateMethod);
        return AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)templateMethod, ArgumentsSource.class).stream().map(ArgumentsSource::value).map(x$0 -> (ArgumentsProvider)ReflectionUtils.newInstance((Class)x$0, (Object[])new Object[0])).map(provider -> AnnotationInitializer.initialize(templateMethod, provider)).flatMap(provider -> ParameterizedTestExtension.arguments(provider, context)).map(Arguments::get).map(arguments -> new ParameterizedTestInvocationContext(formatter, (Object[])arguments));
    }

    private ParameterizedTestNameFormatter createNameFormatter(Method templateMethod) {
        ParameterizedTest parameterizedTest = (ParameterizedTest)AnnotationUtils.findAnnotation((AnnotatedElement)templateMethod, ParameterizedTest.class).get();
        String name = parameterizedTest.name().trim();
        if (StringUtils.isBlank((String)name)) {
            logger.warning(String.format("Configuration error: @ParameterizedTest on method [%s] must be declared with a non-empty name.", templateMethod));
            name = (String)AnnotationUtils.getDefaultValue((Annotation)parameterizedTest, (String)"name", String.class).get();
        }
        return new ParameterizedTestNameFormatter(name);
    }

    protected static Stream<? extends Arguments> arguments(ArgumentsProvider provider, ContainerExtensionContext context) {
        try {
            return provider.arguments(context);
        }
        catch (Exception e) {
            throw ExceptionUtils.throwAsUncheckedException((Throwable)e);
        }
    }
}

