/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.ParameterizedTestInvocationContext;
import org.junit.jupiter.params.ParameterizedTestMethodContext;
import org.junit.jupiter.params.ParameterizedTestNameFormatter;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.support.AnnotationConsumerInitializer;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

class ParameterizedTestExtension
implements TestTemplateInvocationContextProvider {
    private static final String METHOD_CONTEXT_KEY = "context";

    ParameterizedTestExtension() {
    }

    public boolean supportsTestTemplate(ExtensionContext context) {
        if (!context.getTestMethod().isPresent()) {
            return false;
        }
        Method testMethod = (Method)context.getTestMethod().get();
        if (!AnnotationUtils.isAnnotated((AnnotatedElement)testMethod, ParameterizedTest.class)) {
            return false;
        }
        ParameterizedTestMethodContext methodContext = new ParameterizedTestMethodContext(testMethod);
        Preconditions.condition((boolean)methodContext.hasPotentiallyValidSignature(), () -> String.format("@ParameterizedTest method [%s] declares formal parameters in an invalid order: argument aggregators must be declared after any indexed arguments and before any arguments resolved by another ParameterResolver.", testMethod.toGenericString()));
        this.getStore(context).put((Object)METHOD_CONTEXT_KEY, (Object)methodContext);
        return true;
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext extensionContext) {
        Method templateMethod = extensionContext.getRequiredTestMethod();
        String displayName = extensionContext.getDisplayName();
        ParameterizedTestMethodContext methodContext = (ParameterizedTestMethodContext)this.getStore(extensionContext).get((Object)METHOD_CONTEXT_KEY, ParameterizedTestMethodContext.class);
        ParameterizedTestNameFormatter formatter = this.createNameFormatter(templateMethod, displayName);
        AtomicLong invocationCount = new AtomicLong(0L);
        return (Stream)AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)templateMethod, ArgumentsSource.class).stream().map(ArgumentsSource::value).map(x$0 -> (ArgumentsProvider)ReflectionUtils.newInstance((Class)x$0, (Object[])new Object[0])).map(provider -> AnnotationConsumerInitializer.initialize(templateMethod, provider)).flatMap(provider -> ParameterizedTestExtension.arguments(provider, extensionContext)).map(Arguments::get).map(arguments -> this.consumedArguments((Object[])arguments, methodContext)).map(arguments -> this.createInvocationContext(formatter, methodContext, (Object[])arguments)).peek(invocationContext -> invocationCount.incrementAndGet()).onClose(() -> Preconditions.condition((invocationCount.get() > 0L ? 1 : 0) != 0, (String)"Configuration error: You must configure at least one set of arguments for this @ParameterizedTest"));
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{ParameterizedTestExtension.class, context.getRequiredTestMethod()}));
    }

    private TestTemplateInvocationContext createInvocationContext(ParameterizedTestNameFormatter formatter, ParameterizedTestMethodContext methodContext, Object[] arguments) {
        return new ParameterizedTestInvocationContext(formatter, methodContext, arguments);
    }

    private ParameterizedTestNameFormatter createNameFormatter(Method templateMethod, String displayName) {
        ParameterizedTest parameterizedTest = (ParameterizedTest)AnnotationUtils.findAnnotation((AnnotatedElement)templateMethod, ParameterizedTest.class).get();
        String pattern = Preconditions.notBlank((String)parameterizedTest.name().trim(), () -> String.format("Configuration error: @ParameterizedTest on method [%s] must be declared with a non-empty name.", templateMethod));
        return new ParameterizedTestNameFormatter(pattern, displayName);
    }

    protected static Stream<? extends Arguments> arguments(ArgumentsProvider provider, ExtensionContext context) {
        try {
            return provider.provideArguments(context);
        }
        catch (Exception e) {
            throw ExceptionUtils.throwAsUncheckedException((Throwable)e);
        }
    }

    private Object[] consumedArguments(Object[] arguments, ParameterizedTestMethodContext methodContext) {
        int parameterCount = methodContext.getParameterCount();
        return methodContext.hasAggregator() ? arguments : (arguments.length > parameterCount ? Arrays.copyOf(arguments, parameterCount) : arguments);
    }
}

