/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.converter;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.junit.jupiter.params.converter.ArgumentConversionException;
import org.junit.jupiter.params.converter.FallbackStringToObjectConverter;
import org.junit.jupiter.params.converter.SimpleArgumentConverter;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.INTERNAL, since="5.0")
public class DefaultArgumentConverter
extends SimpleArgumentConverter {
    public static final DefaultArgumentConverter INSTANCE = new DefaultArgumentConverter();
    private static final List<StringToObjectConverter> stringToObjectConverters = Collections.unmodifiableList(Arrays.asList(new StringToPrimitiveConverter(), new StringToEnumConverter(), new StringToJavaTimeConverter(), new StringToCommonJavaTypesConverter(), new FallbackStringToObjectConverter()));

    private DefaultArgumentConverter() {
    }

    @Override
    public Object convert(Object source, Class<?> targetType) {
        if (source == null) {
            if (targetType.isPrimitive()) {
                throw new ArgumentConversionException("Cannot convert null to primitive value of type " + targetType.getName());
            }
            return null;
        }
        if (ReflectionUtils.isAssignableTo((Object)source, targetType)) {
            return source;
        }
        return this.convertToTargetType(source, DefaultArgumentConverter.toWrapperType(targetType));
    }

    private Object convertToTargetType(Object source, Class<?> targetType) {
        Optional<StringToObjectConverter> converter;
        if (source instanceof String && (converter = stringToObjectConverters.stream().filter(candidate -> candidate.canConvert(targetType)).findFirst()).isPresent()) {
            try {
                return converter.get().convert((String)source, targetType);
            }
            catch (Exception ex) {
                if (ex instanceof ArgumentConversionException) {
                    throw (ArgumentConversionException)((Object)ex);
                }
                throw new ArgumentConversionException("Failed to convert String \"" + source + "\" to type " + targetType.getName(), ex);
            }
        }
        throw new ArgumentConversionException("No implicit conversion to convert object of type " + source.getClass().getName() + " to type " + targetType.getName());
    }

    private static Class<?> toWrapperType(Class<?> targetType) {
        Class<?> wrapperType = ReflectionUtils.getWrapperType(targetType);
        return wrapperType != null ? wrapperType : targetType;
    }

    private static class StringToCommonJavaTypesConverter
    implements StringToObjectConverter {
        private static final Map<Class<?>, Function<String, ?>> CONVERTERS;

        private StringToCommonJavaTypesConverter() {
        }

        @Override
        public boolean canConvert(Class<?> targetType) {
            return CONVERTERS.containsKey(targetType);
        }

        @Override
        public Object convert(String source, Class<?> targetType) throws Exception {
            return CONVERTERS.get(targetType).apply(source);
        }

        private static URL toURL(String url) {
            try {
                return new URL(url);
            }
            catch (MalformedURLException ex) {
                throw new ArgumentConversionException("Failed to convert String \"" + url + "\" to type " + URL.class.getName(), ex);
            }
        }

        static {
            HashMap<Class, Function<String, Object>> converters = new HashMap<Class, Function<String, Object>>();
            converters.put(File.class, File::new);
            converters.put(Charset.class, Charset::forName);
            converters.put(Path.class, x$0 -> Paths.get(x$0, new String[0]));
            converters.put(URI.class, URI::create);
            converters.put(URL.class, StringToCommonJavaTypesConverter::toURL);
            converters.put(BigDecimal.class, BigDecimal::new);
            converters.put(BigInteger.class, BigInteger::new);
            converters.put(Currency.class, Currency::getInstance);
            converters.put(Locale.class, Locale::new);
            converters.put(UUID.class, UUID::fromString);
            CONVERTERS = Collections.unmodifiableMap(converters);
        }
    }

    private static class StringToJavaTimeConverter
    implements StringToObjectConverter {
        private static final Map<Class<?>, Function<CharSequence, ?>> CONVERTERS;

        private StringToJavaTimeConverter() {
        }

        @Override
        public boolean canConvert(Class<?> targetType) {
            return CONVERTERS.containsKey(targetType);
        }

        @Override
        public Object convert(String source, Class<?> targetType) throws Exception {
            return CONVERTERS.get(targetType).apply(source);
        }

        static {
            HashMap<Class<ZonedDateTime>, Function<CharSequence, Object>> converters = new HashMap<Class<ZonedDateTime>, Function<CharSequence, Object>>();
            converters.put(Instant.class, Instant::parse);
            converters.put(LocalDate.class, LocalDate::parse);
            converters.put(LocalDateTime.class, LocalDateTime::parse);
            converters.put(LocalTime.class, LocalTime::parse);
            converters.put(OffsetDateTime.class, OffsetDateTime::parse);
            converters.put(OffsetTime.class, OffsetTime::parse);
            converters.put(Year.class, Year::parse);
            converters.put(YearMonth.class, YearMonth::parse);
            converters.put(ZonedDateTime.class, ZonedDateTime::parse);
            CONVERTERS = Collections.unmodifiableMap(converters);
        }
    }

    private static class StringToEnumConverter
    implements StringToObjectConverter {
        private StringToEnumConverter() {
        }

        @Override
        public boolean canConvert(Class<?> targetType) {
            return targetType.isEnum();
        }

        @Override
        public Object convert(String source, Class<?> targetType) throws Exception {
            return this.valueOf(targetType, source);
        }

        private Object valueOf(Class targetType, String source) {
            return Enum.valueOf(targetType, source);
        }
    }

    private static class StringToPrimitiveConverter
    implements StringToObjectConverter {
        private static final Map<Class<?>, Function<String, ?>> CONVERTERS;

        private StringToPrimitiveConverter() {
        }

        @Override
        public boolean canConvert(Class<?> targetType) {
            return CONVERTERS.containsKey(targetType);
        }

        @Override
        public Object convert(String source, Class<?> targetType) {
            return CONVERTERS.get(targetType).apply(source);
        }

        static {
            HashMap<Class, Function<String, Object>> converters = new HashMap<Class, Function<String, Object>>();
            converters.put(Boolean.class, Boolean::valueOf);
            converters.put(Character.class, source -> {
                Preconditions.condition((source.length() == 1 ? 1 : 0) != 0, () -> "String must have length of 1: " + source);
                return Character.valueOf(source.charAt(0));
            });
            converters.put(Byte.class, Byte::valueOf);
            converters.put(Short.class, Short::valueOf);
            converters.put(Integer.class, Integer::valueOf);
            converters.put(Long.class, Long::valueOf);
            converters.put(Float.class, Float::valueOf);
            converters.put(Double.class, Double::valueOf);
            CONVERTERS = Collections.unmodifiableMap(converters);
        }
    }

    static interface StringToObjectConverter {
        public boolean canConvert(Class<?> var1);

        public Object convert(String var1, Class<?> var2) throws Exception;
    }
}

