/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.AnnotationBasedArgumentsProvider;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsUtils;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.support.ParameterDeclarations;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;

class MethodArgumentsProvider
extends AnnotationBasedArgumentsProvider<MethodSource> {
    private static final Predicate<Method> isFactoryMethod = method -> CollectionUtils.isConvertibleToStream(method.getReturnType()) && !MethodArgumentsProvider.isTestMethod(method);

    MethodArgumentsProvider() {
    }

    @Override
    protected Stream<? extends Arguments> provideArguments(ParameterDeclarations parameters, ExtensionContext context, MethodSource methodSource) {
        Class testClass = context.getRequiredTestClass();
        Optional testMethod = context.getTestMethod();
        Object testInstance = context.getTestInstance().orElse(null);
        String[] methodNames = methodSource.value();
        return Arrays.stream(methodNames).map(factoryMethodName -> MethodArgumentsProvider.findFactoryMethod(testClass, testMethod, factoryMethodName)).map(factoryMethod -> MethodArgumentsProvider.validateFactoryMethod(factoryMethod, testInstance)).map(factoryMethod -> Preconditions.notNull((Object)context.getExecutableInvoker().invoke(factoryMethod, testInstance), () -> "@MethodSource-referenced method [%s] must not return null".formatted(factoryMethod.toGenericString()))).flatMap(CollectionUtils::toStream).map(ArgumentsUtils::toArguments);
    }

    private static Method findFactoryMethod(Class<?> testClass, Optional<Method> testMethod, String factoryMethodName) {
        String originalFactoryMethodName = factoryMethodName;
        if (StringUtils.isBlank((String)factoryMethodName)) {
            Preconditions.condition((boolean)testMethod.isPresent(), (String)"You must specify a method name when using @MethodSource with @ParameterizedClass");
            factoryMethodName = testMethod.get().getName();
            return MethodArgumentsProvider.findFactoryMethodBySimpleName(testClass, testMethod, (String)factoryMethodName);
        }
        if (!MethodArgumentsProvider.looksLikeAFullyQualifiedMethodName((String)factoryMethodName)) {
            factoryMethodName = testClass.getName() + "#" + (String)factoryMethodName;
        }
        Method factoryMethod = MethodArgumentsProvider.findFactoryMethodByFullyQualifiedName(testClass, testMethod, (String)factoryMethodName);
        Preconditions.condition((boolean)isFactoryMethod.test(factoryMethod), () -> "Could not find valid factory method [%s] for test class [%s] but found the following invalid candidate: %s".formatted(originalFactoryMethodName, testClass.getName(), factoryMethod));
        return factoryMethod;
    }

    private static boolean looksLikeAFullyQualifiedMethodName(String factoryMethodName) {
        if (factoryMethodName.contains("#")) {
            return true;
        }
        int indexOfFirstDot = factoryMethodName.indexOf(46);
        if (indexOfFirstDot == -1) {
            return false;
        }
        int indexOfLastOpeningParenthesis = factoryMethodName.lastIndexOf(40);
        if (indexOfLastOpeningParenthesis > 0) {
            return indexOfFirstDot < indexOfLastOpeningParenthesis;
        }
        return true;
    }

    static Method findFactoryMethodByFullyQualifiedName(Class<?> testClass, Optional<Method> testMethod, String fullyQualifiedMethodName) {
        String[] methodParts = ReflectionUtils.parseFullyQualifiedMethodName((String)fullyQualifiedMethodName);
        String className = methodParts[0];
        String methodName = methodParts[1];
        String methodParameters = methodParts[2];
        ClassLoader classLoader = ClassLoaderUtils.getClassLoader(testClass);
        Class clazz = ReflectionUtils.loadRequiredClass((String)className, (ClassLoader)classLoader);
        Method factoryMethod = ReflectionUtils.findMethod((Class)clazz, (String)methodName, (String)methodParameters).orElse(null);
        if (factoryMethod != null) {
            return factoryMethod;
        }
        boolean explicitParameterListSpecified = StringUtils.isNotBlank((String)methodParameters) || fullyQualifiedMethodName.endsWith("()");
        Preconditions.condition((!explicitParameterListSpecified ? 1 : 0) != 0, () -> "Could not find factory method [%s(%s)] in class [%s]".formatted(methodName, methodParameters, className));
        return MethodArgumentsProvider.findFactoryMethodBySimpleName(clazz, testMethod, methodName);
    }

    private static Method findFactoryMethodBySimpleName(Class<?> clazz, Optional<Method> testMethod, String factoryMethodName) {
        Predicate<Method> isCandidate = candidate -> factoryMethodName.equals(candidate.getName()) && !candidate.equals(testMethod.orElse(null));
        List candidates = ReflectionUtils.findMethods(clazz, isCandidate);
        List<Method> factoryMethods = candidates.stream().filter(isFactoryMethod).toList();
        Preconditions.notEmpty(factoryMethods, () -> {
            if (candidates.isEmpty()) {
                return "Could not find factory method [%s] in class [%s]".formatted(factoryMethodName, clazz.getName());
            }
            return "Could not find valid factory method [%s] in class [%s] but found the following invalid candidates: %s".formatted(factoryMethodName, clazz.getName(), candidates);
        });
        Preconditions.condition((factoryMethods.size() == 1 ? 1 : 0) != 0, () -> "%d factory methods named [%s] were found in class [%s]: %s".formatted(factoryMethods.size(), factoryMethodName, clazz.getName(), factoryMethods));
        return factoryMethods.get(0);
    }

    private static boolean isTestMethod(Method candidate) {
        return AnnotationSupport.isAnnotated((AnnotatedElement)candidate, Test.class) || AnnotationSupport.isAnnotated((AnnotatedElement)candidate, TestTemplate.class) || AnnotationSupport.isAnnotated((AnnotatedElement)candidate, TestFactory.class);
    }

    private static Method validateFactoryMethod(Method factoryMethod, @Nullable Object testInstance) {
        Preconditions.condition((factoryMethod.getDeclaringClass().isInstance(testInstance) || ReflectionUtils.isStatic((Member)factoryMethod) ? 1 : 0) != 0, () -> String.format("Method '%s' must be static: local factory methods must be static unless the PER_CLASS @TestInstance lifecycle mode is used; external factory methods must always be static.", factoryMethod.toGenericString()));
        return factoryMethod;
    }
}

