/*
 * Decompiled with CFR 0.152.
 */
package org.junit.support.testng.engine;

import java.util.HashSet;
import org.junit.platform.engine.TestDescriptor;
import org.junit.support.testng.engine.ClassDescriptor;
import org.junit.support.testng.engine.DefaultListener;
import org.junit.support.testng.engine.TestClassRegistry;
import org.junit.support.testng.engine.TestNGEngineDescriptor;
import org.testng.ITestClass;
import org.testng.ITestResult;

class DiscoveryListener
extends DefaultListener {
    private final TestClassRegistry testClassRegistry = new TestClassRegistry();
    private final TestNGEngineDescriptor engineDescriptor;

    public DiscoveryListener(TestNGEngineDescriptor engineDescriptor) {
        this.engineDescriptor = engineDescriptor;
    }

    public void finalizeDiscovery() {
        HashSet<ClassDescriptor> classDescriptors = new HashSet<ClassDescriptor>(this.engineDescriptor.getClassDescriptors());
        classDescriptors.removeAll(this.testClassRegistry.getClassDescriptors());
        classDescriptors.forEach(TestDescriptor::removeFromHierarchy);
    }

    @Override
    public void onBeforeClass(ITestClass testClass) {
        this.testClassRegistry.start(testClass.getRealClass(), () -> this.engineDescriptor.findClassDescriptor(testClass.getRealClass()));
    }

    @Override
    public void onAfterClass(ITestClass testClass) {
        this.testClassRegistry.finish(testClass.getRealClass(), __ -> {});
    }

    @Override
    public void onTestStart(ITestResult result) {
        this.addMethodDescriptor(result);
    }

    @Override
    public void onTestSkipped(ITestResult result) {
        this.addMethodDescriptor(result);
    }

    private void addMethodDescriptor(ITestResult result) {
        ClassDescriptor classDescriptor = this.testClassRegistry.get(result.getTestClass().getRealClass()).orElseThrow(() -> new IllegalStateException("Missing class descriptor for " + result.getTestClass()));
        if (!classDescriptor.findMethodDescriptor(result).isPresent()) {
            classDescriptor.addChild((TestDescriptor)this.engineDescriptor.getTestDescriptorFactory().createMethodDescriptor(classDescriptor, result));
        }
    }
}

