/*
 * Decompiled with CFR 0.152.
 */
package org.junit.support.testng.engine;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.discovery.EngineDiscoveryRequestResolver;
import org.junit.support.testng.engine.DiscoveryListener;
import org.junit.support.testng.engine.ExecutionListener;
import org.junit.support.testng.engine.IsTestNGTestClass;
import org.junit.support.testng.engine.LoggingListener;
import org.junit.support.testng.engine.TestNGEngineDescriptor;
import org.junit.support.testng.engine.TestNGSelectorResolver;
import org.testng.CommandLineArgs;
import org.testng.ITestNGListener;
import org.testng.TestNG;

public class TestNGTestEngine
implements TestEngine {
    private static final EngineDiscoveryRequestResolver<TestNGEngineDescriptor> DISCOVERY_REQUEST_RESOLVER = EngineDiscoveryRequestResolver.builder().addClassContainerSelectorResolver((Predicate)new IsTestNGTestClass()).addSelectorResolver(ctx -> new TestNGSelectorResolver(ctx.getClassNameFilter(), ((TestNGEngineDescriptor)ctx.getEngineDescriptor()).getTestDescriptorFactory())).build();

    public String getId() {
        return "testng";
    }

    public TestDescriptor discover(EngineDiscoveryRequest request, UniqueId uniqueId) {
        TestNG testNG;
        TestNGEngineDescriptor engineDescriptor = new TestNGEngineDescriptor(uniqueId);
        DISCOVERY_REQUEST_RESOLVER.resolve(request, (TestDescriptor)engineDescriptor);
        Class<?>[] testClasses = engineDescriptor.getTestClasses();
        List<String> methodNames = engineDescriptor.getQualifiedMethodNames();
        ConfigurationParameters configurationParameters = request.getConfigurationParameters();
        DiscoveryListener listener = new DiscoveryListener(engineDescriptor);
        if (testClasses.length > 0) {
            testNG = this.createTestNGForTestClasses(testClasses);
            TestNGTestEngine.withTemporarySystemProperty("testng.mode.dryrun", "true", () -> this.configureAndRun(testNG, Phase.DISCOVERY, configurationParameters, (ITestNGListener)listener));
        }
        if (!methodNames.isEmpty()) {
            testNG = this.createTestNGForTestMethods(methodNames);
            TestNGTestEngine.withTemporarySystemProperty("testng.mode.dryrun", "true", () -> this.configureAndRun(testNG, Phase.DISCOVERY, configurationParameters, (ITestNGListener)listener));
        }
        listener.finalizeDiscovery();
        return engineDescriptor;
    }

    public void execute(ExecutionRequest request) {
        EngineExecutionListener listener = request.getEngineExecutionListener();
        TestNGEngineDescriptor engineDescriptor = (TestNGEngineDescriptor)request.getRootTestDescriptor();
        listener.executionStarted((TestDescriptor)engineDescriptor);
        engineDescriptor.prepareExecution();
        ExecutionListener executionListener = this.createExecutionListener(listener, engineDescriptor);
        List<String> methodNames = engineDescriptor.getQualifiedMethodNames();
        if (!methodNames.isEmpty()) {
            this.configureAndRun(this.createTestNGForTestMethods(methodNames), Phase.EXECUTION, request.getConfigurationParameters(), (ITestNGListener)executionListener);
        }
        listener.executionFinished((TestDescriptor)engineDescriptor, executionListener.toEngineResult());
    }

    private ExecutionListener createExecutionListener(EngineExecutionListener listener, TestNGEngineDescriptor engineDescriptor) {
        return new ExecutionListener(listener, engineDescriptor);
    }

    private void configureAndRun(TestNG testNG, Phase phase, ConfigurationParameters configurationParameters, ITestNGListener listener) {
        phase.configure(testNG, configurationParameters);
        testNG.addListener(listener);
        testNG.run();
    }

    private TestNG createTestNGForTestClasses(Class<?>[] testClasses) {
        ConfigurableTestNG testNG = new ConfigurableTestNG();
        testNG.setTestClasses(testClasses);
        return testNG;
    }

    private TestNG createTestNGForTestMethods(List<String> methodNames) {
        ConfigurableTestNG testNG = new ConfigurableTestNG();
        if (!methodNames.isEmpty()) {
            testNG.configure(TestNGTestEngine.createCommandLineArgs(methodNames));
        }
        return testNG;
    }

    private static CommandLineArgs createCommandLineArgs(List<String> methodNames) {
        CommandLineArgs commandLineArgs = new CommandLineArgs();
        commandLineArgs.useDefaultListeners = String.valueOf(false);
        commandLineArgs.commandLineMethods = methodNames;
        return commandLineArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void withTemporarySystemProperty(String key, String value, Runnable action) {
        String originalValue = System.getProperty(key);
        System.setProperty(key, value);
        try {
            action.run();
        }
        finally {
            if (originalValue == null) {
                System.getProperties().remove(key);
            } else {
                System.setProperty(key, originalValue);
            }
        }
    }

    static enum Phase {
        DISCOVERY{

            @Override
            void configure(TestNG testNG, ConfigurationParameters config) {
                testNG.addListener((ITestNGListener)LoggingListener.INSTANCE);
                testNG.setVerbose(0);
                testNG.setUseDefaultListeners(false);
            }
        }
        ,
        EXECUTION{

            @Override
            void configure(TestNG testNG, ConfigurationParameters config) {
                testNG.addListener((ITestNGListener)LoggingListener.INSTANCE);
                testNG.setVerbose(config.get("testng.verbose", Integer::valueOf).orElse(0).intValue());
                testNG.setUseDefaultListeners(config.getBoolean("testng.useDefaultListeners").orElse(false).booleanValue());
                config.get("testng.outputDirectory").ifPresent(arg_0 -> ((TestNG)testNG).setOutputDirectory(arg_0));
                config.get("testng.listeners").ifPresent(listeners -> Arrays.stream(listeners.split(",")).map(ReflectionSupport::tryToLoadClass).map(result -> (Class)result.getOrThrow(cause -> new JUnitException("Failed to load custom listener class", (Throwable)cause))).map(listenerClass -> {
                    if (!ITestNGListener.class.isAssignableFrom((Class<?>)listenerClass)) {
                        throw new JUnitException("Custom listener class must implement " + ITestNGListener.class.getName() + ": " + listenerClass.getName());
                    }
                    return (ITestNGListener)ReflectionSupport.newInstance((Class)listenerClass, (Object[])new Object[0]);
                }).forEach(arg_0 -> ((TestNG)testNG).addListener(arg_0)));
            }
        };


        abstract void configure(TestNG var1, ConfigurationParameters var2);
    }

    private static class ConfigurableTestNG
    extends TestNG {
        private ConfigurableTestNG() {
        }

        protected void configure(CommandLineArgs cla) {
            super.configure(cla);
        }
    }
}

