/*
 * Decompiled with CFR 0.152.
 */
package org.junit.support.testng.engine;

import java.util.Collection;
import java.util.HashSet;
import java.util.function.Predicate;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.support.testng.engine.ClassDescriptor;
import org.junit.support.testng.engine.DefaultListener;
import org.junit.support.testng.engine.TestClassRegistry;
import org.junit.support.testng.engine.TestNGEngineDescriptor;
import org.testng.ITestClass;
import org.testng.ITestResult;

class DiscoveryListener
extends DefaultListener {
    private final TestClassRegistry testClassRegistry = new TestClassRegistry();
    private final TestNGEngineDescriptor engineDescriptor;
    private final Predicate<String> classNameFilter;

    public DiscoveryListener(EngineDiscoveryRequest request, TestNGEngineDescriptor engineDescriptor) {
        this.classNameFilter = Filter.composeFilters((Collection)request.getFiltersByType(ClassNameFilter.class)).toPredicate();
        this.engineDescriptor = engineDescriptor;
    }

    public void finalizeDiscovery() {
        HashSet<ClassDescriptor> classDescriptors = new HashSet<ClassDescriptor>(this.engineDescriptor.getClassDescriptors());
        classDescriptors.removeAll(this.testClassRegistry.getClassDescriptors());
        classDescriptors.forEach(TestDescriptor::removeFromHierarchy);
    }

    @Override
    public void onBeforeClass(ITestClass testClass) {
        this.testClassRegistry.start(testClass.getRealClass(), realClass -> {
            ClassDescriptor classDescriptor = this.engineDescriptor.findClassDescriptor((Class<?>)realClass);
            if (classDescriptor == null && this.classNameFilter.test(realClass.getName())) {
                classDescriptor = this.engineDescriptor.getTestDescriptorFactory().createClassDescriptor((TestDescriptor)this.engineDescriptor, (Class<?>)realClass);
                this.engineDescriptor.addChild((TestDescriptor)classDescriptor);
            }
            return classDescriptor;
        });
    }

    @Override
    public void onAfterClass(ITestClass testClass) {
        this.testClassRegistry.finish(testClass.getRealClass(), __ -> {});
    }

    @Override
    public void onTestStart(ITestResult result) {
        this.addMethodDescriptor(result);
    }

    @Override
    public void onTestSkipped(ITestResult result) {
        this.addMethodDescriptor(result);
    }

    private void addMethodDescriptor(ITestResult result) {
        ClassDescriptor classDescriptor = this.testClassRegistry.get(result.getTestClass().getRealClass()).orElseThrow(() -> new IllegalStateException("Missing class descriptor for " + result.getTestClass()));
        if (!classDescriptor.findMethodDescriptor(result).isPresent()) {
            classDescriptor.addChild((TestDescriptor)this.engineDescriptor.getTestDescriptorFactory().createMethodDescriptor(classDescriptor, result));
        }
    }
}

