/*
 * Decompiled with CFR 0.152.
 */
package org.junit.support.testng.engine;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.support.testng.engine.ClassDescriptor;
import org.junit.support.testng.engine.DefaultListener;
import org.junit.support.testng.engine.InvocationDescriptor;
import org.junit.support.testng.engine.MethodDescriptor;
import org.junit.support.testng.engine.TestClassRegistry;
import org.junit.support.testng.engine.TestDescriptorFactory;
import org.junit.support.testng.engine.TestNGEngineDescriptor;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.annotations.CustomAttribute;

class ExecutionListener
extends DefaultListener {
    private final TestClassRegistry testClassRegistry = new TestClassRegistry();
    private final Map<ITestNGMethod, MethodProgress> inProgressTestMethods = new ConcurrentHashMap<ITestNGMethod, MethodProgress>();
    private final Set<Throwable> engineFailures = ConcurrentHashMap.newKeySet();
    private final Map<ClassDescriptor, Set<Throwable>> classFailures = new ConcurrentHashMap<ClassDescriptor, Set<Throwable>>();
    private final EngineExecutionListener delegate;
    private final TestNGEngineDescriptor engineDescriptor;

    ExecutionListener(EngineExecutionListener delegate, TestNGEngineDescriptor engineDescriptor) {
        this.delegate = delegate;
        this.engineDescriptor = engineDescriptor;
    }

    @Override
    public void onBeforeClass(ITestClass testClass) {
        ClassDescriptor classDescriptor = Objects.requireNonNull(this.engineDescriptor.findClassDescriptor(testClass.getRealClass()), "Missing class descriptor");
        this.testClassRegistry.start(testClass.getRealClass(), __ -> {
            this.delegate.executionStarted((TestDescriptor)classDescriptor);
            return classDescriptor;
        });
    }

    @Override
    public void onConfigurationFailure(ITestResult result) {
        Optional<ClassDescriptor> classDescriptor = this.testClassRegistry.get(result.getTestClass().getRealClass());
        if (classDescriptor.isPresent()) {
            this.classFailures.computeIfAbsent(classDescriptor.get(), __ -> ConcurrentHashMap.newKeySet()).add(result.getThrowable());
        } else {
            this.engineFailures.add(result.getThrowable());
        }
    }

    @Override
    public void onAfterClass(ITestClass testClass) {
        this.testClassRegistry.finish(testClass.getRealClass(), classDescriptor -> {
            this.finishMethodsNotYetReportedAsFinished(testClass);
            Set<Throwable> failures = this.classFailures.remove(classDescriptor);
            this.delegate.executionFinished((TestDescriptor)classDescriptor, this.toTestExecutionResult(failures));
        });
    }

    @Override
    public void onTestStart(ITestResult result) {
        MethodProgress progress = this.startMethodProgress(result);
        int invocationIndex = progress.invocationIndex.getAndIncrement();
        if (invocationIndex == 0) {
            this.reportStarted(result, progress);
        }
        if (progress.descriptor.getType().isContainer()) {
            try {
                progress.reportedAsStarted.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while waiting for test method to be reported as started");
            }
            this.createInvocationAndReportStarted(progress, invocationIndex, result);
        }
    }

    @Override
    public void onTestSuccess(ITestResult result) {
        this.reportFinished(result, TestExecutionResult.successful());
    }

    @Override
    public void onTestSkipped(ITestResult result) {
        MethodProgress progress = this.inProgressTestMethods.get(result.getMethod());
        if (progress != null || result.getThrowable() != null) {
            if (progress == null) {
                this.reportStarted(result, this.startMethodProgress(result));
            }
            this.reportFinished(result, TestExecutionResult.aborted((Throwable)result.getThrowable()));
        } else {
            MethodDescriptor methodDescriptor = this.findOrCreateMethodDescriptor(result);
            this.delegate.executionSkipped((TestDescriptor)methodDescriptor, "<unknown>");
        }
    }

    @Override
    public void onTestFailure(ITestResult result) {
        this.reportFinished(result, TestExecutionResult.failed((Throwable)result.getThrowable()));
    }

    @Override
    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        this.onTestSuccess(result);
    }

    @Override
    public void onTestFailedWithTimeout(ITestResult result) {
        this.onTestFailure(result);
    }

    private MethodProgress startMethodProgress(ITestResult result) {
        MethodDescriptor methodDescriptor = this.findOrCreateMethodDescriptor(result);
        return this.inProgressTestMethods.computeIfAbsent(result.getMethod(), __ -> new MethodProgress(result.getMethod(), methodDescriptor));
    }

    private void finishMethodsNotYetReportedAsFinished(ITestClass testClass) {
        for (ITestNGMethod testMethod : testClass.getTestMethods()) {
            MethodProgress progress = this.inProgressTestMethods.remove(testMethod);
            if (progress == null) continue;
            this.delegate.executionFinished((TestDescriptor)progress.descriptor, TestExecutionResult.successful());
        }
    }

    private void reportStarted(ITestResult result, MethodProgress progress) {
        Map<String, String> attributes;
        this.delegate.executionStarted((TestDescriptor)progress.descriptor);
        progress.reportedAsStarted.countDown();
        String description = result.getMethod().getDescription();
        if (description != null && !description.trim().isEmpty()) {
            this.delegate.reportingEntryPublished((TestDescriptor)progress.descriptor, ReportEntry.from((String)"description", (String)description.trim()));
        }
        if (!(attributes = this.getAttributes(result)).isEmpty()) {
            this.delegate.reportingEntryPublished((TestDescriptor)progress.descriptor, ReportEntry.from(attributes));
        }
    }

    private void reportFinished(ITestResult result, TestExecutionResult executionResult) {
        MethodProgress progress = this.inProgressTestMethods.get(result.getMethod());
        if (progress.descriptor.getType().isContainer() && progress.invocations.containsKey(result)) {
            InvocationDescriptor invocationDescriptor = (InvocationDescriptor)((Object)progress.invocations.remove(result));
            this.delegate.executionFinished((TestDescriptor)invocationDescriptor, executionResult);
        } else {
            this.inProgressTestMethods.remove(result.getMethod());
            this.delegate.executionFinished((TestDescriptor)progress.descriptor, executionResult);
        }
    }

    private MethodDescriptor findOrCreateMethodDescriptor(ITestResult result) {
        ClassDescriptor classDescriptor = this.testClassRegistry.get(result.getTestClass().getRealClass()).orElseThrow(() -> new IllegalStateException("Missing class descriptor for " + result.getTestClass()));
        Optional<MethodDescriptor> methodDescriptor = classDescriptor.findMethodDescriptor(result);
        if (methodDescriptor.isPresent()) {
            return methodDescriptor.get();
        }
        MethodDescriptor dynamicMethodDescriptor = this.getTestDescriptorFactory().createMethodDescriptor(classDescriptor, result);
        classDescriptor.addChild((TestDescriptor)dynamicMethodDescriptor);
        this.delegate.dynamicTestRegistered((TestDescriptor)dynamicMethodDescriptor);
        return dynamicMethodDescriptor;
    }

    private void createInvocationAndReportStarted(MethodProgress progress, int invocationIndex, ITestResult result) {
        InvocationDescriptor invocationDescriptor = this.getTestDescriptorFactory().createInvocationDescriptor(progress.descriptor, result, invocationIndex);
        progress.invocations.put(result, invocationDescriptor);
        progress.descriptor.addChild((TestDescriptor)invocationDescriptor);
        this.delegate.dynamicTestRegistered((TestDescriptor)invocationDescriptor);
        this.delegate.executionStarted((TestDescriptor)invocationDescriptor);
    }

    private TestDescriptorFactory getTestDescriptorFactory() {
        return this.engineDescriptor.getTestDescriptorFactory();
    }

    public TestExecutionResult toEngineResult() {
        return this.toTestExecutionResult(this.engineFailures);
    }

    private TestExecutionResult toTestExecutionResult(Set<Throwable> failures) {
        return failures == null || failures.isEmpty() ? TestExecutionResult.successful() : TestExecutionResult.failed((Throwable)this.chain(failures));
    }

    private Throwable chain(Set<Throwable> failures) {
        Iterator<Throwable> iterator = failures.iterator();
        Throwable throwable = iterator.next();
        iterator.forEachRemaining(throwable::addSuppressed);
        return throwable;
    }

    private Map<String, String> getAttributes(ITestResult result) {
        try {
            CustomAttribute[] attributes = result.getMethod().getAttributes();
            if (attributes.length > 0) {
                return Arrays.stream(attributes).collect(Collectors.toMap(CustomAttribute::name, attr -> String.join((CharSequence)", ", attr.values())));
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        return Collections.emptyMap();
    }

    static class MethodProgress {
        final ITestNGMethod method;
        final MethodDescriptor descriptor;
        final ConcurrentMap<ITestResult, InvocationDescriptor> invocations = new ConcurrentHashMap<ITestResult, InvocationDescriptor>();
        final AtomicInteger invocationIndex = new AtomicInteger();
        final CountDownLatch reportedAsStarted = new CountDownLatch(1);

        public MethodProgress(ITestNGMethod method, MethodDescriptor descriptor) {
            this.method = method;
            this.descriptor = descriptor;
        }
    }
}

