/*
 * Decompiled with CFR 0.152.
 */
package org.junit.support.testng.engine;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.support.testng.engine.ClassDescriptor;

class TestClassRegistry {
    private final Set<ClassDescriptor> classDescriptors = ConcurrentHashMap.newKeySet();
    private final Map<Class<?>, Entry> testClasses = new ConcurrentHashMap();

    TestClassRegistry() {
    }

    void start(Class<?> testClass, Function<Class<?>, ClassDescriptor> onFirst) {
        Entry entry = this.testClasses.computeIfAbsent(testClass, __ -> {
            ClassDescriptor classDescriptor = (ClassDescriptor)((Object)((Object)onFirst.apply(testClass)));
            if (classDescriptor != null) {
                this.classDescriptors.add(classDescriptor);
                return new Entry(classDescriptor);
            }
            return null;
        });
        if (entry != null) {
            entry.inProgress.incrementAndGet();
        }
    }

    Optional<ClassDescriptor> get(Class<?> testClass) {
        Entry entry = this.testClasses.get(testClass);
        return Optional.ofNullable(entry).map(it -> it.descriptor);
    }

    void finish(Class<?> testClass, Consumer<ClassDescriptor> onLast) {
        this.testClasses.compute(testClass, (__, value) -> {
            if (value == null) {
                return null;
            }
            int inProgress = value.inProgress.decrementAndGet();
            if (inProgress == 0) {
                onLast.accept(value.descriptor);
                return null;
            }
            return value;
        });
    }

    Set<ClassDescriptor> getClassDescriptors() {
        return this.classDescriptors;
    }

    private static class Entry {
        final ClassDescriptor descriptor;
        final AtomicInteger inProgress = new AtomicInteger(0);

        Entry(ClassDescriptor descriptor) {
            this.descriptor = descriptor;
        }
    }
}

