/*
 * Decompiled with CFR 0.152.
 */
package org.junit.support.testng.engine;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.support.testng.engine.ClassDescriptor;
import org.junit.support.testng.engine.InvocationDescriptor;
import org.junit.support.testng.engine.MethodDescriptor;
import org.junit.support.testng.engine.MethodSignature;
import org.junit.support.testng.engine.TestAnnotationUtils;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.internal.annotations.DisabledRetryAnalyzer;

class TestDescriptorFactory {
    private final Map<String, TestTag> testTags = new ConcurrentHashMap<String, TestTag>();

    TestDescriptorFactory() {
    }

    ClassDescriptor createClassDescriptor(TestDescriptor parent, Class<?> testClass) {
        UniqueId uniqueId = parent.getUniqueId().append("class", testClass.getName());
        Set<TestTag> tags = TestAnnotationUtils.collectGroups(testClass).map(this::createTag).collect(Collectors.toSet());
        return new ClassDescriptor(uniqueId, testClass, tags);
    }

    MethodDescriptor createMethodDescriptor(ClassDescriptor parent, ITestResult result) {
        ITestNGMethod method = result.getMethod();
        MethodSignature methodSignature = MethodSignature.from(method);
        String name = methodSignature.parameterTypes.length > 0 ? methodSignature.stringRepresentation : result.getName();
        UniqueId uniqueId = parent.getUniqueId().append("method", MethodDescriptor.toMethodId(result, methodSignature));
        Class sourceClass = method.getTestClass().getRealClass();
        Set<TestTag> tags = Arrays.stream(method.getGroups()).map(this::createTag).collect(Collectors.toSet());
        TestDescriptor.Type type = this.reportsInvocations(method) ? TestDescriptor.Type.CONTAINER : TestDescriptor.Type.TEST;
        return new MethodDescriptor(uniqueId, name, sourceClass, methodSignature, tags, type);
    }

    private boolean reportsInvocations(ITestNGMethod method) {
        return this.isDataDriven(method) || method.getInvocationCount() > 1 || method.getThreadPoolSize() > 0 || this.getRetryAnalyzerClass(method) != this.getDefaultRetryAnalyzer();
    }

    private Class<?> getRetryAnalyzerClass(ITestNGMethod method) {
        try {
            return method.getRetryAnalyzerClass();
        }
        catch (NoSuchMethodError ignore) {
            return TestAnnotationUtils.getRetryAnalyzer(method);
        }
    }

    private Class<?> getDefaultRetryAnalyzer() {
        try {
            return DisabledRetryAnalyzer.class;
        }
        catch (NoClassDefFoundError ignore) {
            return Class.class;
        }
    }

    private boolean isDataDriven(ITestNGMethod method) {
        try {
            return method.isDataDriven();
        }
        catch (NoSuchMethodError ignore) {
            return TestAnnotationUtils.getDataProvider(method).isPresent() || TestAnnotationUtils.getDataProviderClass(method).isPresent();
        }
    }

    InvocationDescriptor createInvocationDescriptor(MethodDescriptor parent, ITestResult result, int invocationIndex) {
        String displayName;
        UniqueId uniqueId = parent.getUniqueId().append("invoc", String.valueOf(invocationIndex));
        Object[] parameters = result.getParameters();
        if (parameters.length > 0) {
            String paramList = Arrays.stream(parameters).map(String::valueOf).collect(Collectors.joining(", "));
            displayName = String.format("[%d] %s", invocationIndex, paramList);
        } else {
            displayName = String.format("[%d]", invocationIndex);
        }
        String legacyReportingName = String.format("%s[%d]", parent.getLegacyReportingName(), invocationIndex);
        return new InvocationDescriptor(uniqueId, displayName, legacyReportingName, parent.getMethodSource());
    }

    private TestTag createTag(String value) {
        return this.testTags.computeIfAbsent(value, TestTag::create);
    }
}

