/*
 * Decompiled with CFR 0.152.
 */
package org.junit.support.testng.engine;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.support.testng.engine.ClassDescriptor;
import org.junit.support.testng.engine.TestDescriptorFactory;

class TestNGEngineDescriptor
extends EngineDescriptor {
    private final TestDescriptorFactory testDescriptorFactory = new TestDescriptorFactory();
    private final Map<Class<?>, ClassDescriptor> classDescriptorsByTestClass = new HashMap();

    public TestNGEngineDescriptor(UniqueId uniqueId) {
        super(uniqueId, "TestNG");
    }

    public TestDescriptorFactory getTestDescriptorFactory() {
        return this.testDescriptorFactory;
    }

    public void addChild(TestDescriptor child) {
        ClassDescriptor classDescriptor = (ClassDescriptor)child;
        this.classDescriptorsByTestClass.put(classDescriptor.getTestClass(), classDescriptor);
        super.addChild(child);
    }

    public void removeChild(TestDescriptor child) {
        this.classDescriptorsByTestClass.remove(((ClassDescriptor)child).getTestClass());
        super.removeChild(child);
    }

    public ClassDescriptor findClassDescriptor(Class<?> testClass) {
        return this.classDescriptorsByTestClass.get(testClass);
    }

    Set<ClassDescriptor> getClassDescriptors() {
        return this.classDescriptors().collect(Collectors.toSet());
    }

    Class<?>[] getTestClasses() {
        return (Class[])this.classDescriptors().map(it -> it.executionStrategy.getTestClass().orElse(null)).filter(Objects::nonNull).toArray(Class[]::new);
    }

    List<String> getQualifiedMethodNames() {
        return this.classDescriptors().flatMap(it -> it.executionStrategy.getTestMethods().stream().map(methodName -> it.getTestClass().getName() + "." + methodName)).collect(Collectors.toList());
    }

    void prepareExecution() {
        this.classDescriptors().forEach(ClassDescriptor::prepareExecution);
    }

    private Stream<ClassDescriptor> classDescriptors() {
        return this.getChildren().stream().map(child -> (ClassDescriptor)((Object)child));
    }
}

