/*
 * Decompiled with CFR 0.152.
 */
package org.junit.support.testng.engine;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.support.testng.engine.MethodDescriptor;
import org.junit.support.testng.engine.MethodSignature;
import org.testng.ITestResult;

class ClassDescriptor
extends AbstractTestDescriptor {
    static final String SEGMENT_TYPE = "class";
    private final ConcurrentMap<String, MethodDescriptor> methodsById = new ConcurrentHashMap<String, MethodDescriptor>();
    private final Class<?> testClass;
    private final Set<TestTag> tags;
    final AtomicInteger remainingIterations = new AtomicInteger();
    ExecutionStrategy executionStrategy = new IncludeMethodsExecutionStrategy();

    ClassDescriptor(UniqueId uniqueId, Class<?> testClass, Set<TestTag> tags) {
        super(uniqueId, testClass.getSimpleName(), (TestSource)ClassSource.from(testClass));
        this.testClass = testClass;
        this.tags = tags;
    }

    public String getLegacyReportingName() {
        return this.testClass.getName();
    }

    Class<?> getTestClass() {
        return this.testClass;
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public Set<TestTag> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    public void addChild(TestDescriptor child) {
        this.methodsById.put(this.toChildKey(child), (MethodDescriptor)child);
        super.addChild(child);
    }

    public void removeChild(TestDescriptor child) {
        this.methodsById.remove(this.toChildKey(child));
        super.removeChild(child);
    }

    private String toChildKey(TestDescriptor child) {
        return child.getUniqueId().getLastSegment().getValue();
    }

    public Optional<MethodDescriptor> findMethodDescriptor(ITestResult result) {
        return Optional.ofNullable((MethodDescriptor)((Object)this.methodsById.get(MethodDescriptor.toMethodId(result, MethodSignature.from(result.getMethod())))));
    }

    public void includeTestMethod(String methodName) {
        this.executionStrategy = this.executionStrategy.includeMethod(methodName);
    }

    public void selectEntireClass() {
        this.executionStrategy = this.executionStrategy.selectEntireClass();
    }

    public void prepareExecution() {
        this.executionStrategy = new IncludeMethodsExecutionStrategy(this.getChildren().stream().map(child -> (MethodDescriptor)((Object)child)).map(MethodDescriptor::getMethodSource).map(MethodSource::getMethodName));
    }

    class IncludeMethodsExecutionStrategy
    implements ExecutionStrategy {
        private final Set<String> testMethods = new LinkedHashSet<String>();

        public IncludeMethodsExecutionStrategy() {
        }

        public IncludeMethodsExecutionStrategy(Stream<String> testMethods) {
            testMethods.forEach(this.testMethods::add);
        }

        @Override
        public Optional<Class<?>> getTestClass() {
            return Optional.empty();
        }

        @Override
        public Set<String> getTestMethods() {
            return this.testMethods;
        }

        @Override
        public ExecutionStrategy selectEntireClass() {
            return new EntireClassExecutionStrategy();
        }

        @Override
        public ExecutionStrategy includeMethod(String methodName) {
            this.testMethods.add(methodName);
            return this;
        }
    }

    static interface ExecutionStrategy {
        public Optional<Class<?>> getTestClass();

        public Set<String> getTestMethods();

        public ExecutionStrategy selectEntireClass();

        public ExecutionStrategy includeMethod(String var1);
    }

    class EntireClassExecutionStrategy
    implements ExecutionStrategy {
        EntireClassExecutionStrategy() {
        }

        @Override
        public Optional<Class<?>> getTestClass() {
            return Optional.of(ClassDescriptor.this.testClass);
        }

        @Override
        public Set<String> getTestMethods() {
            return Collections.emptySet();
        }

        @Override
        public ExecutionStrategy selectEntireClass() {
            return this;
        }

        @Override
        public ExecutionStrategy includeMethod(String methodName) {
            return this;
        }
    }
}

