/*
 * Decompiled with CFR 0.152.
 */
package org.junit.support.testng.engine;

import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.junit.support.testng.engine.DefaultListener;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.xml.XmlSuite;

class LoggingListener
extends DefaultListener {
    static final LoggingListener INSTANCE = new LoggingListener();
    private static final Logger LOGGER = Logger.getLogger(LoggingListener.class.getName());

    private LoggingListener() {
    }

    @Override
    public void alter(List<XmlSuite> suites) {
        this.log(() -> "alter: " + suites);
    }

    @Override
    public void onBeforeClass(ITestClass testClass) {
        this.log(() -> "onBeforeClass: " + testClass);
    }

    @Override
    public void onAfterClass(ITestClass testClass) {
        this.log(() -> "onAfterClass: " + testClass);
    }

    @Override
    public void onTestStart(ITestResult result) {
        this.log(() -> "onTestStart: " + result);
    }

    @Override
    public void onTestSuccess(ITestResult result) {
        this.log(() -> "onTestSuccess: " + result);
    }

    @Override
    public void onTestFailure(ITestResult result) {
        this.log(() -> "onTestFailure: " + result);
    }

    @Override
    public void onTestSkipped(ITestResult result) {
        this.log(() -> "onTestSkipped: " + result);
    }

    @Override
    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        this.log(() -> "onTestFailedButWithinSuccessPercentage: " + result);
    }

    @Override
    public void onTestFailedWithTimeout(ITestResult result) {
        this.log(() -> "onTestFailedWithTimeout: " + result);
    }

    @Override
    public void onStart(ITestContext context) {
        this.log(() -> "onStart: " + context);
    }

    @Override
    public void onFinish(ITestContext context) {
        this.log(() -> "onFinish: " + context);
    }

    @Override
    public void onConfigurationSuccess(ITestResult tr) {
        this.log(() -> "onConfigurationSuccess: " + tr);
    }

    @Override
    public void onConfigurationSuccess(ITestResult tr, ITestNGMethod tm) {
        this.log(() -> "onConfigurationSuccess: " + tr + ", " + tm);
    }

    @Override
    public void onConfigurationFailure(ITestResult tr) {
        this.log(() -> "onConfigurationFailure: " + tr);
    }

    @Override
    public void onConfigurationFailure(ITestResult tr, ITestNGMethod tm) {
        this.log(() -> "onConfigurationFailure: " + tr + ", " + tm);
    }

    @Override
    public void onConfigurationSkip(ITestResult tr) {
        this.log(() -> "onConfigurationSkip: " + tr);
    }

    @Override
    public void onConfigurationSkip(ITestResult tr, ITestNGMethod tm) {
        this.log(() -> "onConfigurationSkip: " + tr + ", " + tm);
    }

    @Override
    public void beforeConfiguration(ITestResult tr) {
        this.log(() -> "beforeConfiguration: " + tr);
    }

    @Override
    public void beforeConfiguration(ITestResult tr, ITestNGMethod tm) {
        this.log(() -> "beforeConfiguration: " + tr + ", " + tm);
    }

    private void log(Supplier<String> message) {
        LOGGER.fine(message);
    }
}

