/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.registry.zookeeper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.CreateMode;
import org.jupiter.common.concurrent.collection.ConcurrentSet;
import org.jupiter.common.util.Function;
import org.jupiter.common.util.Lists;
import org.jupiter.common.util.Maps;
import org.jupiter.common.util.NetUtil;
import org.jupiter.common.util.Preconditions;
import org.jupiter.common.util.StackTraceUtil;
import org.jupiter.common.util.Strings;
import org.jupiter.common.util.SystemPropertyUtil;
import org.jupiter.common.util.internal.logging.InternalLogger;
import org.jupiter.common.util.internal.logging.InternalLoggerFactory;
import org.jupiter.registry.AbstractRegistryService;
import org.jupiter.registry.NotifyListener;
import org.jupiter.registry.RegisterMeta;

public class ZookeeperRegistryService
extends AbstractRegistryService {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ZookeeperRegistryService.class);
    private static final AtomicLong sequence = new AtomicLong(0L);
    private final String address = SystemPropertyUtil.get((String)"jupiter.local.address", (String)NetUtil.getLocalAddress());
    private final int sessionTimeoutMs = SystemPropertyUtil.getInt((String)"jupiter.registry.zookeeper.sessionTimeoutMs", (int)60000);
    private final int connectionTimeoutMs = SystemPropertyUtil.getInt((String)"jupiter.registry.zookeeper.connectionTimeoutMs", (int)15000);
    private final ConcurrentMap<RegisterMeta.ServiceMeta, PathChildrenCache> pathChildrenCaches = Maps.newConcurrentMap();
    private final ConcurrentMap<RegisterMeta.Address, ConcurrentSet<RegisterMeta.ServiceMeta>> serviceMetaMap = Maps.newConcurrentMap();
    private CuratorFramework configClient;

    public Collection<RegisterMeta> lookup(RegisterMeta.ServiceMeta serviceMeta) {
        ArrayList registerMetaList;
        block3: {
            String directory = String.format("/jupiter/provider/%s/%s/%s", serviceMeta.getGroup(), serviceMeta.getVersion(), serviceMeta.getServiceProviderName());
            registerMetaList = Lists.newArrayList();
            try {
                List paths = (List)this.configClient.getChildren().forPath(directory);
                for (String p : paths) {
                    registerMetaList.add(this.parseRegisterMeta(String.format("%s/%s", directory, p)));
                }
            }
            catch (Exception e) {
                if (!logger.isWarnEnabled()) break block3;
                logger.warn("Lookup service meta: {} path failed, {}.", (Object)serviceMeta, (Object)StackTraceUtil.stackTrace((Throwable)e));
            }
        }
        return registerMetaList;
    }

    protected void doSubscribe(RegisterMeta.ServiceMeta serviceMeta) {
        block3: {
            String directory;
            PathChildrenCache newChildrenCache;
            PathChildrenCache childrenCache = (PathChildrenCache)this.pathChildrenCaches.get(serviceMeta);
            if (childrenCache == null && (childrenCache = this.pathChildrenCaches.putIfAbsent(serviceMeta, newChildrenCache = new PathChildrenCache(this.configClient, directory = String.format("/jupiter/provider/%s/%s/%s", serviceMeta.getGroup(), serviceMeta.getServiceProviderName(), serviceMeta.getVersion()), false))) == null) {
                childrenCache = newChildrenCache;
                childrenCache.getListenable().addListener((Object)new PathChildrenCacheListener(){

                    public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
                        logger.info("Child event: {}", (Object)event);
                        switch (event.getType()) {
                            case CHILD_ADDED: {
                                RegisterMeta registerMeta = ZookeeperRegistryService.this.parseRegisterMeta(event.getData().getPath());
                                RegisterMeta.Address address = registerMeta.getAddress();
                                RegisterMeta.ServiceMeta serviceMeta = registerMeta.getServiceMeta();
                                ConcurrentSet serviceMetaSet = ZookeeperRegistryService.this.getServiceMeta(address);
                                serviceMetaSet.add((Object)serviceMeta);
                                ZookeeperRegistryService.this.notify(serviceMeta, NotifyListener.NotifyEvent.CHILD_ADDED, sequence.getAndIncrement(), new RegisterMeta[]{registerMeta});
                                break;
                            }
                            case CHILD_REMOVED: {
                                RegisterMeta registerMeta = ZookeeperRegistryService.this.parseRegisterMeta(event.getData().getPath());
                                RegisterMeta.Address address = registerMeta.getAddress();
                                RegisterMeta.ServiceMeta serviceMeta = registerMeta.getServiceMeta();
                                ConcurrentSet serviceMetaSet = ZookeeperRegistryService.this.getServiceMeta(address);
                                serviceMetaSet.remove((Object)serviceMeta);
                                ZookeeperRegistryService.this.notify(serviceMeta, NotifyListener.NotifyEvent.CHILD_REMOVED, sequence.getAndIncrement(), new RegisterMeta[]{registerMeta});
                                if (!serviceMetaSet.isEmpty()) break;
                                logger.info("Offline notify: {}.", (Object)address);
                                ZookeeperRegistryService.this.offline(address);
                                break;
                            }
                        }
                    }
                });
                try {
                    childrenCache.start();
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block3;
                    logger.warn("Subscribe {} failed, {}.", (Object)directory, (Object)StackTraceUtil.stackTrace((Throwable)e));
                }
            }
        }
    }

    protected void doRegister(final RegisterMeta meta) {
        block6: {
            String directory;
            block5: {
                directory = String.format("/jupiter/provider/%s/%s/%s", meta.getGroup(), meta.getServiceProviderName(), meta.getVersion());
                try {
                    if (this.configClient.checkExists().forPath(directory) == null) {
                        this.configClient.create().creatingParentsIfNeeded().forPath(directory);
                    }
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block5;
                    logger.warn("Create parent path failed, directory: {}, {}.", (Object)directory, (Object)StackTraceUtil.stackTrace((Throwable)e));
                }
            }
            try {
                meta.setHost(this.address);
                ((PathAndBytesable)((ACLBackgroundPathAndBytesable)this.configClient.create().withMode(CreateMode.EPHEMERAL)).inBackground(new BackgroundCallback(){

                    public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
                        ZookeeperRegistryService.this.registerMetaSet().add((Object)meta);
                        logger.info("Register: {}.", (Object)meta);
                    }
                })).forPath(String.format("%s/%s:%s:%s:%s", directory, meta.getHost(), String.valueOf(meta.getPort()), String.valueOf(meta.getWeight()), String.valueOf(meta.getConnCount())));
            }
            catch (Exception e) {
                if (!logger.isWarnEnabled()) break block6;
                logger.warn("Create register meta: {} path failed, {}.", (Object)meta, (Object)StackTraceUtil.stackTrace((Throwable)e));
            }
        }
    }

    protected void doUnregister(final RegisterMeta meta) {
        block6: {
            String directory;
            block5: {
                directory = String.format("/jupiter/provider/%s/%s/%s", meta.getGroup(), meta.getServiceProviderName(), meta.getVersion());
                try {
                    if (this.configClient.checkExists().forPath(directory) == null) {
                        return;
                    }
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block5;
                    logger.warn("Check exists with parent path failed, directory: {}, {}.", (Object)directory, (Object)StackTraceUtil.stackTrace((Throwable)e));
                }
            }
            try {
                meta.setHost(this.address);
                ((Pathable)this.configClient.delete().inBackground(new BackgroundCallback(){

                    public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
                        ZookeeperRegistryService.this.registerMetaSet().remove((Object)meta);
                        logger.info("Unregister: {}.", (Object)meta);
                    }
                })).forPath(String.format("%s/%s:%s:%s:%s", directory, meta.getHost(), String.valueOf(meta.getPort()), String.valueOf(meta.getWeight()), String.valueOf(meta.getConnCount())));
            }
            catch (Exception e) {
                if (!logger.isWarnEnabled()) break block6;
                logger.warn("Delete register meta: {} path failed, {}.", (Object)meta, (Object)StackTraceUtil.stackTrace((Throwable)e));
            }
        }
    }

    public void connectToRegistryServer(String connectString) {
        Preconditions.checkNotNull((Object)connectString, (Object)"connectString");
        this.configClient = CuratorFrameworkFactory.newClient((String)connectString, (int)this.sessionTimeoutMs, (int)this.connectionTimeoutMs, (RetryPolicy)new ExponentialBackoffRetry(500, 20));
        this.configClient.getConnectionStateListenable().addListener((Object)new ConnectionStateListener(){

            public void stateChanged(CuratorFramework client, ConnectionState newState) {
                logger.info("Zookeeper connection state changed {}.", (Object)newState);
                if (newState == ConnectionState.RECONNECTED) {
                    logger.info("Zookeeper connection has been re-established, will re-subscribe and re-register.");
                    for (RegisterMeta.ServiceMeta serviceMeta : ZookeeperRegistryService.this.subscribeSet()) {
                        ZookeeperRegistryService.this.doSubscribe(serviceMeta);
                    }
                    for (RegisterMeta meta : ZookeeperRegistryService.this.registerMetaSet()) {
                        ZookeeperRegistryService.this.doRegister(meta);
                    }
                }
            }
        });
        this.configClient.start();
    }

    public void destroy() {
        for (PathChildrenCache childrenCache : this.pathChildrenCaches.values()) {
            try {
                childrenCache.close();
            }
            catch (IOException iOException) {}
        }
        this.configClient.close();
    }

    public List<RegisterMeta.ServiceMeta> findServiceMetaByAddress(RegisterMeta.Address address) {
        return Lists.transform((List)Lists.newArrayList(this.getServiceMeta(address)), (Function)new Function<RegisterMeta.ServiceMeta, RegisterMeta.ServiceMeta>(){

            public RegisterMeta.ServiceMeta apply(RegisterMeta.ServiceMeta input) {
                RegisterMeta.ServiceMeta copy = new RegisterMeta.ServiceMeta();
                copy.setGroup(input.getGroup());
                copy.setServiceProviderName(input.getServiceProviderName());
                copy.setVersion(input.getVersion());
                return copy;
            }
        });
    }

    private RegisterMeta parseRegisterMeta(String data) {
        String[] array_0 = Strings.split((String)data, (char)'/');
        RegisterMeta meta = new RegisterMeta();
        meta.setGroup(array_0[2]);
        meta.setServiceProviderName(array_0[3]);
        meta.setVersion(array_0[4]);
        String[] array_1 = Strings.split((String)array_0[5], (char)':');
        meta.setHost(array_1[0]);
        meta.setPort(Integer.parseInt(array_1[1]));
        meta.setWeight(Integer.parseInt(array_1[2]));
        meta.setConnCount(Integer.parseInt(array_1[3]));
        return meta;
    }

    private ConcurrentSet<RegisterMeta.ServiceMeta> getServiceMeta(RegisterMeta.Address address) {
        ConcurrentSet newServiceMetaSet;
        ConcurrentSet serviceMetaSet = (ConcurrentSet)this.serviceMetaMap.get(address);
        if (serviceMetaSet == null && (serviceMetaSet = this.serviceMetaMap.putIfAbsent(address, (ConcurrentSet<RegisterMeta.ServiceMeta>)(newServiceMetaSet = new ConcurrentSet()))) == null) {
            serviceMetaSet = newServiceMetaSet;
        }
        return serviceMetaSet;
    }
}

