/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.mock;

import org.jupnp.UpnpService;
import org.jupnp.UpnpServiceConfiguration;
import org.jupnp.controlpoint.ControlPoint;
import org.jupnp.controlpoint.ControlPointImpl;
import org.jupnp.mock.MockRouter;
import org.jupnp.mock.MockUpnpServiceConfiguration;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.protocol.ProtocolFactoryImpl;
import org.jupnp.protocol.async.SendingNotificationAlive;
import org.jupnp.protocol.async.SendingSearch;
import org.jupnp.registry.Registry;
import org.jupnp.registry.RegistryImpl;
import org.jupnp.registry.RegistryMaintainer;
import org.jupnp.transport.RouterException;
import org.jupnp.transport.spi.NetworkAddressFactory;

public class MockUpnpService
implements UpnpService {
    protected UpnpServiceConfiguration configuration;
    protected ControlPoint controlPoint;
    protected ProtocolFactory protocolFactory;
    protected Registry registry;
    protected MockRouter router;
    protected NetworkAddressFactory networkAddressFactory;
    private boolean sendsAlive;

    public MockUpnpService() {
        this(false, new MockUpnpServiceConfiguration(false, false));
    }

    public MockUpnpService(MockUpnpServiceConfiguration configuration) {
        this(false, configuration);
    }

    public MockUpnpService(boolean sendsAlive, boolean maintainsRegistry) {
        this(sendsAlive, new MockUpnpServiceConfiguration(maintainsRegistry, false));
    }

    public MockUpnpService(boolean sendsAlive, boolean maintainsRegistry, boolean multiThreaded) {
        this(sendsAlive, new MockUpnpServiceConfiguration(maintainsRegistry, multiThreaded));
    }

    public MockUpnpService(boolean sendsAlive, MockUpnpServiceConfiguration configuration) {
        this.sendsAlive = sendsAlive;
        this.configuration = configuration;
    }

    protected ProtocolFactory createProtocolFactory(UpnpService service, boolean sendsAlive) {
        return new MockProtocolFactory(service, sendsAlive);
    }

    protected MockRouter createRouter() {
        return new MockRouter(this.getConfiguration(), this.getProtocolFactory());
    }

    @Override
    public UpnpServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ControlPoint getControlPoint() {
        return this.controlPoint;
    }

    @Override
    public ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public MockRouter getRouter() {
        return this.router;
    }

    @Override
    public void shutdown() {
        this.getRegistry().shutdown();
        this.getConfiguration().shutdown();
    }

    @Override
    public void startup() {
        this.protocolFactory = this.createProtocolFactory(this, this.sendsAlive);
        this.registry = new RegistryImpl(this){

            @Override
            protected RegistryMaintainer createRegistryMaintainer() {
                return ((MockUpnpServiceConfiguration)MockUpnpService.this.configuration).isMaintainsRegistry() ? super.createRegistryMaintainer() : null;
            }
        };
        this.networkAddressFactory = this.configuration.createNetworkAddressFactory();
        this.router = this.createRouter();
        this.controlPoint = new ControlPointImpl(this.configuration, this.protocolFactory, this.registry);
    }

    public static class MockProtocolFactory
    extends ProtocolFactoryImpl {
        private boolean sendsAlive;

        public MockProtocolFactory(UpnpService upnpService, boolean sendsAlive) {
            super(upnpService);
            this.sendsAlive = sendsAlive;
        }

        @Override
        public SendingNotificationAlive createSendingNotificationAlive(LocalDevice localDevice) {
            return new SendingNotificationAlive(this.getUpnpService(), localDevice){

                @Override
                protected void execute() throws RouterException {
                    if (MockProtocolFactory.this.sendsAlive) {
                        super.execute();
                    }
                }
            };
        }

        @Override
        public SendingSearch createSendingSearch(UpnpHeader searchTarget, int mxSeconds) {
            return new SendingSearch(this.getUpnpService(), searchTarget, mxSeconds){

                @Override
                public int getBulkIntervalMilliseconds() {
                    return 0;
                }
            };
        }
    }
}

