/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.action;

import java.util.HashMap;
import java.util.Map;
import org.jupnp.model.Command;
import org.jupnp.model.ServiceManager;
import org.jupnp.model.action.ActionArgumentValue;
import org.jupnp.model.action.ActionCancelledException;
import org.jupnp.model.action.ActionException;
import org.jupnp.model.action.ActionExecutor;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.meta.Action;
import org.jupnp.model.meta.ActionArgument;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.state.StateVariableAccessor;
import org.jupnp.model.types.ErrorCode;
import org.jupnp.model.types.InvalidValueException;
import org.jupnp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActionExecutor
implements ActionExecutor {
    private Logger log = LoggerFactory.getLogger(AbstractActionExecutor.class);
    protected Map<ActionArgument<LocalService>, StateVariableAccessor> outputArgumentAccessors = new HashMap<ActionArgument<LocalService>, StateVariableAccessor>();

    protected AbstractActionExecutor() {
    }

    protected AbstractActionExecutor(Map<ActionArgument<LocalService>, StateVariableAccessor> outputArgumentAccessors) {
        this.outputArgumentAccessors = outputArgumentAccessors;
    }

    public Map<ActionArgument<LocalService>, StateVariableAccessor> getOutputArgumentAccessors() {
        return this.outputArgumentAccessors;
    }

    @Override
    public void execute(final ActionInvocation<LocalService> actionInvocation) {
        this.log.trace("Invoking on local service: " + actionInvocation);
        LocalService service = actionInvocation.getAction().getService();
        try {
            if (service.getManager() == null) {
                throw new IllegalStateException("Service has no implementation factory, can't get service instance");
            }
            service.getManager().execute(new Command(){

                public void execute(ServiceManager serviceManager) throws Exception {
                    AbstractActionExecutor.this.execute(actionInvocation, serviceManager.getImplementation());
                }

                public String toString() {
                    return "Action invocation: " + actionInvocation.getAction();
                }
            });
        }
        catch (ActionException ex) {
            this.log.trace("ActionException thrown by service, wrapping in invocation and returning: " + ex);
            this.log.trace("Exception root cause: ", Exceptions.unwrap(ex));
            actionInvocation.setFailure(ex);
        }
        catch (InterruptedException ex) {
            this.log.trace("InterruptedException thrown by service, wrapping in invocation and returning: " + ex);
            this.log.trace("Exception root cause: ", Exceptions.unwrap(ex));
            actionInvocation.setFailure(new ActionCancelledException(ex));
        }
        catch (Throwable t) {
            Throwable rootCause = Exceptions.unwrap(t);
            this.log.trace("Execution has thrown, wrapping root cause in ActionException and returning: " + t);
            this.log.trace("Exception root cause: ", rootCause);
            actionInvocation.setFailure(new ActionException(ErrorCode.ACTION_FAILED, rootCause.getMessage() != null ? rootCause.getMessage() : rootCause.toString(), rootCause));
        }
    }

    protected abstract void execute(ActionInvocation<LocalService> var1, Object var2) throws Exception;

    protected Object readOutputArgumentValues(Action<LocalService> action, Object instance) throws Exception {
        Object[] results = new Object[action.getOutputArguments().length];
        this.log.trace("Attempting to retrieve output argument values using accessor: " + results.length);
        int i = 0;
        ActionArgument<LocalService>[] actionArgumentArray = action.getOutputArguments();
        int n = actionArgumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionArgument<LocalService> outputArgument = actionArgumentArray[n2];
            this.log.trace("Calling acccessor method for: " + outputArgument);
            StateVariableAccessor accessor = this.getOutputArgumentAccessors().get(outputArgument);
            if (accessor == null) {
                throw new IllegalStateException("No accessor bound for: " + outputArgument);
            }
            this.log.trace("Calling accessor to read output argument value: " + accessor);
            results[i++] = accessor.read(instance);
            ++n2;
        }
        if (results.length == 1) {
            return results[0];
        }
        return results.length > 0 ? results : null;
    }

    protected void setOutputArgumentValue(ActionInvocation<LocalService> actionInvocation, ActionArgument<LocalService> argument, Object result) throws ActionException {
        LocalService service = actionInvocation.getAction().getService();
        if (result != null) {
            try {
                if (service.isStringConvertibleType(result)) {
                    this.log.trace("Result of invocation matches convertible type, setting toString() single output argument value");
                    actionInvocation.setOutput(new ActionArgumentValue<LocalService>(argument, (Object)result.toString()));
                }
                this.log.trace("Result of invocation is Object, setting single output argument value");
                actionInvocation.setOutput(new ActionArgumentValue<LocalService>(argument, result));
            }
            catch (InvalidValueException ex) {
                throw new ActionException(ErrorCode.ARGUMENT_VALUE_INVALID, "Wrong type or invalid value for '" + argument.getName() + "': " + ex.getMessage(), (Throwable)ex);
            }
        } else {
            this.log.trace("Result of invocation is null, not setting any output argument value(s)");
        }
    }
}

