/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.controlpoint;

import java.util.Collections;
import org.jupnp.controlpoint.ControlPoint;
import org.jupnp.model.UnsupportedDataException;
import org.jupnp.model.gena.CancelReason;
import org.jupnp.model.gena.GENASubscription;
import org.jupnp.model.gena.LocalGENASubscription;
import org.jupnp.model.gena.RemoteGENASubscription;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.model.meta.Service;
import org.jupnp.protocol.ProtocolCreationException;
import org.jupnp.protocol.sync.SendingSubscribe;
import org.jupnp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SubscriptionCallback
implements Runnable {
    protected Logger log = LoggerFactory.getLogger(SubscriptionCallback.class);
    protected final Service service;
    protected final Integer requestedDurationSeconds;
    private ControlPoint controlPoint;
    private GENASubscription subscription;

    protected SubscriptionCallback(Service service) {
        this.service = service;
        this.requestedDurationSeconds = 1800;
    }

    protected SubscriptionCallback(Service service, int requestedDurationSeconds) {
        this.service = service;
        this.requestedDurationSeconds = requestedDurationSeconds;
    }

    public Service getService() {
        return this.service;
    }

    public synchronized ControlPoint getControlPoint() {
        return this.controlPoint;
    }

    public synchronized void setControlPoint(ControlPoint controlPoint) {
        this.controlPoint = controlPoint;
    }

    public synchronized GENASubscription getSubscription() {
        return this.subscription;
    }

    public synchronized void setSubscription(GENASubscription subscription) {
        this.subscription = subscription;
    }

    @Override
    public synchronized void run() {
        if (this.getControlPoint() == null) {
            throw new IllegalStateException("Callback must be executed through ControlPoint");
        }
        if (this.getService() instanceof LocalService) {
            this.establishLocalSubscription((LocalService)this.service);
        } else if (this.getService() instanceof RemoteService) {
            this.establishRemoteSubscription((RemoteService)this.service);
        }
    }

    private void establishLocalSubscription(LocalService service) {
        if (this.getControlPoint().getRegistry().getLocalDevice(((DeviceIdentity)((Device)service.getDevice()).getIdentity()).getUdn(), false) == null) {
            this.log.trace("Local device service is currently not registered, failing subscription immediately");
            this.failed(null, null, new IllegalStateException("Local device is not registered"));
            return;
        }
        LocalGENASubscription localSubscription = null;
        try {
            localSubscription = new LocalGENASubscription(service, Integer.MAX_VALUE, Collections.EMPTY_LIST){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void failed(Exception ex) {
                    SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                    synchronized (subscriptionCallback) {
                        SubscriptionCallback.this.setSubscription(null);
                        SubscriptionCallback.this.failed(null, null, ex);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void established() {
                    SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                    synchronized (subscriptionCallback) {
                        SubscriptionCallback.this.setSubscription(this);
                        SubscriptionCallback.this.established(this);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void ended(CancelReason reason) {
                    SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                    synchronized (subscriptionCallback) {
                        SubscriptionCallback.this.setSubscription(null);
                        SubscriptionCallback.this.ended(this, reason, null);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void eventReceived() {
                    SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                    synchronized (subscriptionCallback) {
                        SubscriptionCallback.this.log.trace("Local service state updated, notifying callback, sequence is: " + this.getCurrentSequence());
                        SubscriptionCallback.this.eventReceived(this);
                        this.incrementSequence();
                    }
                }
            };
            this.log.trace("Local device service is currently registered, also registering subscription");
            this.getControlPoint().getRegistry().addLocalSubscription(localSubscription);
            this.log.trace("Notifying subscription callback of local subscription availablity");
            localSubscription.establish();
            this.log.trace("Simulating first initial event for local subscription callback, sequence: " + localSubscription.getCurrentSequence());
            this.eventReceived(localSubscription);
            localSubscription.incrementSequence();
            this.log.trace("Starting to monitor state changes of local service");
            localSubscription.registerOnService();
        }
        catch (Exception ex) {
            this.log.trace("Local callback creation failed: " + ex.toString());
            this.log.trace("Exception root cause: ", Exceptions.unwrap(ex));
            if (localSubscription != null) {
                this.getControlPoint().getRegistry().removeLocalSubscription(localSubscription);
            }
            this.failed(localSubscription, null, ex);
        }
    }

    private void establishRemoteSubscription(RemoteService service) {
        SendingSubscribe protocol;
        RemoteGENASubscription remoteSubscription = new RemoteGENASubscription(service, this.requestedDurationSeconds){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void failed(UpnpResponse responseStatus) {
                SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                synchronized (subscriptionCallback) {
                    SubscriptionCallback.this.setSubscription(null);
                    SubscriptionCallback.this.failed(this, responseStatus, null);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void established() {
                SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                synchronized (subscriptionCallback) {
                    SubscriptionCallback.this.setSubscription(this);
                    SubscriptionCallback.this.established(this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void ended(CancelReason reason, UpnpResponse responseStatus) {
                SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                synchronized (subscriptionCallback) {
                    SubscriptionCallback.this.setSubscription(null);
                    SubscriptionCallback.this.ended(this, reason, responseStatus);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void eventReceived() {
                SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                synchronized (subscriptionCallback) {
                    SubscriptionCallback.this.eventReceived(this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void eventsMissed(int numberOfMissedEvents) {
                SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                synchronized (subscriptionCallback) {
                    SubscriptionCallback.this.eventsMissed(this, numberOfMissedEvents);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invalidMessage(UnsupportedDataException ex) {
                SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                synchronized (subscriptionCallback) {
                    SubscriptionCallback.this.invalidMessage(this, ex);
                }
            }
        };
        try {
            protocol = this.getControlPoint().getProtocolFactory().createSendingSubscribe(remoteSubscription);
        }
        catch (ProtocolCreationException ex) {
            this.failed(this.subscription, null, ex);
            return;
        }
        protocol.run();
    }

    public synchronized void end() {
        if (this.subscription == null) {
            return;
        }
        if (this.subscription instanceof LocalGENASubscription) {
            this.endLocalSubscription((LocalGENASubscription)this.subscription);
        } else if (this.subscription instanceof RemoteGENASubscription) {
            this.endRemoteSubscription((RemoteGENASubscription)this.subscription);
        }
    }

    private void endLocalSubscription(LocalGENASubscription subscription) {
        this.log.trace("Removing local subscription and ending it in callback: " + subscription);
        this.getControlPoint().getRegistry().removeLocalSubscription(subscription);
        subscription.end(null);
    }

    private void endRemoteSubscription(RemoteGENASubscription subscription) {
        this.log.trace("Ending remote subscription: " + subscription);
        this.getControlPoint().getConfiguration().getSyncProtocolExecutorService().execute(this.getControlPoint().getProtocolFactory().createSendingUnsubscribe(subscription));
    }

    protected void failed(GENASubscription subscription, UpnpResponse responseStatus, Exception exception) {
        this.failed(subscription, responseStatus, exception, SubscriptionCallback.createDefaultFailureMessage(responseStatus, exception));
    }

    protected abstract void failed(GENASubscription var1, UpnpResponse var2, Exception var3, String var4);

    protected abstract void established(GENASubscription var1);

    protected abstract void ended(GENASubscription var1, CancelReason var2, UpnpResponse var3);

    protected abstract void eventReceived(GENASubscription var1);

    protected abstract void eventsMissed(GENASubscription var1, int var2);

    public static String createDefaultFailureMessage(UpnpResponse responseStatus, Exception exception) {
        String message = "Subscription failed: ";
        message = responseStatus != null ? String.valueOf(message) + " HTTP response was: " + responseStatus.getResponseDetails() : (exception != null ? String.valueOf(message) + " Exception occured: " + exception : String.valueOf(message) + " No response received.");
        return message;
    }

    protected void invalidMessage(RemoteGENASubscription remoteGENASubscription, UnsupportedDataException ex) {
        this.log.info("Invalid event message received, causing: " + ex);
        if (this.log.isTraceEnabled()) {
            this.log.trace("------------------------------------------------------------------------------");
            this.log.trace(ex.getData() != null ? ex.getData().toString() : "null");
            this.log.trace("------------------------------------------------------------------------------");
        }
    }

    public String toString() {
        return "(SubscriptionCallback) " + this.getService();
    }
}

