/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.gena;

import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jupnp.internal.compat.java.beans.PropertyChangeEvent;
import org.jupnp.internal.compat.java.beans.PropertyChangeListener;
import org.jupnp.model.gena.CancelReason;
import org.jupnp.model.gena.GENASubscription;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.meta.StateVariable;
import org.jupnp.model.state.StateVariableValue;
import org.jupnp.model.types.UnsignedIntegerFourBytes;
import org.jupnp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LocalGENASubscription
extends GENASubscription<LocalService>
implements PropertyChangeListener {
    private Logger log = LoggerFactory.getLogger(LocalGENASubscription.class);
    final List<URL> callbackURLs;
    final Map<String, Long> lastSentTimestamp = new HashMap<String, Long>();
    final Map<String, Long> lastSentNumericValue = new HashMap<String, Long>();

    protected LocalGENASubscription(LocalService service, List<URL> callbackURLs) throws Exception {
        super(service);
        this.callbackURLs = callbackURLs;
    }

    public LocalGENASubscription(LocalService service, Integer requestedDurationSeconds, List<URL> callbackURLs) throws Exception {
        super(service);
        this.setSubscriptionDuration(requestedDurationSeconds);
        this.log.trace("Reading initial state of local service at subscription time");
        long currentTime = new Date().getTime();
        this.currentValues.clear();
        Collection<StateVariableValue> values = ((LocalService)this.getService()).getManager().getCurrentState();
        this.log.trace("Got evented state variable values: " + values.size());
        for (StateVariableValue value : values) {
            this.currentValues.put(value.getStateVariable().getName(), value);
            this.log.trace("Read state variable value '" + value.getStateVariable().getName() + "': " + value.toString());
            this.lastSentTimestamp.put(value.getStateVariable().getName(), currentTime);
            if (!value.getStateVariable().isModeratedNumericType()) continue;
            this.lastSentNumericValue.put(value.getStateVariable().getName(), Long.valueOf(value.toString()));
        }
        this.subscriptionId = "uuid:" + UUID.randomUUID();
        this.currentSequence = new UnsignedIntegerFourBytes(0L);
        this.callbackURLs = callbackURLs;
    }

    public synchronized List<URL> getCallbackURLs() {
        return this.callbackURLs;
    }

    public synchronized void registerOnService() {
        ((LocalService)this.getService()).getManager().getPropertyChangeSupport().addPropertyChangeListener(this);
    }

    public synchronized void establish() {
        this.established();
    }

    public synchronized void end(CancelReason reason) {
        try {
            ((LocalService)this.getService()).getManager().getPropertyChangeSupport().removePropertyChangeListener(this);
        }
        catch (Exception ex) {
            this.log.warn("Removal of local service property change listener failed: " + Exceptions.unwrap(ex));
        }
        this.ended(reason);
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent e) {
        if (!e.getPropertyName().equals("_EventedStateVariables")) {
            return;
        }
        this.log.trace("Eventing triggered, getting state for subscription: " + this.getSubscriptionId());
        long currentTime = new Date().getTime();
        Collection newValues = (Collection)e.getNewValue();
        Set<String> excludedVariables = this.moderateStateVariables(currentTime, newValues);
        this.currentValues.clear();
        for (StateVariableValue newValue : newValues) {
            String name = newValue.getStateVariable().getName();
            if (excludedVariables.contains(name)) continue;
            this.log.trace("Adding state variable value to current values of event: " + newValue.getStateVariable() + " = " + newValue);
            this.currentValues.put(newValue.getStateVariable().getName(), newValue);
            this.lastSentTimestamp.put(name, currentTime);
            if (!newValue.getStateVariable().isModeratedNumericType()) continue;
            this.lastSentNumericValue.put(name, Long.valueOf(newValue.toString()));
        }
        if (this.currentValues.size() > 0) {
            this.log.trace("Propagating new state variable values to subscription: " + this);
            this.eventReceived();
        } else {
            this.log.trace("No state variable values for event (all moderated out?), not triggering event");
        }
    }

    protected synchronized Set<String> moderateStateVariables(long currentTime, Collection<StateVariableValue> values) {
        HashSet<String> excludedVariables = new HashSet<String>();
        for (StateVariableValue stateVariableValue : values) {
            long timestampLastSent;
            long timestampNextSend;
            StateVariable stateVariable = stateVariableValue.getStateVariable();
            String stateVariableName = stateVariableValue.getStateVariable().getName();
            if (stateVariable.getEventDetails().getEventMaximumRateMilliseconds() == 0 && stateVariable.getEventDetails().getEventMinimumDelta() == 0) {
                this.log.trace("Variable is not moderated: " + stateVariable);
                continue;
            }
            if (!this.lastSentTimestamp.containsKey(stateVariableName)) {
                this.log.trace("Variable is moderated but was never sent before: " + stateVariable);
                continue;
            }
            if (stateVariable.getEventDetails().getEventMaximumRateMilliseconds() > 0 && currentTime <= (timestampNextSend = (timestampLastSent = this.lastSentTimestamp.get(stateVariableName).longValue()) + (long)stateVariable.getEventDetails().getEventMaximumRateMilliseconds())) {
                this.log.trace("Excluding state variable with maximum rate: " + stateVariable);
                excludedVariables.add(stateVariableName);
                continue;
            }
            if (!stateVariable.isModeratedNumericType() || this.lastSentNumericValue.get(stateVariableName) == null) continue;
            long oldValue = this.lastSentNumericValue.get(stateVariableName);
            long newValue = Long.valueOf(stateVariableValue.toString());
            long minDelta = stateVariable.getEventDetails().getEventMinimumDelta();
            if (newValue > oldValue && newValue - oldValue < minDelta) {
                this.log.trace("Excluding state variable with minimum delta: " + stateVariable);
                excludedVariables.add(stateVariableName);
                continue;
            }
            if (newValue >= oldValue || oldValue - newValue >= minDelta) continue;
            this.log.trace("Excluding state variable with minimum delta: " + stateVariable);
            excludedVariables.add(stateVariableName);
        }
        return excludedVariables;
    }

    public synchronized void incrementSequence() {
        this.currentSequence.increment(true);
    }

    public synchronized void setSubscriptionDuration(Integer requestedDurationSeconds) {
        this.requestedDurationSeconds = requestedDurationSeconds == null ? 1800 : requestedDurationSeconds;
        this.setActualSubscriptionDurationSeconds(this.requestedDurationSeconds);
    }

    public abstract void ended(CancelReason var1);
}

