/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.meta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jupnp.model.ServiceReference;
import org.jupnp.model.Validatable;
import org.jupnp.model.ValidationError;
import org.jupnp.model.ValidationException;
import org.jupnp.model.meta.Action;
import org.jupnp.model.meta.ActionArgument;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.StateVariable;
import org.jupnp.model.meta.StateVariableTypeDetails;
import org.jupnp.model.types.Datatype;
import org.jupnp.model.types.ServiceId;
import org.jupnp.model.types.ServiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Service<D extends Device, S extends Service> {
    private final Logger log = LoggerFactory.getLogger(Service.class);
    private final ServiceType serviceType;
    private final ServiceId serviceId;
    private final Map<String, Action> actions = new HashMap<String, Action>();
    private final Map<String, StateVariable> stateVariables = new HashMap<String, StateVariable>();
    private D device;

    public Service(ServiceType serviceType, ServiceId serviceId) throws ValidationException {
        this(serviceType, serviceId, null, null);
    }

    public Service(ServiceType serviceType, ServiceId serviceId, Action<S>[] actions, StateVariable<S>[] stateVariables) throws ValidationException {
        int n;
        int n2;
        Validatable[] validatableArray;
        this.serviceType = serviceType;
        this.serviceId = serviceId;
        if (actions != null) {
            validatableArray = actions;
            n2 = actions.length;
            n = 0;
            while (n < n2) {
                Validatable action = validatableArray[n];
                this.actions.put(((Action)action).getName(), (Action)action);
                ((Action)action).setService(this);
                ++n;
            }
        }
        if (stateVariables != null) {
            validatableArray = stateVariables;
            n2 = stateVariables.length;
            n = 0;
            while (n < n2) {
                Validatable stateVariable = validatableArray[n];
                this.stateVariables.put(((StateVariable)stateVariable).getName(), (StateVariable)stateVariable);
                ((StateVariable)stateVariable).setService(this);
                ++n;
            }
        }
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public ServiceId getServiceId() {
        return this.serviceId;
    }

    public boolean hasActions() {
        return this.getActions() != null && this.getActions().length > 0;
    }

    public Action<S>[] getActions() {
        return this.actions == null ? null : this.actions.values().toArray(new Action[this.actions.values().size()]);
    }

    public boolean hasStateVariables() {
        return this.getStateVariables() != null && this.getStateVariables().length > 0;
    }

    public StateVariable<S>[] getStateVariables() {
        return this.stateVariables == null ? null : this.stateVariables.values().toArray(new StateVariable[this.stateVariables.values().size()]);
    }

    public D getDevice() {
        return this.device;
    }

    void setDevice(D device) {
        if (this.device != null) {
            throw new IllegalStateException("Final value has been set already, model is immutable");
        }
        this.device = device;
    }

    public Action<S> getAction(String name) {
        return this.actions == null ? null : this.actions.get(name);
    }

    public StateVariable<S> getStateVariable(String name) {
        if ("VirtualQueryActionInput".equals(name)) {
            return new StateVariable("VirtualQueryActionInput", new StateVariableTypeDetails(Datatype.Builtin.STRING.getDatatype()));
        }
        if ("VirtualQueryActionOutput".equals(name)) {
            return new StateVariable("VirtualQueryActionOutput", new StateVariableTypeDetails(Datatype.Builtin.STRING.getDatatype()));
        }
        return this.stateVariables == null ? null : this.stateVariables.get(name);
    }

    public StateVariable<S> getRelatedStateVariable(ActionArgument argument) {
        return this.getStateVariable(argument.getRelatedStateVariableName());
    }

    public Datatype<S> getDatatype(ActionArgument argument) {
        return this.getRelatedStateVariable(argument).getTypeDetails().getDatatype();
    }

    public ServiceReference getReference() {
        return new ServiceReference(((DeviceIdentity)((Device)this.getDevice()).getIdentity()).getUdn(), this.getServiceId());
    }

    public List<ValidationError> validate() {
        int n;
        int n2;
        Validatable[] validatableArray;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getServiceType() == null) {
            errors.add(new ValidationError(this.getClass(), "serviceType", "Service type/info is required"));
        }
        if (this.getServiceId() == null) {
            errors.add(new ValidationError(this.getClass(), "serviceId", "Service ID is required"));
        }
        if (this.hasStateVariables()) {
            validatableArray = this.getStateVariables();
            n2 = validatableArray.length;
            n = 0;
            while (n < n2) {
                Validatable stateVariable = validatableArray[n];
                errors.addAll(((StateVariable)stateVariable).validate());
                ++n;
            }
        }
        if (this.hasActions()) {
            validatableArray = this.getActions();
            n2 = validatableArray.length;
            n = 0;
            while (n < n2) {
                Validatable action = validatableArray[n];
                List<ValidationError> actionErrors = ((Action)action).validate();
                if (actionErrors.size() > 0) {
                    this.actions.remove(((Action)action).getName());
                    this.log.warn("Discarding invalid action of service '" + this.getServiceId() + "': " + ((Action)action).getName());
                    if (this.log.isDebugEnabled()) {
                        for (ValidationError actionError : actionErrors) {
                            this.log.debug("Invalid action '" + ((Action)action).getName() + "': " + actionError);
                        }
                    }
                }
                ++n;
            }
        }
        return errors;
    }

    public abstract Action getQueryStateVariableAction();

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") ServiceId: " + this.getServiceId();
    }
}

