/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jupnp.model.message.Connection;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.message.UpnpMessage;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.transport.spi.UpnpStream;
import org.jupnp.util.Exceptions;
import org.jupnp.util.io.IO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServletUpnpStream
extends UpnpStream {
    protected StreamResponseMessage responseMessage;
    protected final Logger log = LoggerFactory.getLogger(ServletUpnpStream.class);

    public ServletUpnpStream(ProtocolFactory protocolFactory) {
        super(protocolFactory);
    }

    @Override
    public void run() {
        block8: {
            try {
                try {
                    StreamRequestMessage requestMessage = this.readRequestMessage();
                    this.log.trace("Processing new request message: " + requestMessage);
                    this.responseMessage = this.process(requestMessage);
                    if (this.responseMessage != null) {
                        this.log.trace("Preparing HTTP response message: " + this.responseMessage);
                        this.writeResponseMessage(this.responseMessage);
                        break block8;
                    }
                    this.log.trace("Sending HTTP response status: 404");
                    this.getResponse().setStatus(404);
                }
                catch (Throwable t) {
                    this.log.info("Exception occurred during UPnP stream processing: " + t);
                    t.printStackTrace();
                    this.log.trace("Cause: " + Exceptions.unwrap(t), Exceptions.unwrap(t));
                    if (!this.getResponse().isCommitted()) {
                        this.log.trace("Response hasn't been committed, returning INTERNAL SERVER ERROR to client");
                        this.getResponse().setStatus(500);
                    } else {
                        this.log.info("Could not return INTERNAL SERVER ERROR to client, response was already committed");
                    }
                    this.responseException(t);
                    this.complete();
                }
            }
            finally {
                this.complete();
            }
        }
    }

    protected StreamRequestMessage readRequestMessage() throws IOException {
        byte[] bodyBytes;
        StreamRequestMessage requestMessage;
        String requestMethod = this.getRequest().getMethod();
        String requestURI = this.getRequest().getRequestURI();
        this.log.trace("Processing HTTP request: " + requestMethod + " " + requestURI);
        try {
            requestMessage = new StreamRequestMessage(UpnpRequest.Method.getByHttpName(requestMethod), URI.create(requestURI));
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Invalid request URI: " + requestURI, ex);
        }
        if (((UpnpRequest)requestMessage.getOperation()).getMethod().equals((Object)UpnpRequest.Method.UNKNOWN)) {
            throw new RuntimeException("Method not supported: " + requestMethod);
        }
        requestMessage.setConnection(this.createConnection());
        UpnpHeaders headers = new UpnpHeaders();
        Enumeration headerNames = this.getRequest().getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headerValues = this.getRequest().getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                headers.add(headerName, headerValue);
            }
        }
        requestMessage.setHeaders(headers);
        try (ServletInputStream is = null;){
            is = this.getRequest().getInputStream();
            bodyBytes = UpnpRequest.Method.GET.getHttpName().equals(requestMethod) ? new byte[]{} : IO.readBytes((InputStream)is);
        }
        this.log.trace("Reading request body bytes: " + bodyBytes.length);
        if (bodyBytes.length > 0 && requestMessage.isContentTypeMissingOrText()) {
            this.log.trace("Request contains textual entity body, converting then setting string on message");
            requestMessage.setBodyCharacters(bodyBytes);
        } else if (bodyBytes.length > 0) {
            this.log.trace("Request contains binary entity body, setting bytes on message");
            requestMessage.setBody(UpnpMessage.BodyType.BYTES, bodyBytes);
        } else {
            this.log.trace("Request did not contain entity body");
        }
        return requestMessage;
    }

    protected void writeResponseMessage(StreamResponseMessage responseMessage) throws IOException {
        int contentLength;
        this.log.trace("Sending HTTP response status: " + ((UpnpResponse)responseMessage.getOperation()).getStatusCode());
        this.getResponse().setStatus(((UpnpResponse)responseMessage.getOperation()).getStatusCode());
        for (Map.Entry<String, List<String>> entry : responseMessage.getHeaders().entrySet()) {
            for (String value : entry.getValue()) {
                this.getResponse().addHeader(entry.getKey(), value);
            }
        }
        this.getResponse().setDateHeader("Date", System.currentTimeMillis());
        byte[] responseBodyBytes = responseMessage.hasBody() ? responseMessage.getBodyBytes() : null;
        int n = contentLength = responseBodyBytes != null ? responseBodyBytes.length : -1;
        if (contentLength > 0) {
            this.getResponse().setContentLength(contentLength);
            this.log.trace("Response message has body, writing bytes to stream...");
            IO.writeBytes((OutputStream)this.getResponse().getOutputStream(), responseBodyBytes);
        }
    }

    protected abstract Connection createConnection();

    protected abstract HttpServletRequest getRequest();

    protected abstract HttpServletResponse getResponse();

    protected abstract void complete();
}

