/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.mock;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jupnp.UpnpServiceConfiguration;
import org.jupnp.model.NetworkAddress;
import org.jupnp.model.message.IncomingDatagramMessage;
import org.jupnp.model.message.OutgoingDatagramMessage;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.transport.Router;
import org.jupnp.transport.RouterException;
import org.jupnp.transport.spi.InitializationException;
import org.jupnp.transport.spi.UpnpStream;

public class MockRouter
implements Router {
    public int counter = -1;
    public List<IncomingDatagramMessage> incomingDatagramMessages = new ArrayList<IncomingDatagramMessage>();
    public List<OutgoingDatagramMessage> outgoingDatagramMessages = new ArrayList<OutgoingDatagramMessage>();
    public List<UpnpStream> receivedUpnpStreams = new ArrayList<UpnpStream>();
    public List<StreamRequestMessage> sentStreamRequestMessages = new ArrayList<StreamRequestMessage>();
    public List<byte[]> broadcastedBytes = new ArrayList<byte[]>();
    protected UpnpServiceConfiguration configuration;
    protected ProtocolFactory protocolFactory;

    public MockRouter(UpnpServiceConfiguration configuration, ProtocolFactory protocolFactory) {
        this.configuration = configuration;
        this.protocolFactory = protocolFactory;
    }

    @Override
    public UpnpServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    @Override
    public boolean enable() throws RouterException {
        return false;
    }

    @Override
    public boolean disable() throws RouterException {
        return false;
    }

    @Override
    public void shutdown() throws RouterException {
    }

    @Override
    public boolean isEnabled() throws RouterException {
        return false;
    }

    @Override
    public void handleStartFailure(InitializationException ex) throws InitializationException {
    }

    @Override
    public List<NetworkAddress> getActiveStreamServers(InetAddress preferredAddress) throws RouterException {
        try {
            return Arrays.asList(new NetworkAddress(InetAddress.getByName("127.0.0.1"), 0));
        }
        catch (UnknownHostException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void received(IncomingDatagramMessage msg) {
        this.incomingDatagramMessages.add(msg);
    }

    @Override
    public void received(UpnpStream stream) {
        this.receivedUpnpStreams.add(stream);
    }

    @Override
    public void send(OutgoingDatagramMessage msg) throws RouterException {
        this.outgoingDatagramMessages.add(msg);
    }

    @Override
    public StreamResponseMessage send(StreamRequestMessage msg) throws RouterException {
        this.sentStreamRequestMessages.add(msg);
        ++this.counter;
        return this.getStreamResponseMessages() != null ? this.getStreamResponseMessages()[this.counter] : this.getStreamResponseMessage(msg);
    }

    @Override
    public void broadcast(byte[] bytes) {
        this.broadcastedBytes.add(bytes);
    }

    public void resetStreamRequestMessageCounter() {
        this.counter = -1;
    }

    public List<IncomingDatagramMessage> getIncomingDatagramMessages() {
        return this.incomingDatagramMessages;
    }

    public List<OutgoingDatagramMessage> getOutgoingDatagramMessages() {
        return this.outgoingDatagramMessages;
    }

    public List<UpnpStream> getReceivedUpnpStreams() {
        return this.receivedUpnpStreams;
    }

    public List<StreamRequestMessage> getSentStreamRequestMessages() {
        return this.sentStreamRequestMessages;
    }

    public List<byte[]> getBroadcastedBytes() {
        return this.broadcastedBytes;
    }

    public StreamResponseMessage[] getStreamResponseMessages() {
        return null;
    }

    public StreamResponseMessage getStreamResponseMessage(StreamRequestMessage request) {
        return null;
    }
}

