/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.message;

import org.jupnp.model.message.UpnpOperation;

public class UpnpResponse
extends UpnpOperation {
    private int statusCode;
    private String statusMessage;

    public UpnpResponse(int statusCode, String statusMessage) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
    }

    public UpnpResponse(Status status) {
        this.statusCode = status.getStatusCode();
        this.statusMessage = status.getStatusMsg();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public boolean isFailed() {
        return this.statusCode >= 300;
    }

    public String getResponseDetails() {
        return String.valueOf(this.getStatusCode()) + " " + this.getStatusMessage();
    }

    public String toString() {
        return this.getResponseDetails();
    }

    public static enum Status {
        OK(200, "OK"),
        BAD_REQUEST(400, "Bad Request"),
        NOT_FOUND(404, "Not Found"),
        METHOD_NOT_SUPPORTED(405, "Method Not Supported"),
        PRECONDITION_FAILED(412, "Precondition Failed"),
        UNSUPPORTED_MEDIA_TYPE(415, "Unsupported Media Type"),
        INTERNAL_SERVER_ERROR(500, "Internal Server Error"),
        NOT_IMPLEMENTED(501, "Not Implemented");

        private int statusCode;
        private String statusMsg;

        private Status(int statusCode, String statusMsg) {
            this.statusCode = statusCode;
            this.statusMsg = statusMsg;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getStatusMsg() {
            return this.statusMsg;
        }

        public static Status getByStatusCode(int statusCode) {
            Status[] statusArray = Status.values();
            int n = statusArray.length;
            int n2 = 0;
            while (n2 < n) {
                Status status = statusArray[n2];
                if (status.getStatusCode() == statusCode) {
                    return status;
                }
                ++n2;
            }
            return null;
        }
    }
}

