/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.types;

import org.jupnp.model.types.AbstractDatatype;
import org.jupnp.model.types.InvalidValueException;
import org.jupnp.util.io.Base64Coder;

public class Base64Datatype
extends AbstractDatatype<byte[]> {
    @Override
    public Class<byte[]> getValueType() {
        return byte[].class;
    }

    @Override
    public byte[] valueOf(String s) throws InvalidValueException {
        if (s.equals("")) {
            return null;
        }
        try {
            return Base64Coder.decode(s);
        }
        catch (Exception ex) {
            throw new InvalidValueException(ex.getMessage(), ex);
        }
    }

    @Override
    public String getString(byte[] value) throws InvalidValueException {
        if (value == null) {
            return "";
        }
        try {
            return new String(Base64Coder.encode(value));
        }
        catch (Exception ex) {
            throw new InvalidValueException(ex.getMessage(), ex);
        }
    }
}

