/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.types.csv;

import java.util.ArrayList;
import java.util.List;
import org.jupnp.model.ModelUtil;
import org.jupnp.model.types.Datatype;
import org.jupnp.model.types.InvalidValueException;
import org.jupnp.util.Reflections;

public abstract class CSV<T>
extends ArrayList<T> {
    protected final Datatype.Builtin datatype = this.getBuiltinDatatype();

    public CSV() {
    }

    public CSV(String s) throws InvalidValueException {
        this.addAll(this.parseString(s));
    }

    protected List parseString(String s) throws InvalidValueException {
        String[] strings = ModelUtil.fromCommaSeparatedList(s);
        ArrayList values = new ArrayList();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            values.add(this.datatype.getDatatype().valueOf(string));
            ++n2;
        }
        return values;
    }

    protected Datatype.Builtin getBuiltinDatatype() throws InvalidValueException {
        Class<?> csvType = Reflections.getTypeArguments(ArrayList.class, this.getClass()).get(0);
        Datatype.Default defaultType = Datatype.Default.getByJavaType(csvType);
        if (defaultType == null) {
            throw new InvalidValueException("No built-in UPnP datatype for Java type of CSV: " + csvType);
        }
        return defaultType.getBuiltinType();
    }

    @Override
    public String toString() {
        ArrayList<String> stringValues = new ArrayList<String>();
        for (Object t : this) {
            stringValues.add(this.datatype.getDatatype().getString(t));
        }
        return ModelUtil.toCommaSeparatedList(stringValues.toArray(new Object[stringValues.size()]));
    }
}

