/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.spi;

import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.transport.spi.StreamClient;
import org.jupnp.transport.spi.StreamClientConfiguration;
import org.jupnp.util.Exceptions;
import org.jupnp.util.SpecificationViolationReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStreamClient<C extends StreamClientConfiguration, REQUEST>
implements StreamClient<C> {
    private final Logger log = LoggerFactory.getLogger(StreamClient.class);
    private static final int FAILED_REQUESTS_MAX_SIZE = 100;
    private Map<URI, Long> failedRequests = new ConcurrentHashMap<URI, Long>();
    private Map<URI, Long> failedTries = new ConcurrentHashMap<URI, Long>();

    @Override
    public StreamResponseMessage sendRequest(StreamRequestMessage requestMessage) throws InterruptedException {
        REQUEST request;
        this.log.trace("Preparing HTTP request: " + requestMessage);
        String[] split = requestMessage.getUri().toString().split(":");
        String protocol = split[0];
        if (protocol.equals("https")) {
            SpecificationViolationReporter.report("HTTPS invalid.  Ignoring call " + requestMessage.getUri(), new Object[0]);
            return null;
        }
        long start = System.nanoTime();
        this.failedTries.putIfAbsent(requestMessage.getUri(), 0L);
        Long previeousFailureTime = this.failedRequests.get(requestMessage.getUri());
        Long numberOfTries = this.failedTries.get(requestMessage.getUri());
        if (this.getConfiguration().getRetryAfterSeconds() > 0 && previeousFailureTime != null) {
            if (start - previeousFailureTime < TimeUnit.SECONDS.toNanos(this.getConfiguration().getRetryAfterSeconds()) && numberOfTries >= (long)this.getConfiguration().getRetryIterations()) {
                this.log.debug("Will not attempt request because it failed {} times in the last {} seconds: {}", new Object[]{numberOfTries, this.getConfiguration().getRetryAfterSeconds(), requestMessage});
                return null;
            }
            if (start - previeousFailureTime < TimeUnit.SECONDS.toNanos(this.getConfiguration().getRetryAfterSeconds()) && numberOfTries > 0L) {
                this.log.debug("Previous attempt failed {} times.  Will retry {}", (Object)numberOfTries, (Object)requestMessage);
            } else {
                this.log.debug("Clearing failed attempt after {} tries", (Object)numberOfTries);
                this.failedRequests.remove(requestMessage.getUri());
                this.failedTries.put(requestMessage.getUri(), 0L);
            }
        }
        if ((request = this.createRequest(requestMessage)) == null) {
            return null;
        }
        Callable<StreamResponseMessage> callable = this.createCallable(requestMessage, request);
        RequestWrapper requestWrapper = new RequestWrapper(callable);
        Future<StreamResponseMessage> future = this.getConfiguration().getRequestExecutorService().submit(requestWrapper);
        try {
            this.log.trace("Waiting {} seconds for HTTP request to complete: {}", (Object)this.getConfiguration().getTimeoutSeconds(), (Object)requestMessage);
            StreamResponseMessage response = future.get(this.getConfiguration().getTimeoutSeconds(), TimeUnit.SECONDS);
            long elapsed = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            this.log.trace("Got HTTP response in {} ms: {}", (Object)elapsed, (Object)requestMessage);
            if (this.getConfiguration().getLogWarningSeconds() > 0 && elapsed > TimeUnit.SECONDS.toMillis(this.getConfiguration().getLogWarningSeconds())) {
                this.log.warn("HTTP request took a long time ({} ms): {}", (Object)elapsed, (Object)requestMessage);
            }
            StreamResponseMessage streamResponseMessage = response;
            return streamResponseMessage;
        }
        catch (InterruptedException ex) {
            this.log.trace("Interruption, aborting request: " + requestMessage);
            this.abort(request);
            throw new InterruptedException("HTTP request interrupted and aborted");
        }
        catch (TimeoutException ex) {
            this.log.info("Timeout of {} seconds while waiting for HTTP request to complete, aborting: {}", (Object)this.getConfiguration().getTimeoutSeconds(), (Object)requestMessage);
            this.abort(request);
            this.handleRequestTimeout(requestMessage, requestWrapper);
            return null;
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (!this.logExecutionException(cause)) {
                String message = "HTTP request failed: " + requestMessage;
                if (this.log.isDebugEnabled()) {
                    this.log.warn(message, Exceptions.unwrap(cause));
                } else {
                    this.log.warn(String.valueOf(message) + " (" + Exceptions.unwrap(cause).getMessage() + ")");
                }
            }
            this.handleRequestFailure(requestMessage);
            return null;
        }
        finally {
            this.onFinally(request);
        }
    }

    protected abstract REQUEST createRequest(StreamRequestMessage var1);

    protected abstract Callable<StreamResponseMessage> createCallable(StreamRequestMessage var1, REQUEST var2);

    protected abstract void abort(REQUEST var1);

    protected abstract boolean logExecutionException(Throwable var1);

    protected void onFinally(REQUEST request) {
    }

    private void handleRequestFailure(StreamRequestMessage requestMessage) {
        if (this.getConfiguration().getRetryAfterSeconds() <= 0) {
            return;
        }
        long currentTime = System.nanoTime();
        this.failedRequests.put(requestMessage.getUri(), currentTime);
        this.failedTries.put(requestMessage.getUri(), this.failedTries.get(requestMessage.getUri()) + 1L);
        if (this.failedRequests.size() > 100) {
            this.cleanOldFailedRequests(currentTime);
        }
    }

    private void handleRequestTimeout(StreamRequestMessage requestMessage, RequestWrapper requestWrapper) {
        if (this.getConfiguration().getRetryAfterSeconds() <= 0) {
            return;
        }
        long currentTime = System.nanoTime();
        if (requestWrapper.startTime != null && currentTime - requestWrapper.startTime > TimeUnit.SECONDS.toNanos(this.getConfiguration().getTimeoutSeconds())) {
            this.failedRequests.put(requestMessage.getUri(), currentTime);
        }
        this.failedTries.put(requestMessage.getUri(), this.failedTries.get(requestMessage.getUri()) + 1L);
        this.cleanOldFailedRequests(currentTime);
    }

    private void cleanOldFailedRequests(long currentTime) {
        if (this.failedRequests.size() <= 100) {
            return;
        }
        Iterator<Map.Entry<URI, Long>> it = this.failedRequests.entrySet().iterator();
        while (it.hasNext()) {
            Long elapsedTime = currentTime - it.next().getValue();
            if (elapsedTime <= TimeUnit.SECONDS.toNanos(this.getConfiguration().getRetryAfterSeconds())) continue;
            it.remove();
        }
    }

    private static class RequestWrapper
    implements Callable<StreamResponseMessage> {
        Callable<StreamResponseMessage> task;
        Long startTime = null;

        public RequestWrapper(Callable<StreamResponseMessage> task) {
            this.task = task;
        }

        @Override
        public StreamResponseMessage call() throws Exception {
            this.startTime = System.nanoTime();
            return this.task.call();
        }
    }
}

