/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CacheControl {
    private int maxAge = -1;
    private int sharedMaxAge = -1;
    private boolean noCache = false;
    private List<String> noCacheFields = new ArrayList<String>();
    private boolean privateFlag = false;
    private List<String> privateFields = new ArrayList<String>();
    private boolean noStore = false;
    private boolean noTransform = true;
    private boolean mustRevalidate = false;
    private boolean proxyRevalidate = false;
    private Map<String, String> cacheExtensions = new HashMap<String, String>();

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public int getSharedMaxAge() {
        return this.sharedMaxAge;
    }

    public void setSharedMaxAge(int sharedMaxAge) {
        this.sharedMaxAge = sharedMaxAge;
    }

    public boolean isNoCache() {
        return this.noCache;
    }

    public void setNoCache(boolean noCache) {
        this.noCache = noCache;
    }

    public List<String> getNoCacheFields() {
        return this.noCacheFields;
    }

    public void setNoCacheFields(List<String> noCacheFields) {
        this.noCacheFields = noCacheFields;
    }

    public boolean isPrivateFlag() {
        return this.privateFlag;
    }

    public void setPrivateFlag(boolean privateFlag) {
        this.privateFlag = privateFlag;
    }

    public List<String> getPrivateFields() {
        return this.privateFields;
    }

    public void setPrivateFields(List<String> privateFields) {
        this.privateFields = privateFields;
    }

    public boolean isNoStore() {
        return this.noStore;
    }

    public void setNoStore(boolean noStore) {
        this.noStore = noStore;
    }

    public boolean isNoTransform() {
        return this.noTransform;
    }

    public void setNoTransform(boolean noTransform) {
        this.noTransform = noTransform;
    }

    public boolean isMustRevalidate() {
        return this.mustRevalidate;
    }

    public void setMustRevalidate(boolean mustRevalidate) {
        this.mustRevalidate = mustRevalidate;
    }

    public boolean isProxyRevalidate() {
        return this.proxyRevalidate;
    }

    public void setProxyRevalidate(boolean proxyRevalidate) {
        this.proxyRevalidate = proxyRevalidate;
    }

    public Map<String, String> getCacheExtensions() {
        return this.cacheExtensions;
    }

    public void setCacheExtensions(Map<String, String> cacheExtensions) {
        this.cacheExtensions = cacheExtensions;
    }

    public static CacheControl valueOf(String s) throws IllegalArgumentException {
        String[] directives;
        if (s == null) {
            return null;
        }
        CacheControl result = new CacheControl();
        String[] stringArray = directives = s.split(",");
        int n = directives.length;
        int n2 = 0;
        while (n2 < n) {
            String lowercase;
            String directive = stringArray[n2];
            directive = directive.trim();
            String[] nameValue = directive.split("=");
            String name = nameValue[0].trim();
            String value = null;
            if (nameValue.length > 1) {
                value = nameValue[1].trim();
                if (value.startsWith("\"")) {
                    value = value.substring(1);
                }
                if (value.endsWith("\"")) {
                    value = value.substring(0, value.length() - 1);
                }
            }
            if ("no-cache".equals(lowercase = name.toLowerCase())) {
                result.setNoCache(true);
                if (value != null && !"".equals(value)) {
                    result.getNoCacheFields().add(value);
                }
            } else if ("private".equals(lowercase)) {
                result.setPrivateFlag(true);
                if (value != null && !"".equals(value)) {
                    result.getPrivateFields().add(value);
                }
            } else if ("no-store".equals(lowercase)) {
                result.setNoStore(true);
            } else if ("max-age".equals(lowercase)) {
                if (value == null) {
                    throw new IllegalArgumentException("CacheControl max-age header does not have a value: " + value);
                }
                result.setMaxAge(Integer.valueOf(value));
            } else if ("s-maxage".equals(lowercase)) {
                if (value == null) {
                    throw new IllegalArgumentException("CacheControl s-maxage header does not have a value: " + value);
                }
                result.setSharedMaxAge(Integer.valueOf(value));
            } else if ("no-transform".equals(lowercase)) {
                result.setNoTransform(true);
            } else if ("must-revalidate".equals(lowercase)) {
                result.setMustRevalidate(true);
            } else if ("proxy-revalidate".equals(lowercase)) {
                result.setProxyRevalidate(true);
            } else if (!"public".equals(lowercase)) {
                if (value == null) {
                    value = "";
                }
                result.getCacheExtensions().put(name, value);
            }
            ++n2;
        }
        return result;
    }

    public String toString() {
        List<String> fields;
        StringBuilder sb = new StringBuilder();
        if (!this.isPrivateFlag()) {
            sb.append("public");
        }
        if (this.isMustRevalidate()) {
            this.append("must-revalidate", sb);
        }
        if (this.isNoTransform()) {
            this.append("no-transform", sb);
        }
        if (this.isNoStore()) {
            this.append("no-store", sb);
        }
        if (this.isProxyRevalidate()) {
            this.append("proxy-revalidate", sb);
        }
        if (this.getSharedMaxAge() > -1) {
            this.append("s-maxage", sb).append("=").append(this.getSharedMaxAge());
        }
        if (this.getMaxAge() > -1) {
            this.append("max-age", sb).append("=").append(this.getMaxAge());
        }
        if (this.isNoCache()) {
            fields = this.getNoCacheFields();
            if (fields.size() < 1) {
                this.append("no-cache", sb);
            } else {
                for (String field : this.getNoCacheFields()) {
                    this.append("no-cache", sb).append("=\"").append(field).append("\"");
                }
            }
        }
        if (this.isPrivateFlag()) {
            fields = this.getPrivateFields();
            if (fields.size() < 1) {
                this.append("private", sb);
            } else {
                for (String field : this.getPrivateFields()) {
                    this.append("private", sb).append("=\"").append(field).append("\"");
                }
            }
        }
        for (String key : this.getCacheExtensions().keySet()) {
            String val = this.getCacheExtensions().get(key);
            this.append(key, sb);
            if (val == null || "".equals(val)) continue;
            sb.append("=\"").append(val).append("\"");
        }
        return sb.toString();
    }

    private StringBuilder append(String s, StringBuilder sb) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append(s);
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheControl that = (CacheControl)o;
        if (this.maxAge != that.maxAge) {
            return false;
        }
        if (this.mustRevalidate != that.mustRevalidate) {
            return false;
        }
        if (this.noCache != that.noCache) {
            return false;
        }
        if (this.noStore != that.noStore) {
            return false;
        }
        if (this.noTransform != that.noTransform) {
            return false;
        }
        if (this.privateFlag != that.privateFlag) {
            return false;
        }
        if (this.proxyRevalidate != that.proxyRevalidate) {
            return false;
        }
        if (this.sharedMaxAge != that.sharedMaxAge) {
            return false;
        }
        if (!this.cacheExtensions.equals(that.cacheExtensions)) {
            return false;
        }
        if (!this.noCacheFields.equals(that.noCacheFields)) {
            return false;
        }
        return this.privateFields.equals(that.privateFields);
    }

    public int hashCode() {
        int result = this.maxAge;
        result = 31 * result + this.sharedMaxAge;
        result = 31 * result + (this.noCache ? 1 : 0);
        result = 31 * result + this.noCacheFields.hashCode();
        result = 31 * result + (this.privateFlag ? 1 : 0);
        result = 31 * result + this.privateFields.hashCode();
        result = 31 * result + (this.noStore ? 1 : 0);
        result = 31 * result + (this.noTransform ? 1 : 0);
        result = 31 * result + (this.mustRevalidate ? 1 : 0);
        result = 31 * result + (this.proxyRevalidate ? 1 : 0);
        result = 31 * result + this.cacheExtensions.hashCode();
        return result;
    }
}

