/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.gena;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jupnp.internal.compat.java.beans.PropertyChangeSupport;
import org.jupnp.model.Location;
import org.jupnp.model.Namespace;
import org.jupnp.model.NetworkAddress;
import org.jupnp.model.UnsupportedDataException;
import org.jupnp.model.gena.CancelReason;
import org.jupnp.model.gena.GENASubscription;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.model.meta.Service;
import org.jupnp.model.state.StateVariableValue;
import org.jupnp.model.types.UnsignedIntegerFourBytes;

public abstract class RemoteGENASubscription
extends GENASubscription<RemoteService> {
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    protected RemoteGENASubscription(RemoteService service, int requestedDurationSeconds) {
        super(service, requestedDurationSeconds);
    }

    public URL getEventSubscriptionURL() {
        return ((RemoteDevice)((RemoteService)this.getService()).getDevice()).normalizeURI(((RemoteService)this.getService()).getEventSubscriptionURI());
    }

    public List<URL> getEventCallbackURLs(List<NetworkAddress> activeStreamServers, Namespace namespace) {
        ArrayList<URL> callbackURLs = new ArrayList<URL>();
        for (NetworkAddress activeStreamServer : activeStreamServers) {
            callbackURLs.add(new Location(activeStreamServer, namespace.getEventCallbackPathString((Service)this.getService())).getURL());
        }
        return callbackURLs;
    }

    public synchronized void establish() {
        this.established();
    }

    public synchronized void fail(UpnpResponse responseStatus) {
        this.failed(responseStatus);
    }

    public synchronized void end(CancelReason reason, UpnpResponse response) {
        this.ended(reason, response);
    }

    public synchronized void receive(UnsignedIntegerFourBytes sequence, Collection<StateVariableValue> newValues) {
        if (this.currentSequence != null) {
            if (this.currentSequence.getValue().equals(this.currentSequence.getBits().getMaxValue()) && sequence.getValue() == 1L) {
                System.err.println("TODO: HANDLE ROLLOVER");
                return;
            }
            if (this.currentSequence.getValue() >= sequence.getValue()) {
                return;
            }
            long expectedValue = this.currentSequence.getValue() + 1L;
            int difference = (int)(sequence.getValue() - expectedValue);
            if (difference != 0) {
                this.eventsMissed(difference);
            }
        }
        this.currentSequence = sequence;
        for (StateVariableValue newValue : newValues) {
            this.currentValues.put(newValue.getStateVariable().getName(), newValue);
        }
        this.eventReceived();
    }

    public abstract void invalidMessage(UnsupportedDataException var1);

    public abstract void failed(UpnpResponse var1);

    public abstract void ended(CancelReason var1, UpnpResponse var2);

    public abstract void eventsMissed(int var1);

    @Override
    public String toString() {
        return "(SID: " + this.getSubscriptionId() + ") " + this.getService();
    }
}

