/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.message.header;

import org.jupnp.model.message.header.InvalidHeaderException;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.model.types.HostPort;

public class HostHeader
extends UpnpHeader<HostPort> {
    int port = 1900;
    String group = "239.255.255.250";

    public HostHeader() {
        this.setValue(new HostPort(this.group, this.port));
    }

    public HostHeader(int port) {
        this.setValue(new HostPort(this.group, port));
    }

    public HostHeader(String host, int port) {
        this.setValue(new HostPort(host, port));
    }

    @Override
    public void setString(String s) throws InvalidHeaderException {
        if (s.contains(":")) {
            try {
                this.port = Integer.valueOf(s.substring(s.indexOf(":") + 1));
                this.group = s.substring(0, s.indexOf(":"));
                this.setValue(new HostPort(this.group, this.port));
            }
            catch (NumberFormatException ex) {
                throw new InvalidHeaderException("Invalid HOST header value, can't parse port: " + s + " - " + ex.getMessage());
            }
        } else {
            this.group = s;
            this.setValue(new HostPort(this.group, this.port));
        }
    }

    @Override
    public String getString() {
        return ((HostPort)this.getValue()).toString();
    }
}

