/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.types;

import org.jupnp.model.types.DeviceType;
import org.jupnp.model.types.InvalidValueException;
import org.jupnp.model.types.UDN;

public class NamedDeviceType {
    private UDN udn;
    private DeviceType deviceType;

    public NamedDeviceType(UDN udn, DeviceType deviceType) {
        this.udn = udn;
        this.deviceType = deviceType;
    }

    public UDN getUdn() {
        return this.udn;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public static NamedDeviceType valueOf(String s) throws InvalidValueException {
        UDN udn;
        String[] strings = s.split("::");
        if (strings.length != 2) {
            throw new InvalidValueException("Can't parse UDN::DeviceType from: " + s);
        }
        try {
            udn = UDN.valueOf(strings[0]);
        }
        catch (Exception ex) {
            throw new InvalidValueException("Can't parse UDN: " + strings[0]);
        }
        DeviceType deviceType = DeviceType.valueOf(strings[1]);
        return new NamedDeviceType(udn, deviceType);
    }

    public String toString() {
        return String.valueOf(this.getUdn().toString()) + "::" + this.getDeviceType().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof NamedDeviceType)) {
            return false;
        }
        NamedDeviceType that = (NamedDeviceType)o;
        if (!this.deviceType.equals(that.deviceType)) {
            return false;
        }
        return this.udn.equals(that.udn);
    }

    public int hashCode() {
        int result = this.udn.hashCode();
        result = 31 * result + this.deviceType.hashCode();
        return result;
    }
}

