/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.sync;

import org.jupnp.UpnpService;
import org.jupnp.model.UnsupportedDataException;
import org.jupnp.model.action.ActionCancelledException;
import org.jupnp.model.action.ActionException;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.action.RemoteActionInvocation;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.control.IncomingActionRequestMessage;
import org.jupnp.model.message.control.OutgoingActionResponseMessage;
import org.jupnp.model.message.header.ContentTypeHeader;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.resource.ServiceControlResource;
import org.jupnp.model.types.ErrorCode;
import org.jupnp.protocol.ReceivingSync;
import org.jupnp.transport.RouterException;
import org.jupnp.util.Exceptions;
import org.jupnp.util.SpecificationViolationReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivingAction
extends ReceivingSync<StreamRequestMessage, StreamResponseMessage> {
    private final Logger log = LoggerFactory.getLogger(ReceivingAction.class);

    public ReceivingAction(UpnpService upnpService, StreamRequestMessage inputMessage) {
        super(upnpService, inputMessage);
    }

    @Override
    protected StreamResponseMessage executeSync() throws RouterException {
        RemoteActionInvocation invocation;
        OutgoingActionResponseMessage responseMessage;
        block10: {
            block11: {
                ServiceControlResource resource;
                ContentTypeHeader contentTypeHeader = ((StreamRequestMessage)this.getInputMessage()).getHeaders().getFirstHeader(UpnpHeader.Type.CONTENT_TYPE, ContentTypeHeader.class);
                if (contentTypeHeader != null && !contentTypeHeader.isUDACompliantXML()) {
                    SpecificationViolationReporter.report("Received invalid Content-Type '{}': {}", contentTypeHeader, this.getInputMessage());
                    return new StreamResponseMessage(new UpnpResponse(UpnpResponse.Status.UNSUPPORTED_MEDIA_TYPE));
                }
                if (contentTypeHeader == null) {
                    SpecificationViolationReporter.report("Received without Content-Type: {}", this.getInputMessage());
                }
                if ((resource = this.getUpnpService().getRegistry().getResource(ServiceControlResource.class, ((StreamRequestMessage)this.getInputMessage()).getUri())) == null) {
                    this.log.trace("No local resource found: " + this.getInputMessage());
                    return null;
                }
                this.log.trace("Found local action resource matching relative request URI: " + ((StreamRequestMessage)this.getInputMessage()).getUri());
                responseMessage = null;
                IncomingActionRequestMessage requestMessage = new IncomingActionRequestMessage((StreamRequestMessage)this.getInputMessage(), (LocalService)resource.getModel());
                this.log.trace("Created incoming action request message: " + requestMessage);
                invocation = new RemoteActionInvocation(requestMessage.getAction(), this.getRemoteClientInfo());
                this.log.trace("Reading body of request message");
                this.getUpnpService().getConfiguration().getSoapActionProcessor().readBody(requestMessage, (ActionInvocation)invocation);
                this.log.trace("Executing on local service: " + invocation);
                ((LocalService)resource.getModel()).getExecutor(invocation.getAction()).execute(invocation);
                if (invocation.getFailure() == null) {
                    responseMessage = new OutgoingActionResponseMessage(invocation.getAction());
                    break block10;
                }
                if (!(invocation.getFailure() instanceof ActionCancelledException)) break block11;
                this.log.trace("Action execution was cancelled, returning 404 to client");
                return null;
            }
            try {
                responseMessage = new OutgoingActionResponseMessage(UpnpResponse.Status.INTERNAL_SERVER_ERROR, invocation.getAction());
            }
            catch (ActionException ex) {
                this.log.trace("Error executing local action: " + ex);
                invocation = new RemoteActionInvocation(ex, this.getRemoteClientInfo());
                responseMessage = new OutgoingActionResponseMessage(UpnpResponse.Status.INTERNAL_SERVER_ERROR);
            }
            catch (UnsupportedDataException ex) {
                this.log.warn("Error reading action request XML body: " + ex.toString(), Exceptions.unwrap(ex));
                invocation = new RemoteActionInvocation(Exceptions.unwrap(ex) instanceof ActionException ? (ActionException)Exceptions.unwrap(ex) : new ActionException(ErrorCode.ACTION_FAILED, ex.getMessage()), this.getRemoteClientInfo());
                responseMessage = new OutgoingActionResponseMessage(UpnpResponse.Status.INTERNAL_SERVER_ERROR);
            }
        }
        try {
            this.log.trace("Writing body of response message");
            this.getUpnpService().getConfiguration().getSoapActionProcessor().writeBody(responseMessage, (ActionInvocation)invocation);
            this.log.trace("Returning finished response message: " + responseMessage);
            return responseMessage;
        }
        catch (UnsupportedDataException ex) {
            this.log.warn("Failure writing body of response message, sending '500 Internal Server Error' without body");
            this.log.warn("Exception root cause: ", Exceptions.unwrap(ex));
            return new StreamResponseMessage(UpnpResponse.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

