/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.registry;

import org.jupnp.registry.RegistryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryMaintainer
implements Runnable {
    private Logger log = LoggerFactory.getLogger(RegistryMaintainer.class);
    private final RegistryImpl registry;
    private final int sleepIntervalMillis;
    private volatile boolean stopped = false;

    public RegistryMaintainer(RegistryImpl registry, int sleepIntervalMillis) {
        this.registry = registry;
        this.sleepIntervalMillis = sleepIntervalMillis;
    }

    public void stop() {
        this.log.trace("Setting stopped status on thread");
        this.stopped = true;
    }

    @Override
    public void run() {
        this.stopped = false;
        this.log.trace("Running registry maintenance loop every milliseconds: " + this.sleepIntervalMillis);
        while (!this.stopped) {
            try {
                this.registry.maintain();
                Thread.sleep(this.sleepIntervalMillis);
            }
            catch (InterruptedException ex) {
                this.stopped = true;
            }
        }
        this.log.trace("Stopped status on thread received, ending maintenance loop");
    }
}

