/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl.blocking;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jupnp.model.message.Connection;
import org.jupnp.transport.Router;
import org.jupnp.transport.impl.ServletConnection;
import org.jupnp.transport.impl.ServletStreamServerConfigurationImpl;
import org.jupnp.transport.impl.blocking.BlockingServletUpnpStream;
import org.jupnp.transport.impl.blocking.FauxAsyncContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingServlet
extends HttpServlet {
    private static final long serialVersionUID = 3124088565842038644L;
    private final Logger log = LoggerFactory.getLogger(BlockingServlet.class);
    private final Router router;
    private int mCounter = 0;
    private final ServletStreamServerConfigurationImpl configuration;

    public BlockingServlet(Router router, ServletStreamServerConfigurationImpl configuration) {
        this.router = router;
        this.configuration = configuration;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        long startTime = System.currentTimeMillis();
        int counter = this.mCounter++;
        this.log.trace("{}", (Object)String.format("HttpServlet.service(): id: %3d, request URI: %s", counter, req.getRequestURI()));
        this.log.trace("Handling Servlet request synchronously: " + req);
        FauxAsyncContext asyncContext = new FauxAsyncContext(req, resp);
        asyncContext.setTimeout(this.configuration.getAsyncTimeoutSeconds() * 1000);
        BlockingServletUpnpStream stream = new BlockingServletUpnpStream(this.router.getProtocolFactory(), asyncContext){

            @Override
            protected Connection createConnection() {
                return new ServletConnection(this.getRequest());
            }
        };
        this.router.received(stream);
        asyncContext.waitForTimeoutOrCompletion();
        long duration = System.currentTimeMillis() - startTime;
        if (asyncContext.isCompleted()) {
            this.log.trace("{}", (Object)String.format("BlockingServlet completed: id: %3d, duration: %,4d", counter, duration));
        } else {
            resp.setStatus(500);
            this.log.warn("{}", (Object)String.format("BlockingServlet timed out: id: %3d, duration: %,4d, request: %s", counter, duration, req));
        }
    }
}

