/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.spi;

import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.protocol.ProtocolCreationException;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.protocol.ReceivingSync;
import org.jupnp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UpnpStream
implements Runnable {
    private Logger log = LoggerFactory.getLogger(UpnpStream.class);
    protected final ProtocolFactory protocolFactory;
    protected ReceivingSync syncProtocol;

    protected UpnpStream(ProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public StreamResponseMessage process(StreamRequestMessage requestMsg) {
        this.log.trace("Processing stream request message: " + requestMsg);
        try {
            this.syncProtocol = this.getProtocolFactory().createReceivingSync(requestMsg);
        }
        catch (ProtocolCreationException ex) {
            this.log.warn("Processing stream request failed - " + Exceptions.unwrap(ex).toString());
            return new StreamResponseMessage(UpnpResponse.Status.NOT_IMPLEMENTED);
        }
        this.log.trace("Running protocol for synchronous message processing: " + this.syncProtocol);
        this.syncProtocol.run();
        Object responseMsg = this.syncProtocol.getOutputMessage();
        if (responseMsg == null) {
            this.log.trace("Protocol did not return any response message");
            return null;
        }
        this.log.trace("Protocol returned response: " + responseMsg);
        return responseMsg;
    }

    protected void responseSent(StreamResponseMessage responseMessage) {
        if (this.syncProtocol != null) {
            this.syncProtocol.responseSent(responseMessage);
        }
    }

    protected void responseException(Throwable t) {
        if (this.syncProtocol != null) {
            this.syncProtocol.responseException(t);
        }
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ")";
    }
}

