/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.jte.html;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import org.jusecase.jte.TemplateOutput;
import org.jusecase.jte.html.HtmlTemplateOutput;
import org.jusecase.jte.internal.StringUtils;
import org.owasp.encoder.Encode;

public class OwaspHtmlTemplateOutput
implements HtmlTemplateOutput {
    private final TemplateOutput templateOutput;
    private String tagName;
    private String attributeName;

    public OwaspHtmlTemplateOutput(TemplateOutput templateOutput) {
        this.templateOutput = templateOutput;
    }

    @Override
    public void setContext(String tagName, String attributeName) {
        this.tagName = tagName;
        this.attributeName = attributeName;
    }

    @Override
    public void writeUserContent(String value) {
        if (value != null) {
            if (this.tagName != null && this.attributeName != null) {
                this.writeTagAttributeUserContent(value);
            } else if (this.tagName != null) {
                this.writeTagBodyUserContent(value);
            } else {
                this.writeContent(value);
            }
        }
    }

    private void writeTagBodyUserContent(String value) {
        try {
            if ("script".equals(this.tagName)) {
                Encode.forJavaScriptBlock((Writer)this.getWriter(), (String)value);
            } else {
                Encode.forHtml((Writer)this.getWriter(), (String)value);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeTagAttributeUserContent(String value) {
        if ("a".equals(this.tagName) && "href".equals(this.attributeName) && StringUtils.startsWithIgnoringCaseAndWhitespaces(value, "javascript:")) {
            return;
        }
        try {
            if (this.attributeName.startsWith("on")) {
                Encode.forJavaScriptAttribute((Writer)this.getWriter(), (String)value);
            } else {
                Encode.forHtmlAttribute((Writer)this.getWriter(), (String)value);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Writer getWriter() {
        return this.templateOutput.getWriter();
    }

    @Override
    public void writeContent(String value) {
        this.templateOutput.writeContent(value);
    }
}

