/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.jte;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jusecase.jte.CodeResolver;
import org.jusecase.jte.TemplateException;
import org.jusecase.jte.TemplateOutput;
import org.jusecase.jte.internal.DebugInfo;
import org.jusecase.jte.internal.Template;
import org.jusecase.jte.internal.TemplateCompiler;
import org.jusecase.jte.internal.TemplateMode;
import org.jusecase.jte.support.HtmlTagSupport;

public final class TemplateEngine {
    private final TemplateCompiler compiler;
    private final TemplateMode templateMode;
    private final ConcurrentMap<String, Template> templateCache;
    private HtmlTagSupport htmlTagSupport;

    public static TemplateEngine create(CodeResolver codeResolver) {
        return TemplateEngine.create(codeResolver, Path.of("jte", new String[0]));
    }

    public static TemplateEngine create(CodeResolver codeResolver, Path classDirectory) {
        return new TemplateEngine(codeResolver, classDirectory, TemplateMode.OnDemand);
    }

    public static TemplateEngine createPrecompiled(Path classDirectory) {
        return new TemplateEngine(null, classDirectory, TemplateMode.Precompiled);
    }

    private TemplateEngine(CodeResolver codeResolver, Path classDirectory, TemplateMode templateMode) {
        this.compiler = new TemplateCompiler(codeResolver, classDirectory, templateMode);
        this.templateMode = templateMode;
        this.templateCache = new ConcurrentHashMap<String, Template>();
        if (templateMode == TemplateMode.OnDemand) {
            this.cleanAll();
        }
    }

    public void render(String name, Object param, TemplateOutput output) throws TemplateException {
        Template template = this.resolveTemplate(name);
        try {
            template.render(output, this.htmlTagSupport, param);
        }
        catch (Throwable e) {
            this.handleRenderException(name, template, e);
        }
    }

    public void render(String name, Map<String, Object> params, TemplateOutput output) throws TemplateException {
        Template template = this.resolveTemplate(name);
        try {
            template.renderMap(output, this.htmlTagSupport, params);
        }
        catch (Throwable e) {
            this.handleRenderException(name, template, e);
        }
    }

    public void renderTag(String name, Map<String, Object> params, TemplateOutput output) throws TemplateException {
        Template template = this.resolveTemplate(name);
        try {
            template.renderMap(output, this.htmlTagSupport, params);
        }
        catch (Throwable e) {
            this.handleRenderException(name, template, e);
        }
    }

    public void renderLayout(String name, Map<String, Object> params, Map<String, String> layoutDefinitions, TemplateOutput output) throws TemplateException {
        Template template = this.resolveTemplate(name);
        try {
            params.put("__jteLayoutDefinitions", layoutDefinitions);
            template.renderMap(output, this.htmlTagSupport, params);
        }
        catch (Throwable e) {
            this.handleRenderException(name, template, e);
        }
    }

    private void handleRenderException(String name, Template template, Throwable e) {
        DebugInfo debugInfo = this.compiler.resolveDebugInfo(template.getClassLoader(), e.getStackTrace());
        String message = "Failed to render " + name;
        if (debugInfo != null) {
            message = message + ", error at " + debugInfo.name + ":" + debugInfo.line;
        }
        throw new TemplateException(message, e);
    }

    public List<String> getTemplatesUsing(String name) {
        if (name.startsWith("tag/") || name.startsWith("layout/")) {
            return this.compiler.getTemplatesUsing(name);
        }
        return Collections.singletonList(name);
    }

    public void prepareForRendering(String name) {
        this.resolveTemplate(name);
    }

    public void cleanAll() {
        this.compiler.cleanAll();
    }

    public void precompileAll() {
        this.precompileAll(null);
    }

    public void precompileAll(List<String> compilePath) {
        this.compiler.precompileAll(compilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template resolveTemplate(String name) {
        if (this.templateMode == TemplateMode.OnDemand && this.compiler.hasChanged(name)) {
            ConcurrentMap<String, Template> concurrentMap = this.templateCache;
            synchronized (concurrentMap) {
                if (this.compiler.hasChanged(name)) {
                    Template template = this.compiler.compile(name);
                    this.templateCache.put(name, template);
                    return template;
                }
            }
        }
        return this.templateCache.computeIfAbsent(name, this.compiler::compile);
    }

    public void setNullSafeTemplateCode(boolean value) {
        this.compiler.setNullSafeTemplateCode(value);
    }

    public void setHtmlTags(String ... htmlTags) {
        this.compiler.setHtmlTags(htmlTags);
    }

    public void setHtmlAttributes(String ... htmlAttributes) {
        this.compiler.setHtmlAttributes(htmlAttributes);
    }

    public void setHtmlTagSupport(HtmlTagSupport htmlTagSupport) {
        this.htmlTagSupport = htmlTagSupport;
    }
}

