/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.jte.internal;

import java.util.Arrays;

final class CodeBuilder {
    private static final int INITIAL_CAPACITY = 10;
    private static final int LOAD_FACTOR = 2;
    private final StringBuilder javaCode = new StringBuilder(1024);
    private int currentJavaLine;
    private int currentTemplateLine;
    private int fieldsIndex;
    private int fieldsJavaLine;
    private int fieldsTemplateLine;
    private int[] lineInfo = new int[10];

    CodeBuilder() {
    }

    public CodeBuilder append(String code) {
        this.javaCode.append(code);
        if (code.endsWith("\n")) {
            this.addLine(this.currentTemplateLine);
        }
        return this;
    }

    public CodeBuilder append(String code, int start, int end) {
        this.javaCode.append(code, start, end);
        return this;
    }

    public CodeBuilder append(char code) {
        this.javaCode.append(code);
        return this;
    }

    public CodeBuilder finishTemplateLine() {
        ++this.currentTemplateLine;
        return this;
    }

    public CodeBuilder insertFieldLines(int count) {
        this.fillLines(this.fieldsJavaLine, this.fieldsTemplateLine, count);
        return this;
    }

    public int getCurrentTemplateLine() {
        return this.currentTemplateLine;
    }

    public String getCode() {
        return this.javaCode.toString();
    }

    public void addLineInfoField(StringBuilder fields) {
        fields.append("\tpublic static final int[] ").append("LINE_INFO").append(" = {");
        for (int i = 0; i < this.currentJavaLine; ++i) {
            if (i > 0) {
                fields.append(',');
            }
            fields.append(this.lineInfo[i]);
        }
        fields.append("};\n");
    }

    public void markFieldsIndex() {
        this.fieldsIndex = this.javaCode.length();
        this.fieldsJavaLine = this.currentJavaLine;
        this.fieldsTemplateLine = this.currentTemplateLine;
    }

    public void insertFields(StringBuilder fields) {
        this.javaCode.insert(this.fieldsIndex, fields);
    }

    private void addLine(int templateLine) {
        if (this.currentJavaLine + 1 > this.lineInfo.length) {
            this.lineInfo = Arrays.copyOf(this.lineInfo, this.lineInfo.length * 2);
        }
        this.lineInfo[this.currentJavaLine] = templateLine;
        ++this.currentJavaLine;
    }

    private void fillLines(int fromJavaLine, int templateLine, int count) {
        if (this.currentJavaLine + count > this.lineInfo.length) {
            this.lineInfo = Arrays.copyOf(this.lineInfo, this.currentJavaLine + count);
        }
        System.arraycopy(this.lineInfo, fromJavaLine, this.lineInfo, fromJavaLine + count, this.currentJavaLine - fromJavaLine);
        Arrays.fill(this.lineInfo, fromJavaLine, fromJavaLine + count, templateLine);
        this.currentJavaLine += count;
    }

    public int[] getLineInfo() {
        return Arrays.copyOf(this.lineInfo, this.currentJavaLine);
    }

    public StringBuilder getStringBuilder() {
        return this.javaCode;
    }
}

