/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.jte.internal;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jusecase.jte.CodeResolver;
import org.jusecase.jte.TemplateException;
import org.jusecase.jte.internal.ClassDefinition;
import org.jusecase.jte.internal.ClassFilesCompiler;
import org.jusecase.jte.internal.ClassInfo;
import org.jusecase.jte.internal.CodeBuilder;
import org.jusecase.jte.internal.DebugInfo;
import org.jusecase.jte.internal.IoUtils;
import org.jusecase.jte.internal.ParamInfo;
import org.jusecase.jte.internal.Template;
import org.jusecase.jte.internal.TemplateMode;
import org.jusecase.jte.internal.TemplateParser;
import org.jusecase.jte.internal.TemplateParserVisitor;
import org.jusecase.jte.internal.TemplateType;
import org.jusecase.jte.output.FileOutput;

public class TemplateCompiler {
    public static final String TAG_EXTENSION = ".jte";
    public static final String LAYOUT_EXTENSION = ".jte";
    public static final String TAG_DIRECTORY = "tag/";
    public static final String LAYOUT_DIRECTORY = "layout/";
    public static final String CLASS_PREFIX = "Jte";
    public static final String CLASS_SUFFIX = "Generated";
    public static final String PACKAGE_NAME = "org.jusecase.jte.generated";
    public static final String LAYOUT_DEFINITIONS_PARAM = "__jteLayoutDefinitions";
    public static final String LINE_INFO_FIELD = "LINE_INFO";
    public static final boolean DEBUG = false;
    private final CodeResolver codeResolver;
    private final Path classDirectory;
    private final TemplateMode templateMode;
    private final ClassLoader singleClassLoader;
    private final ConcurrentHashMap<String, LinkedHashSet<String>> templateDependencies = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, List<ParamInfo>> paramOrder = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ClassInfo> templateByClassName = new ConcurrentHashMap();
    private boolean nullSafeTemplateCode;
    private String[] htmlTags;
    private String[] htmlAttributes;

    public TemplateCompiler(CodeResolver codeResolver, Path classDirectory, TemplateMode templateMode) {
        this.codeResolver = codeResolver;
        this.classDirectory = classDirectory;
        this.templateMode = templateMode;
        this.singleClassLoader = templateMode == TemplateMode.Precompiled ? this.createClassLoader() : null;
    }

    public Template compile(String name) {
        if (this.templateMode == TemplateMode.OnDemand) {
            this.precompile(List.of(name), null);
        }
        ClassInfo templateInfo = new ClassInfo(name, PACKAGE_NAME);
        TemplateType templateType = this.getTemplateType(name);
        try {
            Class<?> clazz = this.getClassLoader().loadClass(templateInfo.fullName);
            return new Template(name, templateType, clazz);
        }
        catch (Exception e) {
            throw new TemplateException("Failed to load " + name, e);
        }
    }

    private ClassLoader getClassLoader() {
        if (this.singleClassLoader == null) {
            return this.createClassLoader();
        }
        return this.singleClassLoader;
    }

    private ClassLoader createClassLoader() {
        try {
            return new URLClassLoader(new URL[]{this.classDirectory.toUri().toURL()});
        }
        catch (MalformedURLException e) {
            throw new TemplateException("Failed to create class loader for " + this.classDirectory, e);
        }
    }

    public void cleanAll() {
        IoUtils.deleteDirectoryContent(this.classDirectory);
    }

    public void precompileAll(List<String> compilePath) {
        this.precompile(this.codeResolver.resolveAllTemplateNames(), compilePath);
    }

    public void precompile(List<String> names, List<String> compilePath) {
        LinkedHashSet<ClassDefinition> classDefinitions = new LinkedHashSet<ClassDefinition>();
        for (String name : names) {
            switch (this.getTemplateType(name)) {
                case Template: {
                    this.generateTemplate(name, classDefinitions);
                    break;
                }
                case Tag: {
                    this.generateTemplateFromTag(name, classDefinitions);
                    break;
                }
                case Layout: {
                    this.generateTemplateFromLayout(name, classDefinitions);
                }
            }
        }
        for (ClassDefinition classDefinition : classDefinitions) {
            try (FileOutput fileOutput = new FileOutput(this.classDirectory.resolve(classDefinition.getJavaFileName()));){
                fileOutput.writeContent(classDefinition.getCode());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        String[] files = new String[classDefinitions.size()];
        int i = 0;
        for (ClassDefinition classDefinition : classDefinitions) {
            files[i++] = this.classDirectory.resolve(classDefinition.getJavaFileName()).toFile().getAbsolutePath();
        }
        ClassFilesCompiler.compile(files, compilePath, this.classDirectory, this.templateByClassName);
    }

    private TemplateType getTemplateType(String name) {
        if (name.startsWith(TAG_DIRECTORY)) {
            return TemplateType.Tag;
        }
        if (name.startsWith(LAYOUT_DIRECTORY)) {
            return TemplateType.Layout;
        }
        return TemplateType.Template;
    }

    private void generateTemplate(String name, LinkedHashSet<ClassDefinition> classDefinitions) {
        String templateCode = this.resolveCode(TemplateType.Template, name, null);
        LinkedHashSet<String> templateDependencies = new LinkedHashSet<String>();
        ClassInfo templateInfo = new ClassInfo(name, PACKAGE_NAME);
        CodeGenerator codeGenerator = new CodeGenerator(templateInfo, TemplateType.Template, classDefinitions, templateDependencies);
        new TemplateParser(TemplateType.Template, codeGenerator, this.htmlTags, this.htmlAttributes).parse(templateCode);
        this.templateDependencies.put(name, templateDependencies);
        ClassDefinition templateDefinition = new ClassDefinition(templateInfo.fullName);
        templateDefinition.setCode(codeGenerator.getCode());
        classDefinitions.add(templateDefinition);
        this.templateByClassName.put(templateDefinition.getName(), templateInfo);
    }

    private void generateTemplateFromTag(String name, LinkedHashSet<ClassDefinition> classDefinitions) {
        LinkedHashSet<String> templateDependencies = new LinkedHashSet<String>();
        ClassInfo templateInfo = this.generateTag(name, classDefinitions, templateDependencies, null);
        this.templateDependencies.put(name, templateDependencies);
        this.templateByClassName.put(templateInfo.name, templateInfo);
    }

    private void generateTemplateFromLayout(String name, LinkedHashSet<ClassDefinition> classDefinitions) {
        LinkedHashSet<String> templateDependencies = new LinkedHashSet<String>();
        ClassInfo templateInfo = this.generateLayout(name, classDefinitions, templateDependencies, null);
        this.templateDependencies.put(name, templateDependencies);
        this.templateByClassName.put(templateInfo.name, templateInfo);
    }

    private ClassInfo generateTag(String name, LinkedHashSet<ClassDefinition> classDefinitions, LinkedHashSet<String> templateDependencies, DebugInfo debugInfo) {
        return this.generateTagOrLayout(TemplateType.Tag, name, classDefinitions, templateDependencies, debugInfo);
    }

    private ClassInfo generateLayout(String name, LinkedHashSet<ClassDefinition> classDefinitions, LinkedHashSet<String> templateDependencies, DebugInfo debugInfo) {
        return this.generateTagOrLayout(TemplateType.Layout, name, classDefinitions, templateDependencies, debugInfo);
    }

    private ClassInfo generateTagOrLayout(TemplateType type, String name, LinkedHashSet<ClassDefinition> classDefinitions, LinkedHashSet<String> templateDependencies, DebugInfo debugInfo) {
        templateDependencies.add(name);
        ClassInfo classInfo = new ClassInfo(name, PACKAGE_NAME);
        ClassDefinition classDefinition = new ClassDefinition(classInfo.fullName);
        if (classDefinitions.contains(classDefinition)) {
            return classInfo;
        }
        String code = this.resolveCode(type, name, debugInfo);
        classDefinitions.add(classDefinition);
        CodeGenerator codeGenerator = new CodeGenerator(classInfo, type, classDefinitions, templateDependencies);
        new TemplateParser(type, codeGenerator, this.htmlTags, this.htmlAttributes).parse(code);
        classDefinition.setCode(codeGenerator.getCode());
        this.templateByClassName.put(classDefinition.getName(), classInfo);
        return classInfo;
    }

    private String resolveCode(TemplateType type, String name, DebugInfo debugInfo) {
        String code = this.codeResolver.resolve(name);
        if (code == null) {
            String message = type + " not found: " + name;
            if (debugInfo != null) {
                message = message + ", referenced at " + debugInfo.name + ":" + debugInfo.line;
            }
            throw new TemplateException(message);
        }
        return code;
    }

    public boolean hasChanged(String name) {
        if (this.codeResolver.hasChanged(name)) {
            return true;
        }
        LinkedHashSet<String> dependencies = this.templateDependencies.get(name);
        if (dependencies == null) {
            return false;
        }
        for (String dependency : dependencies) {
            if (!this.codeResolver.hasChanged(dependency)) continue;
            return true;
        }
        return false;
    }

    public List<String> getTemplatesUsing(String name) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, LinkedHashSet<String>> dependencies : this.templateDependencies.entrySet()) {
            if (!dependencies.getValue().contains(name)) continue;
            result.add(dependencies.getKey());
        }
        return result;
    }

    public void setNullSafeTemplateCode(boolean nullSafeTemplateCode) {
        this.nullSafeTemplateCode = nullSafeTemplateCode;
    }

    public void setHtmlTags(String[] htmlTags) {
        this.htmlTags = htmlTags;
    }

    public void setHtmlAttributes(String[] htmlAttributes) {
        this.htmlAttributes = htmlAttributes;
    }

    public DebugInfo resolveDebugInfo(ClassLoader classLoader, StackTraceElement[] stackTrace) {
        if (stackTrace.length == 0) {
            return null;
        }
        for (StackTraceElement stackTraceElement : stackTrace) {
            ClassInfo classInfo;
            if (!stackTraceElement.getClassName().startsWith(PACKAGE_NAME) || (classInfo = this.templateByClassName.get(stackTraceElement.getClassName())) == null) continue;
            return new DebugInfo(classInfo.name, this.resolveLineNumber(classLoader, classInfo, stackTraceElement.getLineNumber()));
        }
        return null;
    }

    private int resolveLineNumber(ClassLoader classLoader, ClassInfo classInfo, int lineNumber) {
        try {
            Class<?> clazz = classLoader.loadClass(classInfo.fullName);
            Field lineInfoField = clazz.getField(LINE_INFO_FIELD);
            int[] javaLineToTemplateLine = (int[])lineInfoField.get(null);
            return javaLineToTemplateLine[lineNumber - 1] + 1;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static class LayoutStack {
        public final String name;
        public final List<String> params;

        public LayoutStack(String name, List<String> params) {
            this.name = name;
            this.params = params;
        }
    }

    private static final class ParamCallInfo {
        final String name;
        final String data;

        public ParamCallInfo(String param) {
            param = param.trim();
            int nameEndIndex = -1;
            int dataStartIndex = -1;
            for (int i = 0; i < param.length(); ++i) {
                char character = param.charAt(i);
                if (nameEndIndex == -1) {
                    if (character == '\"' || character == '\'') break;
                    if (character != '=') continue;
                    nameEndIndex = i;
                    continue;
                }
                if (dataStartIndex != -1 || Character.isWhitespace(character)) continue;
                dataStartIndex = i;
            }
            if (nameEndIndex != -1 && dataStartIndex != -1) {
                this.name = param.substring(0, nameEndIndex).trim();
                this.data = param.substring(dataStartIndex).trim();
            } else {
                this.name = null;
                this.data = param;
            }
        }
    }

    private class CodeGenerator
    implements TemplateParserVisitor {
        private final ClassInfo classInfo;
        private final TemplateType type;
        private final CodeBuilder javaCode = new CodeBuilder();
        private final LinkedHashSet<ClassDefinition> classDefinitions;
        private final LinkedHashSet<String> templateDependencies;
        private final List<ParamInfo> parameters = new ArrayList<ParamInfo>();
        private final Deque<LayoutStack> layoutStack = new ArrayDeque<LayoutStack>();
        private boolean hasWrittenPackage;
        private boolean hasWrittenClass;

        private CodeGenerator(ClassInfo classInfo, TemplateType type, LinkedHashSet<ClassDefinition> classDefinitions, LinkedHashSet<String> templateDependencies) {
            this.classInfo = classInfo;
            this.type = type;
            this.classDefinitions = classDefinitions;
            this.templateDependencies = templateDependencies;
        }

        @Override
        public void onImport(String importClass) {
            this.writePackageIfRequired();
            this.javaCode.append("import ").append(importClass).append(";\n");
        }

        private void writePackageIfRequired() {
            if (!this.hasWrittenPackage) {
                this.javaCode.append("package " + this.classInfo.packageName + ";\n");
                this.hasWrittenPackage = true;
            }
        }

        @Override
        public void onParam(ParamInfo parameter) {
            this.writePackageIfRequired();
            if (!this.hasWrittenClass) {
                this.writeClass();
            }
            this.javaCode.append(", ").append(parameter.type).append(' ').append(parameter.name);
            this.parameters.add(parameter);
        }

        private void writeClass() {
            this.javaCode.append("public final class ").append(this.classInfo.className).append(" {\n");
            this.javaCode.markFieldsIndex();
            this.javaCode.append("\tpublic static void render(org.jusecase.jte.TemplateOutput output, org.jusecase.jte.support.HtmlTagSupport htmlTagSupport");
            if (this.type == TemplateType.Layout) {
                this.javaCode.append(", java.util.function.Function<String, Runnable> jteLayoutDefinitionLookup");
            }
            this.hasWrittenClass = true;
        }

        @Override
        public void onParamsComplete() {
            this.writePackageIfRequired();
            if (!this.hasWrittenClass) {
                this.writeClass();
            }
            this.javaCode.append(") {\n");
            TemplateCompiler.this.paramOrder.put(this.classInfo.name, this.parameters);
        }

        @Override
        public void onLineFinished() {
            this.javaCode.finishTemplateLine();
        }

        @Override
        public void onComplete() {
            int lineCount = 1;
            this.javaCode.insertFieldLines(lineCount);
            StringBuilder fields = new StringBuilder(64 + 32 * lineCount);
            this.javaCode.addLineInfoField(fields);
            this.javaCode.insertFields(fields);
            this.javaCode.append("\t}\n");
            this.javaCode.append("\tpublic static void renderMap(org.jusecase.jte.TemplateOutput output, org.jusecase.jte.support.HtmlTagSupport htmlTagSupport");
            if (this.type == TemplateType.Layout) {
                this.javaCode.append(", java.util.function.Function<String, Runnable> jteLayoutDefinitionLookup");
            }
            this.javaCode.append(", java.util.Map<String, Object> params) {\n");
            for (ParamInfo parameter : this.parameters) {
                if (parameter.varargs) continue;
                this.javaCode.append("\t\t").append(parameter.type).append(" ").append(parameter.name).append(" = (").append(parameter.type);
                if (parameter.defaultValue != null) {
                    this.javaCode.append(")params.getOrDefault(\"").append(parameter.name).append("\", ");
                    this.javaCode.append(parameter.defaultValue).append(");\n");
                    continue;
                }
                this.javaCode.append(")params.get(\"").append(parameter.name).append("\");\n");
            }
            this.javaCode.append("\t\trender(output, htmlTagSupport");
            if (this.type == TemplateType.Layout) {
                this.javaCode.append(", jteLayoutDefinitionLookup");
            }
            for (ParamInfo parameter : this.parameters) {
                if (parameter.varargs) continue;
                this.javaCode.append(", ").append(parameter.name);
            }
            this.javaCode.append(");\n");
            this.javaCode.append("\t}\n");
            this.javaCode.append("}\n");
            this.classInfo.lineInfo = this.javaCode.getLineInfo();
        }

        @Override
        public void onTextPart(int depth, String textPart) {
            if (textPart.isEmpty()) {
                return;
            }
            this.writeIndentation(depth);
            this.javaCode.append("output.writeStaticContent(\"");
            this.appendEscaped(this.javaCode.getStringBuilder(), textPart);
            this.javaCode.append("\");\n");
        }

        @Override
        public void onCodePart(int depth, String codePart) {
            this.writeCodePart(depth, codePart, "output.writeSafe(");
        }

        @Override
        public void onUnsafeCodePart(int depth, String codePart) {
            this.writeCodePart(depth, codePart, "output.writeUnsafe(");
        }

        private void writeCodePart(int depth, String codePart, String method) {
            this.writeIndentation(depth);
            if (TemplateCompiler.this.nullSafeTemplateCode) {
                this.javaCode.append("try {\n");
                this.writeIndentation(depth + 1);
            }
            this.javaCode.append(method).append(codePart).append(");\n");
            if (TemplateCompiler.this.nullSafeTemplateCode) {
                this.writeIndentation(depth);
                this.javaCode.append("} catch (NullPointerException outputNpe) {\n");
                this.writeIndentation(depth + 1);
                this.javaCode.append("org.jusecase.jte.internal.NullCheck.handleNullOutput(outputNpe);\n");
                this.writeIndentation(depth);
                this.javaCode.append("}\n");
            }
        }

        @Override
        public void onCodeStatement(int depth, String codePart) {
            this.writeIndentation(depth);
            if (TemplateCompiler.this.nullSafeTemplateCode) {
                int index = codePart.indexOf(61);
                if (index == -1) {
                    this.javaCode.append("org.jusecase.jte.internal.NullCheck.evaluate(() -> ");
                    this.javaCode.append(codePart);
                    this.javaCode.append(")");
                } else {
                    this.javaCode.append(codePart, 0, index + 1);
                    this.javaCode.append(" org.jusecase.jte.internal.NullCheck.evaluate(() -> ");
                    this.javaCode.append(codePart, index + 2, codePart.length());
                    this.javaCode.append(")");
                }
            } else {
                this.javaCode.append(codePart);
            }
            this.javaCode.append(";\n");
        }

        @Override
        public void onConditionStart(int depth, String condition) {
            this.writeIndentation(depth);
            this.javaCode.append("if (");
            if (TemplateCompiler.this.nullSafeTemplateCode) {
                this.javaCode.append("org.jusecase.jte.internal.NullCheck.evaluate(() -> ").append(condition).append(")");
            } else {
                this.javaCode.append(condition);
            }
            this.javaCode.append(") {\n");
        }

        @Override
        public void onConditionElse(int depth, String condition) {
            this.writeIndentation(depth);
            this.javaCode.append("} else if (");
            if (TemplateCompiler.this.nullSafeTemplateCode) {
                this.javaCode.append("org.jusecase.jte.internal.NullCheck.evaluate(() -> ").append(condition).append(")");
            } else {
                this.javaCode.append(condition);
            }
            this.javaCode.append(") {\n");
        }

        @Override
        public void onConditionElse(int depth) {
            this.writeIndentation(depth);
            this.javaCode.append("} else {\n");
        }

        @Override
        public void onConditionEnd(int depth) {
            this.writeIndentation(depth);
            this.javaCode.append("}\n");
        }

        @Override
        public void onForLoopStart(int depth, String codePart) {
            this.writeIndentation(depth);
            this.javaCode.append("for (").append(codePart).append(") {\n");
        }

        @Override
        public void onForLoopEnd(int depth) {
            this.writeIndentation(depth);
            this.javaCode.append("}\n");
        }

        @Override
        public void onTag(int depth, String name, List<String> params) {
            String tagName = TemplateCompiler.TAG_DIRECTORY + name.replace('.', '/') + ".jte";
            ClassInfo tagInfo = TemplateCompiler.this.generateTag(tagName, this.classDefinitions, this.templateDependencies, this.getCurrentDebugInfo());
            this.writeIndentation(depth);
            this.javaCode.append(tagInfo.fullName).append(".render(output, htmlTagSupport");
            this.appendParams(tagName, params);
            this.javaCode.append(");\n");
        }

        @Override
        public void onLayout(int depth, String name, List<String> params) {
            String layoutName = TemplateCompiler.LAYOUT_DIRECTORY + name.replace('.', '/') + ".jte";
            ClassInfo layoutInfo = TemplateCompiler.this.generateLayout(layoutName, this.classDefinitions, this.templateDependencies, this.getCurrentDebugInfo());
            this.writeIndentation(depth);
            this.javaCode.append(layoutInfo.fullName).append(".render(output, htmlTagSupport");
            this.javaCode.append(", jteLayoutDefinition -> {\n");
            this.layoutStack.push(new LayoutStack(layoutName, params));
        }

        @Override
        public void onHtmlTagOpened(int depth, TemplateParser.HtmlTag htmlTag) {
            this.writeIndentation(depth);
            this.javaCode.append("htmlTagSupport.onHtmlTagOpened(\"").append(htmlTag.name).append("\", ");
            this.writeAttributeMap(htmlTag);
            this.javaCode.append(", output);\n");
        }

        @Override
        public void onHtmlAttributeStarted(int depth, TemplateParser.HtmlTag currentHtmlTag, TemplateParser.HtmlAttribute htmlAttribute) {
            this.writeIndentation(depth);
            this.javaCode.append("htmlTagSupport.onHtmlAttributeStarted(\"").append(htmlAttribute.name).append("\", ");
            this.writeAttributeMap(currentHtmlTag);
            this.javaCode.append(", output);\n");
        }

        @Override
        public void onHtmlTagClosed(int depth, TemplateParser.HtmlTag htmlTag) {
            this.writeIndentation(depth);
            this.javaCode.append("htmlTagSupport.onHtmlTagClosed(\"").append(htmlTag.name).append("\", output);\n");
        }

        private void writeAttributeMap(TemplateParser.HtmlTag htmlTag) {
            this.javaCode.append("org.jusecase.jte.internal.IoUtils.toMap(");
            boolean firstWritten = false;
            for (TemplateParser.HtmlAttribute attribute : htmlTag.attributes) {
                if (attribute.value == null) continue;
                if (firstWritten) {
                    this.javaCode.append(",");
                } else {
                    firstWritten = true;
                }
                this.javaCode.append("\"").append(attribute.name).append("\",");
                if (attribute.value.startsWith("${") && attribute.value.endsWith("}")) {
                    this.javaCode.append(attribute.value.substring(2, attribute.value.length() - 1));
                    continue;
                }
                this.javaCode.append("\"").append(attribute.value).append("\"");
            }
            this.javaCode.append(")");
        }

        private DebugInfo getCurrentDebugInfo() {
            return new DebugInfo(this.classInfo.name, this.javaCode.getCurrentTemplateLine() + 1);
        }

        private void appendParams(String name, List<String> params) {
            List<ParamInfo> paramInfos = TemplateCompiler.this.paramOrder.get(name);
            if (paramInfos == null) {
                throw new IllegalStateException("No parameter information for " + name);
            }
            if (paramInfos.isEmpty()) {
                return;
            }
            int index = 0;
            ParamCallInfo[] paramCallInfos = new ParamCallInfo[Math.max(params.size(), paramInfos.size())];
            for (String param : params) {
                ParamCallInfo paramCallInfo = new ParamCallInfo(param);
                int parameterIndex = this.getParameterIndex(name, paramInfos, paramCallInfo);
                if (parameterIndex == -1) {
                    parameterIndex = index;
                }
                paramCallInfos[parameterIndex] = paramCallInfo;
                ++index;
            }
            for (int i = 0; i < paramCallInfos.length; ++i) {
                ParamCallInfo paramCallInfo = paramCallInfos[i];
                if (paramCallInfo != null) {
                    this.javaCode.append(", ").append(paramCallInfo.data);
                    continue;
                }
                ParamInfo paramInfo = paramInfos.get(i);
                if (paramInfo.defaultValue == null) continue;
                this.javaCode.append(", ").append(paramInfo.defaultValue);
            }
        }

        private int getParameterIndex(String name, List<ParamInfo> paramInfos, ParamCallInfo paramCallInfo) {
            if (paramCallInfo.name == null) {
                return -1;
            }
            for (int i = 0; i < paramInfos.size(); ++i) {
                if (!paramInfos.get((int)i).name.equals(paramCallInfo.name)) continue;
                return i;
            }
            throw new IllegalStateException("No parameter with name " + paramCallInfo.name + " is defined in " + name);
        }

        @Override
        public void onLayoutRender(int depth, String name) {
            this.writeIndentation(depth);
            this.javaCode.append("jteLayoutDefinitionLookup.apply(\"").append(name.trim()).append("\").run();\n");
        }

        @Override
        public void onLayoutDefine(int depth, String name) {
            this.writeIndentation(depth + 1);
            this.javaCode.append("if (\"").append(name.trim()).append("\".equals(jteLayoutDefinition)) {\n");
            this.writeIndentation(depth + 2);
            this.javaCode.append("return () -> {\n");
        }

        @Override
        public void onLayoutDefineEnd(int depth) {
            this.writeIndentation(depth + 2);
            this.javaCode.append("};\n");
            this.writeIndentation(depth + 1);
            this.javaCode.append("}\n");
        }

        @Override
        public void onLayoutEnd(int depth) {
            this.writeIndentation(depth + 1);
            if (this.type == TemplateType.Layout) {
                this.javaCode.append("return jteLayoutDefinitionLookup.apply(jteLayoutDefinition);\n");
            } else {
                this.javaCode.append("return () -> {};\n");
            }
            this.writeIndentation(depth);
            this.javaCode.append("}");
            if (!this.layoutStack.isEmpty()) {
                LayoutStack stack = this.layoutStack.pop();
                this.appendParams(stack.name, stack.params);
            }
            this.javaCode.append(");\n");
        }

        private void writeIndentation(int depth) {
            for (int i = 0; i < depth + 2; ++i) {
                this.javaCode.append('\t');
            }
        }

        private void appendEscaped(StringBuilder javaCode, String text) {
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '\"') {
                    javaCode.append("\\\"");
                    continue;
                }
                if (c == '\n') {
                    javaCode.append("\\n");
                    continue;
                }
                if (c == '\t') {
                    javaCode.append("\\t");
                    continue;
                }
                if (c == '\r') {
                    javaCode.append("\\r");
                    continue;
                }
                if (c == '\f') {
                    javaCode.append("\\f");
                    continue;
                }
                if (c == '\b') {
                    javaCode.append("\\b");
                    continue;
                }
                if (c == '\\') {
                    javaCode.append("\\\\");
                    continue;
                }
                javaCode.append(c);
            }
        }

        public String getCode() {
            return this.javaCode.getCode();
        }
    }
}

