/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.jte.resolve;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jusecase.jte.CodeResolver;
import org.jusecase.jte.TemplateEngine;

public class DirectoryCodeResolver
implements CodeResolver {
    private final Path root;
    private final ConcurrentMap<String, Long> modificationTimes = new ConcurrentHashMap<String, Long>();
    private Thread reloadThread;

    public DirectoryCodeResolver(Path root) {
        this.root = root;
    }

    @Override
    public String resolve(String name) {
        try {
            Path file = this.root.resolve(name);
            this.modificationTimes.put(name, this.getLastModified(file));
            return Files.readString(file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean hasChanged(String name) {
        Long lastResolveTime = (Long)this.modificationTimes.get(name);
        if (lastResolveTime == null) {
            return true;
        }
        long lastModified = this.getLastModified(this.root.resolve(name));
        return lastModified != lastResolveTime;
    }

    private long getLastModified(Path file) {
        return file.toFile().lastModified();
    }

    @Override
    public List<String> resolveAllTemplateNames() {
        List<String> list;
        block8: {
            Stream<Path> stream = Files.walk(this.root, new FileVisitOption[0]);
            try {
                list = stream.filter(p -> !Files.isDirectory(p, new LinkOption[0])).map(p -> this.root.relativize((Path)p).toString().replace('\\', '/')).filter(s -> !s.startsWith("tag/") && !s.startsWith("layout/")).filter(s -> s.endsWith(".jte")).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to resolve all templates in " + this.root, e);
                }
            }
            stream.close();
        }
        return list;
    }

    public void startTemplateFilesListener(TemplateEngine templateEngine, Consumer<List<String>> onTemplatesChanged) {
        this.reloadThread = new Thread(() -> this.startTemplateFilesListenerBlocking(templateEngine, onTemplatesChanged));
        this.reloadThread.setName("jte-reloader");
        this.reloadThread.setDaemon(true);
        this.reloadThread.start();
    }

    public void stopTemplateFilesListener() {
        this.reloadThread.interrupt();
        this.reloadThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTemplateFilesListenerBlocking(TemplateEngine templateEngine, Consumer<List<String>> onTemplatesChanged) {
        try (WatchService watchService = FileSystems.getDefault().newWatchService();){
            WatchKey watchKey;
            Files.walk(this.root, new FileVisitOption[0]).filter(p -> Files.isDirectory(p, new LinkOption[0])).forEach(p -> {
                try {
                    p.register(watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY}, SensitivityWatchEventModifier.HIGH);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to register watch service for hot reload!", e);
                }
            });
            while ((watchKey = watchService.take()) != null) {
                try {
                    List<WatchEvent<?>> events = watchKey.pollEvents();
                    for (WatchEvent<?> event : events) {
                        Path file;
                        Path absoluteFile;
                        String eventContext = event.context().toString();
                        if (!eventContext.endsWith(".jte") || (absoluteFile = this.root.resolve(file = this.root.relativize((Path)watchKey.watchable()).resolve(eventContext))).toFile().length() <= 0L) continue;
                        String name = file.toString().replace('\\', '/');
                        List<String> changedTemplates = templateEngine.getTemplatesUsing(name);
                        if (onTemplatesChanged == null) continue;
                        onTemplatesChanged.accept(changedTemplates);
                    }
                }
                finally {
                    watchKey.reset();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to watch page content", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

