/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.jte.internal;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jusecase.jte.CodeResolver;
import org.jusecase.jte.ContentType;
import org.jusecase.jte.TemplateException;
import org.jusecase.jte.html.HtmlPolicy;
import org.jusecase.jte.html.OwaspHtmlPolicy;
import org.jusecase.jte.internal.ClassDefinition;
import org.jusecase.jte.internal.ClassFilesCompiler;
import org.jusecase.jte.internal.ClassInfo;
import org.jusecase.jte.internal.CodeBuilder;
import org.jusecase.jte.internal.DebugInfo;
import org.jusecase.jte.internal.IoUtils;
import org.jusecase.jte.internal.ParamInfo;
import org.jusecase.jte.internal.Template;
import org.jusecase.jte.internal.TemplateLoader;
import org.jusecase.jte.internal.TemplateParser;
import org.jusecase.jte.internal.TemplateParserVisitor;
import org.jusecase.jte.internal.TemplateType;
import org.jusecase.jte.output.FileOutput;

public class TemplateCompiler
extends TemplateLoader {
    public static final boolean DEBUG = false;
    private final CodeResolver codeResolver;
    private final ContentType contentType;
    private final ConcurrentHashMap<String, LinkedHashSet<String>> templateDependencies = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, List<ParamInfo>> paramOrder = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ClassInfo> templateByClassName = new ConcurrentHashMap();
    private boolean nullSafeTemplateCode;
    private HtmlPolicy htmlPolicy = new OwaspHtmlPolicy();
    private String[] htmlTags;
    private String[] htmlAttributes;

    public TemplateCompiler(CodeResolver codeResolver, Path classDirectory, ContentType contentType) {
        super(classDirectory);
        this.codeResolver = codeResolver;
        this.contentType = contentType;
    }

    public Template load(String name) {
        this.precompile(List.of(name), null);
        return super.load(name);
    }

    protected ClassInfo getClassInfo(ClassLoader classLoader, String className) {
        return this.templateByClassName.get(className);
    }

    protected ClassLoader getClassLoader() {
        return this.createClassLoader();
    }

    public void cleanAll() {
        IoUtils.deleteDirectoryContent(this.classDirectory);
    }

    public int precompileAll(List<String> compilePath) {
        return this.precompile(this.codeResolver.resolveAllTemplateNames(), compilePath);
    }

    public int precompile(List<String> names, List<String> compilePath) {
        LinkedHashSet<ClassDefinition> classDefinitions = new LinkedHashSet<ClassDefinition>();
        for (String name : names) {
            switch (this.getTemplateType(name)) {
                case Template: {
                    this.generateTemplate(name, classDefinitions);
                    break;
                }
                case Tag: {
                    this.generateTemplateFromTag(name, classDefinitions);
                    break;
                }
                case Layout: {
                    this.generateTemplateFromLayout(name, classDefinitions);
                }
            }
        }
        for (ClassDefinition classDefinition : classDefinitions) {
            try (FileOutput fileOutput = new FileOutput(this.classDirectory.resolve(classDefinition.getJavaFileName()));){
                fileOutput.writeContent(classDefinition.getCode());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        String[] files = new String[classDefinitions.size()];
        int i = 0;
        for (ClassDefinition classDefinition : classDefinitions) {
            files[i++] = this.classDirectory.resolve(classDefinition.getJavaFileName()).toFile().getAbsolutePath();
        }
        ClassFilesCompiler.compile(files, compilePath, this.classDirectory, this.templateByClassName);
        return files.length;
    }

    private void generateTemplate(String name, LinkedHashSet<ClassDefinition> classDefinitions) {
        String code = this.resolveCode(name, null);
        LinkedHashSet<String> templateDependencies = new LinkedHashSet<String>();
        ClassInfo templateInfo = new ClassInfo(name, "org.jusecase.jte.generated");
        CodeGenerator codeGenerator = new CodeGenerator(templateInfo, classDefinitions, templateDependencies);
        new TemplateParser(code, TemplateType.Template, codeGenerator, this.contentType, this.htmlPolicy, this.htmlTags, this.htmlAttributes).parse();
        this.templateDependencies.put(name, templateDependencies);
        ClassDefinition templateDefinition = new ClassDefinition(templateInfo.fullName);
        templateDefinition.setCode(codeGenerator.getCode());
        classDefinitions.add(templateDefinition);
        this.templateByClassName.put(templateDefinition.getName(), templateInfo);
    }

    private void generateTemplateFromTag(String name, LinkedHashSet<ClassDefinition> classDefinitions) {
        LinkedHashSet<String> templateDependencies = new LinkedHashSet<String>();
        ClassInfo templateInfo = this.generateTagOrLayout(TemplateType.Tag, name, classDefinitions, templateDependencies, null);
        this.templateDependencies.put(name, templateDependencies);
        this.templateByClassName.put(templateInfo.name, templateInfo);
    }

    private void generateTemplateFromLayout(String name, LinkedHashSet<ClassDefinition> classDefinitions) {
        LinkedHashSet<String> templateDependencies = new LinkedHashSet<String>();
        ClassInfo templateInfo = this.generateTagOrLayout(TemplateType.Layout, name, classDefinitions, templateDependencies, null);
        this.templateDependencies.put(name, templateDependencies);
        this.templateByClassName.put(templateInfo.name, templateInfo);
    }

    private ClassInfo generateTagOrLayout(TemplateType type, String name, LinkedHashSet<ClassDefinition> classDefinitions, LinkedHashSet<String> templateDependencies, DebugInfo debugInfo) {
        templateDependencies.add(name);
        ClassInfo classInfo = new ClassInfo(name, "org.jusecase.jte.generated");
        ClassDefinition classDefinition = new ClassDefinition(classInfo.fullName);
        if (classDefinitions.contains(classDefinition)) {
            return classInfo;
        }
        String code = this.resolveCode(name, debugInfo);
        classDefinitions.add(classDefinition);
        CodeGenerator codeGenerator = new CodeGenerator(classInfo, classDefinitions, templateDependencies);
        new TemplateParser(code, type, codeGenerator, this.contentType, this.htmlPolicy, this.htmlTags, this.htmlAttributes).parse();
        classDefinition.setCode(codeGenerator.getCode());
        this.templateByClassName.put(classDefinition.getName(), classInfo);
        return classInfo;
    }

    private String resolveCode(String name, DebugInfo debugInfo) {
        String code = this.codeResolver.resolve(name);
        if (code == null) {
            String message = name + " not found";
            if (debugInfo != null) {
                message = message + ", referenced at " + debugInfo.name + ":" + debugInfo.line;
            }
            throw new TemplateException(message);
        }
        return code;
    }

    public boolean hasChanged(String name) {
        if (this.codeResolver.hasChanged(name)) {
            return true;
        }
        LinkedHashSet<String> dependencies = this.templateDependencies.get(name);
        if (dependencies == null) {
            return false;
        }
        for (String dependency : dependencies) {
            if (!this.codeResolver.hasChanged(dependency)) continue;
            return true;
        }
        return false;
    }

    public List<String> getTemplatesUsing(String name) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, LinkedHashSet<String>> dependencies : this.templateDependencies.entrySet()) {
            if (!dependencies.getValue().contains(name)) continue;
            result.add(dependencies.getKey());
        }
        return result;
    }

    public void setNullSafeTemplateCode(boolean nullSafeTemplateCode) {
        this.nullSafeTemplateCode = nullSafeTemplateCode;
    }

    public void setHtmlPolicy(HtmlPolicy htmlPolicy) {
        this.htmlPolicy = htmlPolicy;
    }

    public void setHtmlTags(String[] htmlTags) {
        this.htmlTags = htmlTags;
    }

    public void setHtmlAttributes(String[] htmlAttributes) {
        this.htmlAttributes = htmlAttributes;
    }

    private static final class ParamCallInfo {
        final String name;
        final String data;

        public ParamCallInfo(String param) {
            param = param.trim();
            int nameEndIndex = -1;
            int dataStartIndex = -1;
            for (int i = 0; i < param.length(); ++i) {
                char character = param.charAt(i);
                if (nameEndIndex == -1) {
                    if (character == '\"' || character == '\'') break;
                    if (character != '=') continue;
                    nameEndIndex = i;
                    continue;
                }
                if (dataStartIndex != -1 || Character.isWhitespace(character)) continue;
                dataStartIndex = i;
            }
            if (nameEndIndex != -1 && dataStartIndex != -1) {
                this.name = param.substring(0, nameEndIndex).trim();
                this.data = param.substring(dataStartIndex).trim();
            } else {
                this.name = null;
                this.data = param;
            }
        }
    }

    private class CodeGenerator
    implements TemplateParserVisitor {
        private final ClassInfo classInfo;
        private final CodeBuilder javaCode = new CodeBuilder();
        private final LinkedHashSet<ClassDefinition> classDefinitions;
        private final LinkedHashSet<String> templateDependencies;
        private final List<ParamInfo> parameters = new ArrayList<ParamInfo>();
        private boolean hasWrittenPackage;
        private boolean hasWrittenClass;

        private CodeGenerator(ClassInfo classInfo, LinkedHashSet<ClassDefinition> classDefinitions, LinkedHashSet<String> templateDependencies) {
            this.classInfo = classInfo;
            this.classDefinitions = classDefinitions;
            this.templateDependencies = templateDependencies;
        }

        @Override
        public void onImport(String importClass) {
            this.writePackageIfRequired();
            this.javaCode.append("import ").append(importClass).append(";\n");
        }

        private void writePackageIfRequired() {
            if (!this.hasWrittenPackage) {
                this.javaCode.append("package " + this.classInfo.packageName + ";\n");
                this.hasWrittenPackage = true;
            }
        }

        @Override
        public void onParam(ParamInfo parameter) {
            this.writePackageIfRequired();
            if (!this.hasWrittenClass) {
                this.writeClass();
            }
            this.javaCode.append(", ").append(parameter.type).append(' ').append(parameter.name);
            this.parameters.add(parameter);
        }

        private void writeClass() {
            this.javaCode.append("public final class ").append(this.classInfo.className).append(" {\n");
            this.javaCode.markFieldsIndex();
            this.javaCode.append("\tpublic static void render(");
            this.writeTemplateOutputParam();
            this.javaCode.append(", org.jusecase.jte.html.HtmlInterceptor jteHtmlInterceptor");
            this.hasWrittenClass = true;
        }

        private String getContentClass() {
            if (TemplateCompiler.this.contentType == ContentType.Html) {
                return "org.jusecase.jte.html.HtmlContent";
            }
            return "org.jusecase.jte.Content";
        }

        private void writeTemplateOutputParam() {
            if (TemplateCompiler.this.contentType == ContentType.Html) {
                this.javaCode.append("org.jusecase.jte.html.HtmlTemplateOutput jteOutput");
            } else {
                this.javaCode.append("org.jusecase.jte.TemplateOutput jteOutput");
            }
        }

        @Override
        public void onParamsComplete() {
            this.writePackageIfRequired();
            if (!this.hasWrittenClass) {
                this.writeClass();
            }
            this.javaCode.append(") {\n");
            TemplateCompiler.this.paramOrder.put(this.classInfo.name, this.parameters);
        }

        @Override
        public void onLineFinished() {
            this.javaCode.finishTemplateLine();
        }

        @Override
        public void onComplete() {
            int lineCount = 2;
            this.javaCode.insertFieldLines(lineCount);
            StringBuilder fields = new StringBuilder(64 + 32 * lineCount);
            this.javaCode.addNameField(fields, this.classInfo.name);
            this.javaCode.addLineInfoField(fields);
            this.javaCode.insertFields(fields);
            this.javaCode.append("\t}\n");
            this.javaCode.append("\tpublic static void renderMap(");
            this.writeTemplateOutputParam();
            this.javaCode.append(", org.jusecase.jte.html.HtmlInterceptor jteHtmlInterceptor");
            this.javaCode.append(", java.util.Map<String, Object> params) {\n");
            for (ParamInfo parameter : this.parameters) {
                if (parameter.varargs) continue;
                this.javaCode.append("\t\t").append(parameter.type).append(" ").append(parameter.name).append(" = (").append(parameter.type);
                if (parameter.defaultValue != null) {
                    this.javaCode.append(")params.getOrDefault(\"").append(parameter.name).append("\", ");
                    this.writeJavaCodeWithContentSupport(0, parameter.defaultValue);
                    this.javaCode.append(");\n");
                    continue;
                }
                this.javaCode.append(")params.get(\"").append(parameter.name).append("\");\n");
            }
            this.javaCode.append("\t\trender(jteOutput, jteHtmlInterceptor");
            for (ParamInfo parameter : this.parameters) {
                if (parameter.varargs) continue;
                this.javaCode.append(", ").append(parameter.name);
            }
            this.javaCode.append(");\n");
            this.javaCode.append("\t}\n");
            this.javaCode.append("}\n");
            this.classInfo.lineInfo = this.javaCode.getLineInfo();
        }

        @Override
        public void onError(String message) {
            DebugInfo debugInfo = this.getCurrentDebugInfo();
            throw new TemplateException("Failed to compile " + debugInfo.name + ", error at line " + debugInfo.line + ": " + message);
        }

        @Override
        public void onTextPart(int depth, String textPart) {
            if (textPart.isEmpty()) {
                return;
            }
            this.writeIndentation(depth);
            this.javaCode.append("jteOutput.writeContent(\"");
            this.appendEscaped(this.javaCode.getStringBuilder(), textPart);
            this.javaCode.append("\");\n");
        }

        @Override
        public void onCodePart(int depth, String codePart) {
            this.writeCodePart(depth, codePart);
        }

        @Override
        public void onHtmlTagBodyCodePart(int depth, String codePart, String tagName) {
            this.writeIndentation(depth);
            this.javaCode.append("jteOutput.setContext(\"").append(tagName).append("\", null);\n");
            this.writeCodePart(depth, codePart);
        }

        @Override
        public void onHtmlTagAttributeCodePart(int depth, String codePart, String tagName, String attributeName) {
            this.writeIndentation(depth);
            this.javaCode.append("jteOutput.setContext(\"").append(tagName).append("\", \"").append(attributeName).append("\");\n");
            this.writeCodePart(depth, codePart);
        }

        @Override
        public void onUnsafeCodePart(int depth, String codePart) {
            if (TemplateCompiler.this.contentType == ContentType.Html) {
                this.writeIndentation(depth);
                this.javaCode.append("jteOutput.setContext(null, null);\n");
            }
            this.writeCodePart(depth, codePart);
        }

        private void writeCodePart(int depth, String codePart) {
            this.writeIndentation(depth);
            if (TemplateCompiler.this.nullSafeTemplateCode) {
                this.javaCode.append("try {\n");
                this.writeIndentation(depth + 1);
            }
            this.javaCode.append("jteOutput.writeUserContent(");
            this.writeJavaCodeWithContentSupport(depth, codePart);
            this.javaCode.append(");\n");
            if (TemplateCompiler.this.nullSafeTemplateCode) {
                this.writeIndentation(depth);
                this.javaCode.append("} catch (NullPointerException jteOutputNpe) {\n");
                this.writeIndentation(depth + 1);
                this.javaCode.append("org.jusecase.jte.internal.NullCheck.handleNullOutput(jteOutputNpe);\n");
                this.writeIndentation(depth);
                this.javaCode.append("}\n");
            }
        }

        @Override
        public void onCodeStatement(int depth, String codePart) {
            this.writeIndentation(depth);
            if (TemplateCompiler.this.nullSafeTemplateCode) {
                int index = codePart.indexOf(61);
                if (index == -1) {
                    this.javaCode.append("org.jusecase.jte.internal.NullCheck.evaluate(() -> ");
                    this.javaCode.append(codePart);
                    this.javaCode.append(")");
                } else {
                    this.javaCode.append(codePart, 0, index + 1);
                    this.javaCode.append(" org.jusecase.jte.internal.NullCheck.evaluate(() -> ");
                    this.javaCode.append(codePart, index + 2, codePart.length());
                    this.javaCode.append(")");
                }
            } else {
                this.writeJavaCodeWithContentSupport(depth, codePart);
            }
            this.javaCode.append(";\n");
        }

        @Override
        public void onConditionStart(int depth, String condition) {
            this.writeIndentation(depth);
            this.javaCode.append("if (");
            if (TemplateCompiler.this.nullSafeTemplateCode) {
                this.javaCode.append("org.jusecase.jte.internal.NullCheck.evaluate(() -> ").append(condition).append(")");
            } else {
                this.javaCode.append(condition);
            }
            this.javaCode.append(") {\n");
        }

        @Override
        public void onConditionElse(int depth, String condition) {
            this.writeIndentation(depth);
            this.javaCode.append("} else if (");
            if (TemplateCompiler.this.nullSafeTemplateCode) {
                this.javaCode.append("org.jusecase.jte.internal.NullCheck.evaluate(() -> ").append(condition).append(")");
            } else {
                this.javaCode.append(condition);
            }
            this.javaCode.append(") {\n");
        }

        @Override
        public void onConditionElse(int depth) {
            this.writeIndentation(depth);
            this.javaCode.append("} else {\n");
        }

        @Override
        public void onConditionEnd(int depth) {
            this.writeIndentation(depth);
            this.javaCode.append("}\n");
        }

        @Override
        public void onForLoopStart(int depth, String codePart) {
            this.writeIndentation(depth);
            this.javaCode.append("for (").append(codePart).append(") {\n");
        }

        @Override
        public void onForLoopEnd(int depth) {
            this.writeIndentation(depth);
            this.javaCode.append("}\n");
        }

        @Override
        public void onTag(int depth, TemplateType type, String name, List<String> params) {
            String directory = type == TemplateType.Layout ? "layout/" : "tag/";
            String tagName = directory + name.replace('.', '/') + ".jte";
            ClassInfo tagInfo = TemplateCompiler.this.generateTagOrLayout(type, tagName, this.classDefinitions, this.templateDependencies, this.getCurrentDebugInfo());
            this.writeIndentation(depth);
            this.javaCode.append(tagInfo.fullName).append(".render(jteOutput, jteHtmlInterceptor");
            this.appendParams(depth, tagName, params);
            this.javaCode.append(");\n");
        }

        @Override
        public void onHtmlTagOpened(int depth, TemplateParser.HtmlTag htmlTag) {
            this.writeIndentation(depth);
            this.javaCode.append("jteHtmlInterceptor.onHtmlTagOpened(\"").append(htmlTag.name).append("\", ");
            this.writeAttributeMap(htmlTag);
            this.javaCode.append(", jteOutput);\n");
        }

        @Override
        public void onHtmlAttributeStarted(int depth, TemplateParser.HtmlTag currentHtmlTag, TemplateParser.HtmlAttribute htmlAttribute) {
            this.writeIndentation(depth);
            this.javaCode.append("jteHtmlInterceptor.onHtmlAttributeStarted(\"").append(htmlAttribute.name).append("\", ");
            this.writeAttributeMap(currentHtmlTag);
            this.javaCode.append(", jteOutput);\n");
        }

        @Override
        public void onHtmlBooleanAttributeStarted(int depth, TemplateParser.HtmlTag currentHtmlTag, TemplateParser.HtmlAttribute htmlAttribute) {
            String javaExpression = this.extractJavaExpression(htmlAttribute.value);
            if (javaExpression == null) {
                this.onTextPart(depth, htmlAttribute.name);
            } else {
                this.onConditionStart(depth, javaExpression);
                this.onCodePart(depth + 1, "\"" + htmlAttribute.name + "\"");
                this.onConditionEnd(depth);
            }
        }

        @Override
        public void onHtmlTagClosed(int depth, TemplateParser.HtmlTag htmlTag) {
            this.writeIndentation(depth);
            this.javaCode.append("jteHtmlInterceptor.onHtmlTagClosed(\"").append(htmlTag.name).append("\", jteOutput);\n");
        }

        private void writeAttributeMap(TemplateParser.HtmlTag htmlTag) {
            this.javaCode.append("org.jusecase.jte.internal.TemplateUtils.toMap(");
            boolean firstWritten = false;
            for (TemplateParser.HtmlAttribute attribute : htmlTag.attributes) {
                if (attribute.value == null) continue;
                if (firstWritten) {
                    this.javaCode.append(",");
                } else {
                    firstWritten = true;
                }
                this.javaCode.append("\"").append(attribute.name).append("\",");
                String javaExpression = this.extractJavaExpression(attribute.value);
                if (javaExpression != null) {
                    this.javaCode.append(javaExpression);
                    continue;
                }
                this.javaCode.append("\"").append(attribute.value).append("\"");
            }
            this.javaCode.append(")");
        }

        private void writeJavaCodeWithContentSupport(int depth, String code) {
            if (code.contains("@`")) {
                new ContentProcessor(depth, code).process();
            } else {
                this.javaCode.append(code);
            }
        }

        private String extractJavaExpression(String value) {
            int startIndex = value.indexOf("${");
            if (startIndex == -1) {
                return null;
            }
            int endIndex = value.lastIndexOf(125);
            if (endIndex == -1) {
                return null;
            }
            return value.substring(startIndex + 2, endIndex);
        }

        private DebugInfo getCurrentDebugInfo() {
            return new DebugInfo(this.classInfo.name, this.javaCode.getCurrentTemplateLine() + 1);
        }

        private void appendParams(int depth, String name, List<String> params) {
            List<ParamInfo> paramInfos = TemplateCompiler.this.paramOrder.get(name);
            if (paramInfos == null) {
                throw new IllegalStateException("No parameter information for " + name);
            }
            if (paramInfos.isEmpty()) {
                return;
            }
            int index = 0;
            ParamCallInfo[] paramCallInfos = new ParamCallInfo[Math.max(params.size(), paramInfos.size())];
            for (String param : params) {
                ParamCallInfo paramCallInfo = new ParamCallInfo(param);
                int parameterIndex = this.getParameterIndex(name, paramInfos, paramCallInfo);
                if (parameterIndex == -1) {
                    parameterIndex = index;
                }
                paramCallInfos[parameterIndex] = paramCallInfo;
                ++index;
            }
            for (int i = 0; i < paramCallInfos.length; ++i) {
                ParamCallInfo paramCallInfo = paramCallInfos[i];
                if (paramCallInfo != null) {
                    this.appendParam(depth, paramCallInfo.data);
                    continue;
                }
                ParamInfo paramInfo = paramInfos.get(i);
                if (paramInfo.defaultValue == null) continue;
                this.appendParam(depth, paramInfo.defaultValue);
            }
        }

        private void appendParam(int depth, String param) {
            this.javaCode.append(", ");
            this.writeJavaCodeWithContentSupport(depth, param);
        }

        private int getParameterIndex(String name, List<ParamInfo> paramInfos, ParamCallInfo paramCallInfo) {
            if (paramCallInfo.name == null) {
                return -1;
            }
            for (int i = 0; i < paramInfos.size(); ++i) {
                if (!paramInfos.get((int)i).name.equals(paramCallInfo.name)) continue;
                return i;
            }
            throw new IllegalStateException("No parameter with name " + paramCallInfo.name + " is defined in " + name);
        }

        private void writeIndentation(int depth) {
            for (int i = 0; i < depth + 2; ++i) {
                this.javaCode.append('\t');
            }
        }

        private void appendEscaped(StringBuilder javaCode, String text) {
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '\"') {
                    javaCode.append("\\\"");
                    continue;
                }
                if (c == '\n') {
                    javaCode.append("\\n");
                    continue;
                }
                if (c == '\t') {
                    javaCode.append("\\t");
                    continue;
                }
                if (c == '\r') {
                    javaCode.append("\\r");
                    continue;
                }
                if (c == '\f') {
                    javaCode.append("\\f");
                    continue;
                }
                if (c == '\b') {
                    javaCode.append("\\b");
                    continue;
                }
                if (c == '\\') {
                    javaCode.append("\\\\");
                    continue;
                }
                javaCode.append(c);
            }
        }

        public String getCode() {
            return this.javaCode.getCode();
        }

        class ContentProcessor {
            private final int depth;
            private final String param;
            private int startIndex = -1;
            private int endIndex = -1;
            private int lastWrittenIndex = -1;
            private int nestedCount;
            private char previousChar0;
            private char currentChar;

            ContentProcessor(int depth, String param) {
                this.depth = depth;
                this.param = param;
            }

            public void process() {
                for (int i = 0; i < this.param.length(); ++i) {
                    this.previousChar0 = this.currentChar;
                    this.currentChar = this.param.charAt(i);
                    if (this.previousChar0 == '@' && this.currentChar == '`') {
                        if (this.startIndex == -1) {
                            this.startIndex = i + 1;
                            continue;
                        }
                        ++this.nestedCount;
                        continue;
                    }
                    if (this.currentChar != '`') continue;
                    if (this.nestedCount == 0) {
                        this.endIndex = i;
                        this.writeJavaCode();
                        continue;
                    }
                    --this.nestedCount;
                }
                if (this.lastWrittenIndex + 1 < this.param.length()) {
                    CodeGenerator.this.javaCode.append(this.param, this.lastWrittenIndex + 1, this.param.length());
                }
            }

            private void writeJavaCode() {
                CodeGenerator.this.javaCode.append(this.param, this.lastWrittenIndex + 1, this.startIndex - 2);
                CodeGenerator.this.javaCode.append("new ").append(CodeGenerator.this.getContentClass()).append("() {\n");
                CodeGenerator.this.writeIndentation(this.depth + 1);
                CodeGenerator.this.javaCode.append("public void writeTo(");
                CodeGenerator.this.writeTemplateOutputParam();
                CodeGenerator.this.javaCode.append(") {\n");
                TemplateParser parser = new TemplateParser(this.param, TemplateType.Content, CodeGenerator.this, TemplateCompiler.this.contentType, TemplateCompiler.this.htmlPolicy, TemplateCompiler.this.htmlTags, TemplateCompiler.this.htmlAttributes);
                parser.setStartIndex(this.startIndex);
                parser.setEndIndex(this.endIndex);
                parser.setParamsComplete(true);
                parser.parse(this.depth + 2);
                CodeGenerator.this.writeIndentation(this.depth + 1);
                CodeGenerator.this.javaCode.append("}\n");
                CodeGenerator.this.writeIndentation(this.depth);
                CodeGenerator.this.javaCode.append("}");
                this.lastWrittenIndex = this.endIndex;
                this.startIndex = -1;
                this.endIndex = -1;
            }
        }
    }
}

