/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.jte.internal;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import org.jusecase.jte.ContentType;
import org.jusecase.jte.html.HtmlPolicy;
import org.jusecase.jte.html.HtmlPolicyException;
import org.jusecase.jte.internal.ParamInfo;
import org.jusecase.jte.internal.TemplateParserVisitor;
import org.jusecase.jte.internal.TemplateType;

final class TemplateParser {
    private final String templateCode;
    private final TemplateType type;
    private final TemplateParserVisitor visitor;
    private final ContentType contentType;
    private final HtmlPolicy htmlPolicy;
    private final String[] htmlTags;
    private final String[] htmlAttributes;
    private final Deque<Mode> stack = new ArrayDeque<Mode>();
    private final Deque<HtmlTag> htmlStack = new ArrayDeque<HtmlTag>();
    private Mode currentMode;
    private HtmlTag currentHtmlTag;
    private int depth;
    private boolean paramsComplete;
    private boolean outputPrevented;
    private boolean tagClosed;
    private int i;
    private int startIndex;
    private int endIndex;
    private int lastIndex = 0;
    private char previousChar6;
    private char previousChar5;
    private char previousChar4;
    private char previousChar3;
    private char previousChar2;
    private char previousChar1;
    private char previousChar0;
    private char currentChar;

    TemplateParser(String templateCode, TemplateType type, TemplateParserVisitor visitor, ContentType contentType, HtmlPolicy htmlPolicy, String[] htmlTags, String[] htmlAttributes) {
        this.templateCode = templateCode;
        this.type = type;
        this.visitor = visitor;
        this.contentType = contentType;
        this.htmlPolicy = htmlPolicy;
        this.htmlTags = htmlTags;
        this.htmlAttributes = htmlAttributes;
        this.startIndex = 0;
        this.endIndex = templateCode.length();
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
        this.lastIndex = startIndex;
    }

    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }

    public void setParamsComplete(boolean paramsComplete) {
        this.paramsComplete = paramsComplete;
    }

    public void parse() {
        this.parse(0);
    }

    public void parse(int startingDepth) {
        try {
            this.doParse(startingDepth);
        }
        catch (HtmlPolicyException e) {
            this.visitor.onError(e.getMessage());
        }
    }

    private void doParse(int startingDepth) {
        this.currentMode = Mode.Text;
        this.stack.push(this.currentMode);
        this.depth = startingDepth;
        this.i = this.startIndex;
        while (this.i < this.endIndex) {
            TagMode previousMode;
            this.previousChar6 = this.previousChar5;
            this.previousChar5 = this.previousChar4;
            this.previousChar4 = this.previousChar3;
            this.previousChar3 = this.previousChar2;
            this.previousChar2 = this.previousChar1;
            this.previousChar1 = this.previousChar0;
            this.previousChar0 = this.currentChar;
            this.currentChar = this.templateCode.charAt(this.i);
            if (this.previousChar5 == '@' && this.previousChar4 == 'i' && this.previousChar3 == 'm' && this.previousChar2 == 'p' && this.previousChar1 == 'o' && this.previousChar0 == 'r' && this.currentChar == 't') {
                this.push(Mode.Import);
                this.lastIndex = this.i + 1;
            } else if (this.currentMode == Mode.Import && this.currentChar == '\n') {
                this.extract(this.templateCode, this.lastIndex, this.i, (depth, content) -> this.visitor.onImport(content.trim()));
                this.pop();
                this.lastIndex = this.i + 1;
            } else if (this.previousChar4 == '@' && this.previousChar3 == 'p' && this.previousChar2 == 'a' && this.previousChar1 == 'r' && this.previousChar0 == 'a' && this.currentChar == 'm') {
                this.push(Mode.Param);
                this.lastIndex = this.i + 1;
            } else if (this.currentMode == Mode.Param && this.currentChar == '\n') {
                this.extract(this.templateCode, this.lastIndex, this.i, (depth, content) -> this.visitor.onParam(new ParamInfo(content.trim())));
                this.pop();
                this.lastIndex = this.i + 1;
            } else if (this.currentMode != Mode.Comment && this.currentMode != Mode.Content && this.previousChar2 == '<' && this.previousChar1 == '%' && this.previousChar0 == '-' && this.currentChar == '-') {
                if (this.currentMode == Mode.Text && this.paramsComplete) {
                    this.extract(this.templateCode, this.lastIndex, this.i - 3, this.visitor::onTextPart);
                }
                this.push(Mode.Comment);
            } else if (this.currentMode == Mode.Comment) {
                if (this.previousChar2 == '-' && this.previousChar1 == '-' && this.previousChar0 == '%' && this.currentChar == '>') {
                    this.pop();
                    this.lastIndex = this.i + 1;
                }
            } else if (this.previousChar0 == '$' && this.currentChar == '{' && this.currentMode == Mode.Text) {
                if (!this.outputPrevented) {
                    this.extract(this.templateCode, this.lastIndex, this.i - 1, this.visitor::onTextPart);
                    this.lastIndex = this.i + 1;
                }
                this.push(Mode.Code);
            } else if (this.previousChar6 == '$' && this.previousChar5 == 'u' && this.previousChar4 == 'n' && this.previousChar3 == 's' && this.previousChar2 == 'a' && this.previousChar1 == 'f' && this.previousChar0 == 'e' && this.currentChar == '{' && this.currentMode == Mode.Text) {
                this.extract(this.templateCode, this.lastIndex, this.i - 7, this.visitor::onTextPart);
                this.lastIndex = this.i + 1;
                this.push(Mode.UnsafeCode);
            } else if (this.previousChar0 == '!' && this.currentChar == '{' && this.currentMode == Mode.Text) {
                this.extract(this.templateCode, this.lastIndex, this.i - 1, this.visitor::onTextPart);
                this.lastIndex = this.i + 1;
                this.push(Mode.CodeStatement);
            } else if (this.currentChar == '}' && this.currentMode == Mode.CodeStatement) {
                this.pop();
                if (this.currentMode == Mode.Text) {
                    this.extract(this.templateCode, this.lastIndex, this.i, this.visitor::onCodeStatement);
                    this.lastIndex = this.i + 1;
                }
            } else if (this.currentChar == '\"' && this.currentMode.isJava()) {
                this.push(Mode.JavaCodeString);
            } else if (this.currentChar == '\"' && this.currentMode == Mode.JavaCodeString && this.previousChar0 != '\\') {
                this.pop();
            } else if (this.currentChar == '}' && this.currentMode == Mode.Code) {
                this.pop();
                if (this.currentMode == Mode.Text && !this.outputPrevented) {
                    this.extractCodePart();
                }
            } else if (this.currentChar == '}' && this.currentMode == Mode.UnsafeCode) {
                this.pop();
                if (this.currentMode == Mode.Text) {
                    this.extract(this.templateCode, this.lastIndex, this.i, this.visitor::onUnsafeCodePart);
                    this.lastIndex = this.i + 1;
                }
            } else if (this.previousChar1 == '@' && this.previousChar0 == 'i' && this.currentChar == 'f' && this.currentMode == Mode.Text) {
                this.extract(this.templateCode, this.lastIndex, this.i - 2, this.visitor::onTextPart);
                this.lastIndex = this.i + 1;
                this.push(Mode.Condition);
            } else if (this.currentChar == '(' && (this.currentMode == Mode.Condition || this.currentMode == Mode.ConditionElse)) {
                this.lastIndex = this.i + 1;
                this.push(Mode.JavaCode);
            } else if (this.currentChar == '(' && this.currentMode.isJava()) {
                this.push(Mode.JavaCode);
            } else if (this.currentChar == ')' && this.currentMode.isJava()) {
                if (this.currentMode == Mode.JavaCodeParam) {
                    previousMode = this.getPreviousMode(TagMode.class);
                    this.extract(this.templateCode, this.lastIndex, this.i, (d, c) -> {
                        if (c != null && !c.isBlank()) {
                            previousMode.params.add(c);
                        }
                    });
                }
                this.pop();
                if (this.currentMode == Mode.Condition) {
                    this.extract(this.templateCode, this.lastIndex, this.i, this.visitor::onConditionStart);
                    this.lastIndex = this.i + 1;
                    this.push(Mode.Text);
                } else if (this.currentMode == Mode.ConditionElse) {
                    this.extract(this.templateCode, this.lastIndex, this.i, this.visitor::onConditionElse);
                    this.lastIndex = this.i + 1;
                    this.push(Mode.Text);
                } else if (this.currentMode instanceof TagMode) {
                    TagMode tagMode = (TagMode)this.currentMode;
                    if (this.contentType == ContentType.Html && this.currentHtmlTag != null && this.currentHtmlTag.innerTagsIgnored) {
                        this.visitor.onError("@" + tagMode.type.toString().toLowerCase() + " calls in <" + this.currentHtmlTag.name + "> blocks are not allowed.");
                    }
                    this.extract(this.templateCode, this.lastIndex, this.i, (d, c) -> this.visitor.onTag(d, tagMode.type, tagMode.name.toString(), tagMode.params));
                    this.lastIndex = this.i + 1;
                    this.pop();
                }
            } else if (this.previousChar0 == '@' && this.currentChar == '`' && this.isContentExpressionAllowed()) {
                this.push(Mode.Content);
            } else if (this.currentChar == '`' && this.currentMode == Mode.Content) {
                this.pop();
            } else if (this.currentChar == ',' && this.currentMode == Mode.JavaCodeParam) {
                previousMode = this.getPreviousMode(TagMode.class);
                this.extract(this.templateCode, this.lastIndex, this.i, (d, c) -> {
                    if (c != null && !c.isBlank()) {
                        previousMode.params.add(c);
                    }
                });
                this.lastIndex = this.i + 1;
            } else if (this.previousChar3 == '@' && this.previousChar2 == 'e' && this.previousChar1 == 'l' && this.previousChar0 == 's' && this.currentChar == 'e' && this.templateCode.charAt(this.i + 1) != 'i' && this.currentMode == Mode.Text) {
                this.extract(this.templateCode, this.lastIndex, this.i - 4, this.visitor::onTextPart);
                this.lastIndex = this.i + 1;
                this.pop();
                this.visitor.onConditionElse(this.depth);
                this.push(Mode.Text);
            } else if (this.previousChar5 == '@' && this.previousChar4 == 'e' && this.previousChar3 == 'l' && this.previousChar2 == 's' && this.previousChar1 == 'e' && this.previousChar0 == 'i' && this.currentChar == 'f' && this.currentMode == Mode.Text) {
                this.extract(this.templateCode, this.lastIndex, this.i - 6, this.visitor::onTextPart);
                this.lastIndex = this.i + 1;
                this.pop();
                if (this.currentMode == Mode.Condition || this.currentMode == Mode.ConditionElse) {
                    this.pop();
                }
                this.push(Mode.ConditionElse);
            } else if (this.previousChar4 == '@' && this.previousChar3 == 'e' && this.previousChar2 == 'n' && this.previousChar1 == 'd' && this.previousChar0 == 'i' && this.currentChar == 'f' && this.currentMode == Mode.Text) {
                this.extract(this.templateCode, this.lastIndex, this.i - 5, this.visitor::onTextPart);
                this.lastIndex = this.i + 1;
                this.pop();
                if (this.currentMode == Mode.Condition || this.currentMode == Mode.ConditionElse) {
                    this.visitor.onConditionEnd(this.depth);
                    this.pop();
                }
            } else if (this.previousChar2 == '@' && this.previousChar1 == 'f' && this.previousChar0 == 'o' && this.currentChar == 'r' && this.currentMode == Mode.Text) {
                this.extract(this.templateCode, this.lastIndex, this.i - 3, this.visitor::onTextPart);
                this.lastIndex = this.i + 1;
                this.push(Mode.ForLoop);
            } else if (this.currentChar == '(' && this.currentMode == Mode.ForLoop) {
                this.lastIndex = this.i + 1;
                this.push(Mode.ForLoopCode);
            } else if (this.currentChar == '(' && this.currentMode == Mode.ForLoopCode) {
                this.push(Mode.ForLoopCode);
            } else if (this.currentChar == ')' && this.currentMode == Mode.ForLoopCode) {
                this.pop();
                if (this.currentMode == Mode.ForLoop) {
                    this.extract(this.templateCode, this.lastIndex, this.i, this.visitor::onForLoopStart);
                    this.lastIndex = this.i + 1;
                    this.push(Mode.Text);
                }
            } else if (this.previousChar5 == '@' && this.previousChar4 == 'e' && this.previousChar3 == 'n' && this.previousChar2 == 'd' && this.previousChar1 == 'f' && this.previousChar0 == 'o' && this.currentChar == 'r' && this.currentMode == Mode.Text) {
                this.extract(this.templateCode, this.lastIndex, this.i - 6, this.visitor::onTextPart);
                this.lastIndex = this.i + 1;
                this.pop();
                if (this.currentMode == Mode.ForLoop) {
                    this.visitor.onForLoopEnd(this.depth);
                    this.pop();
                }
            } else if (this.previousChar3 == '@' && this.previousChar2 == 't' && this.previousChar1 == 'a' && this.previousChar0 == 'g' && this.currentChar == '.' && this.currentMode == Mode.Text) {
                this.extract(this.templateCode, this.lastIndex, this.i - 4, this.visitor::onTextPart);
                this.lastIndex = this.i + 1;
                this.push(new TagMode(TemplateType.Tag));
                this.push(Mode.TagName);
            } else if (this.previousChar6 == '@' && this.previousChar5 == 'l' && this.previousChar4 == 'a' && this.previousChar3 == 'y' && this.previousChar2 == 'o' && this.previousChar1 == 'u' && this.previousChar0 == 't' && this.currentChar == '.' && this.currentMode == Mode.Text) {
                this.extract(this.templateCode, this.lastIndex, this.i - 7, this.visitor::onTextPart);
                this.lastIndex = this.i + 1;
                this.push(new TagMode(TemplateType.Layout));
                this.push(Mode.TagName);
            } else if (this.currentMode == Mode.TagName) {
                if (this.currentChar == '(') {
                    this.pop();
                    this.push(Mode.JavaCodeParam);
                    this.lastIndex = this.i + 1;
                } else if (this.currentChar != ' ') {
                    this.getPreviousMode(TagMode.class).name.append(this.currentChar);
                }
            } else if (this.currentMode == Mode.Text && this.contentType == ContentType.Html) {
                this.interceptHtmlTags();
            }
            if (this.currentChar == '\n' && this.currentMode != Mode.Content) {
                this.visitor.onLineFinished();
            }
            ++this.i;
        }
        if (this.lastIndex < this.endIndex) {
            this.extract(this.templateCode, this.lastIndex, this.endIndex, this.visitor::onTextPart);
        }
        if (this.type != TemplateType.Content) {
            this.completeParamsIfRequired();
            this.visitor.onComplete();
        }
    }

    private boolean isContentExpressionAllowed() {
        return this.currentMode == Mode.Content || this.currentMode == Mode.JavaCodeParam || this.currentMode == Mode.Code || this.currentMode == Mode.CodeStatement || this.currentMode == Mode.Param;
    }

    private void extractCodePart() {
        if (this.contentType == ContentType.Html) {
            this.extractHtmlCodePart();
        } else {
            this.extractPlainCodePart();
        }
        this.lastIndex = this.i + 1;
    }

    private void extractPlainCodePart() {
        this.extract(this.templateCode, this.lastIndex, this.i, this.visitor::onCodePart);
    }

    private void extractHtmlCodePart() {
        if (this.currentHtmlTag != null) {
            if (this.currentHtmlTag.comment) {
                this.visitor.onError("Expressions in HTML comments are not allowed.");
            }
            if (this.currentHtmlTag.attributesProcessed) {
                this.extract(this.templateCode, this.lastIndex, this.i, (depth, codePart) -> this.visitor.onHtmlTagBodyCodePart(depth, codePart, this.currentHtmlTag.name));
                return;
            }
            HtmlAttribute currentAttribute = this.currentHtmlTag.getCurrentAttribute();
            if (currentAttribute != null && currentAttribute.quoteCount < 2) {
                this.extract(this.templateCode, this.lastIndex, this.i, (depth, codePart) -> this.visitor.onHtmlTagAttributeCodePart(depth, codePart, this.currentHtmlTag.name, currentAttribute.name));
                return;
            }
        }
        this.extract(this.templateCode, this.lastIndex, this.i, (depth, codePart) -> this.visitor.onHtmlTagBodyCodePart(depth, codePart, "html"));
    }

    private void interceptHtmlTags() {
        if (this.isOpeningHtmlTag()) {
            String name = this.parseHtmlTagName(this.i + 1);
            if (!name.isEmpty()) {
                HtmlTag htmlTag = new HtmlTag(name, this.isHtmlTagIntercepted(name), this.i + name.length());
                this.htmlPolicy.validateHtmlTag((org.jusecase.jte.html.HtmlTag)htmlTag);
                this.pushHtmlTag(htmlTag);
                this.tagClosed = false;
            }
        } else if (this.currentHtmlTag != null && this.i > this.currentHtmlTag.attributeStartIndex) {
            if (this.currentHtmlTag.comment) {
                if (this.previousChar1 == '-' && this.previousChar0 == '-' && this.currentChar == '>') {
                    this.popHtmlTag();
                    this.tagClosed = true;
                }
            } else if (!this.currentHtmlTag.attributesProcessed && this.currentHtmlTag.isCurrentAttributeQuote(this.currentChar)) {
                HtmlAttribute currentAttribute = this.currentHtmlTag.getCurrentAttribute();
                ++currentAttribute.quoteCount;
                if (currentAttribute.quoteCount == 1) {
                    currentAttribute.valueStartIndex = this.i + 1;
                    if (!currentAttribute.bool && this.isHtmlAttributeIntercepted(currentAttribute.name)) {
                        this.extract(this.templateCode, this.lastIndex, this.i + 1, this.visitor::onTextPart);
                        this.lastIndex = this.i + 1;
                        this.visitor.onHtmlAttributeStarted(this.depth, this.currentHtmlTag, currentAttribute);
                    }
                } else if (currentAttribute.quoteCount == 2) {
                    currentAttribute.value = this.templateCode.substring(currentAttribute.valueStartIndex, this.i);
                    if (currentAttribute.bool) {
                        this.extract(this.templateCode, this.lastIndex, currentAttribute.startIndex, this.visitor::onTextPart);
                        this.lastIndex = this.i + 1;
                        this.visitor.onHtmlBooleanAttributeStarted(this.depth, this.currentHtmlTag, currentAttribute);
                        this.outputPrevented = false;
                    }
                }
            } else if (!this.currentHtmlTag.attributesProcessed && this.previousChar0 == '/' && this.currentChar == '>') {
                if (this.currentHtmlTag.intercepted) {
                    this.extract(this.templateCode, this.lastIndex, this.i - 1, this.visitor::onTextPart);
                    this.lastIndex = this.i - 1;
                    this.visitor.onHtmlTagOpened(this.depth, this.currentHtmlTag);
                }
                this.currentHtmlTag.attributesProcessed = true;
                this.popHtmlTag();
            } else if (!this.currentHtmlTag.attributesProcessed && this.currentChar == '>') {
                if (this.tagClosed) {
                    this.tagClosed = false;
                } else {
                    if (this.currentHtmlTag.intercepted) {
                        this.extract(this.templateCode, this.lastIndex, this.i, this.visitor::onTextPart);
                        this.lastIndex = this.i;
                        this.visitor.onHtmlTagOpened(this.depth, this.currentHtmlTag);
                    }
                    this.currentHtmlTag.attributesProcessed = true;
                    if (this.currentHtmlTag.bodyIgnored) {
                        this.popHtmlTag();
                    }
                }
            } else if (this.previousChar0 == '<' && this.currentChar == '/') {
                if (this.templateCode.startsWith(this.currentHtmlTag.name, this.i + 1)) {
                    if (!this.currentHtmlTag.bodyIgnored) {
                        if (this.currentHtmlTag.intercepted) {
                            this.extract(this.templateCode, this.lastIndex, this.i - 1, this.visitor::onTextPart);
                            this.lastIndex = this.i - 1;
                            this.visitor.onHtmlTagClosed(this.depth, this.currentHtmlTag);
                        }
                        this.popHtmlTag();
                    }
                } else if (!this.currentHtmlTag.innerTagsIgnored) {
                    String tagName = this.parseHtmlTagName(this.i + 1);
                    this.visitor.onError("Unclosed tag <" + this.currentHtmlTag.name + ">, expected </" + this.currentHtmlTag.name + ">, got </" + tagName + ">.");
                }
                this.tagClosed = true;
            } else if (!this.currentHtmlTag.attributesProcessed && !Character.isWhitespace(this.currentChar) && this.currentChar != '/' && this.currentHtmlTag.isCurrentAttributeComplete()) {
                HtmlAttribute attribute = this.parseHtmlAttribute();
                if (attribute != null) {
                    this.htmlPolicy.validateHtmlAttribute((org.jusecase.jte.html.HtmlTag)this.currentHtmlTag, (org.jusecase.jte.html.HtmlAttribute)attribute);
                    this.currentHtmlTag.attributes.add(attribute);
                    this.outputPrevented = attribute.bool;
                    if (attribute.bool && attribute.quotes == '\u0000') {
                        this.i += attribute.name.length() - 1;
                    }
                } else {
                    this.outputPrevented = false;
                }
            }
        }
    }

    private boolean isOpeningHtmlTag() {
        if (this.currentChar != '<') {
            return false;
        }
        if (this.templateCode.startsWith("<%--", this.i)) {
            return false;
        }
        if (this.templateCode.startsWith("<!", this.i) && !this.templateCode.startsWith("<!--", this.i)) {
            return false;
        }
        if (this.currentHtmlTag == null) {
            return true;
        }
        if (this.currentHtmlTag.innerTagsIgnored) {
            return false;
        }
        return this.currentHtmlTag.attributesProcessed;
    }

    private void pushHtmlTag(HtmlTag htmlTag) {
        this.htmlStack.push(htmlTag);
        this.currentHtmlTag = htmlTag;
    }

    private void popHtmlTag() {
        this.htmlStack.pop();
        this.currentHtmlTag = this.htmlStack.peek();
    }

    private String parseHtmlTagName(int index) {
        char c;
        if (this.templateCode.startsWith("!--", index)) {
            return "!--";
        }
        int startIndex = index;
        while (index < this.endIndex && !Character.isWhitespace(c = this.templateCode.charAt(index)) && c != '/' && c != '>') {
            ++index;
        }
        return this.templateCode.substring(startIndex, index);
    }

    private HtmlAttribute parseHtmlAttribute() {
        int nameEndIndex = -1;
        char quotes = '\u0000';
        for (int j = this.i; j < this.endIndex; ++j) {
            char c = this.templateCode.charAt(j);
            if (c == '=') {
                quotes = this.parseHtmlAttributeQuotes(j + 1);
            }
            if (nameEndIndex == -1) {
                if (c != '=' && c != '/' && c != '>' && !Character.isWhitespace(c)) continue;
                nameEndIndex = j;
                continue;
            }
            if (!Character.isWhitespace(c)) break;
        }
        if (nameEndIndex == -1) {
            return null;
        }
        return new HtmlAttribute(this.templateCode.substring(this.i, nameEndIndex), quotes, this.i);
    }

    private char parseHtmlAttributeQuotes(int index) {
        while (Character.isWhitespace(this.templateCode.charAt(index))) {
            ++index;
        }
        return this.templateCode.charAt(index);
    }

    private boolean isHtmlTagIntercepted(String name) {
        if (this.htmlTags != null) {
            for (String htmlTag : this.htmlTags) {
                if (!name.equals(htmlTag)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isHtmlAttributeIntercepted(String name) {
        if (this.htmlAttributes != null && this.currentHtmlTag.intercepted) {
            for (String htmlAttribute : this.htmlAttributes) {
                if (!name.equals(htmlAttribute)) continue;
                return true;
            }
        }
        return false;
    }

    private void push(Mode mode) {
        this.currentMode = mode;
        this.stack.push(this.currentMode);
        if (mode == Mode.Text) {
            ++this.depth;
        }
    }

    private void pop() {
        Mode previousMode = this.stack.pop();
        if (previousMode == Mode.Text) {
            --this.depth;
        }
        this.currentMode = this.stack.peek();
    }

    private <T extends Mode> T getPreviousMode(Class<T> modeClass) {
        for (Mode mode : this.stack) {
            if (!modeClass.isAssignableFrom(mode.getClass())) continue;
            return (T)mode;
        }
        throw new IllegalStateException("Expected mode of type " + modeClass + " on the stack, but found nothing!");
    }

    private void extract(String templateCode, int startIndex, int endIndex, VisitorCallback callback) {
        this.completeParamsIfRequired();
        if (startIndex < 0) {
            return;
        }
        if (endIndex < startIndex) {
            return;
        }
        callback.accept(this.depth, templateCode.substring(startIndex, endIndex));
    }

    private void completeParamsIfRequired() {
        if (!this.paramsComplete && this.currentMode != Mode.Param && this.currentMode != Mode.Import && this.type != TemplateType.Content) {
            this.visitor.onParamsComplete();
            this.paramsComplete = true;
        }
    }

    public static class HtmlAttribute
    implements org.jusecase.jte.html.HtmlAttribute {
        private static final Set<String> BOOLEAN_HTML_ATTRIBUTES = Set.of("allowfullscreen", "allowpaymentrequest", "async", "autofocus", "autoplay", "checked", "controls", "default", "disabled", "formnovalidate", "hidden", "ismap", "itemscope", "loop", "multiple", "muted", "nomodule", "novalidate", "open", "playsinline", "readonly", "required", "reversed", "selected", "truespeed");
        public final String name;
        public final char quotes;
        public final int startIndex;
        public final boolean bool;
        public String value;
        public int quoteCount;
        public int valueStartIndex;

        private HtmlAttribute(String name, char quotes, int startIndex) {
            this.name = name;
            this.quotes = quotes;
            this.startIndex = startIndex;
            this.bool = BOOLEAN_HTML_ATTRIBUTES.contains(name);
        }

        public String getName() {
            return this.name;
        }

        public char getQuotes() {
            return this.quotes;
        }

        public boolean isBoolean() {
            return this.bool;
        }
    }

    public static class HtmlTag
    implements org.jusecase.jte.html.HtmlTag {
        private static final Set<String> VOID_HTML_TAGS = Set.of("area", "base", "br", "col", "command", "embed", "hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr");
        public final String name;
        public final boolean intercepted;
        public final int attributeStartIndex;
        public final boolean bodyIgnored;
        public final boolean innerTagsIgnored;
        public final boolean comment;
        public final List<HtmlAttribute> attributes = new ArrayList<HtmlAttribute>();
        public boolean attributesProcessed;

        public HtmlTag(String name, boolean intercepted, int attributeStartIndex) {
            this.name = name;
            this.intercepted = intercepted;
            this.attributeStartIndex = attributeStartIndex;
            this.bodyIgnored = VOID_HTML_TAGS.contains(name);
            this.comment = "!--".equals(name);
            this.innerTagsIgnored = "script".equals(name) || "style".equals(name);
        }

        public HtmlAttribute getCurrentAttribute() {
            if (this.attributes.isEmpty()) {
                return null;
            }
            return this.attributes.get(this.attributes.size() - 1);
        }

        public boolean isCurrentAttributeComplete() {
            HtmlAttribute currentAttribute = this.getCurrentAttribute();
            if (currentAttribute == null) {
                return true;
            }
            if (currentAttribute.bool && currentAttribute.quotes == '\u0000') {
                return true;
            }
            return currentAttribute.quoteCount > 1;
        }

        public boolean isCurrentAttributeQuote(char currentChar) {
            HtmlAttribute currentAttribute = this.getCurrentAttribute();
            if (currentAttribute == null) {
                return false;
            }
            return currentChar == currentAttribute.quotes;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class TagMode
    implements Mode {
        final TemplateType type;
        final StringBuilder name = new StringBuilder();
        final List<String> params = new ArrayList<String>();

        private TagMode(TemplateType type) {
            this.type = type;
        }

        @Override
        public boolean isJava() {
            return false;
        }
    }

    private static class StatelessMode
    implements Mode {
        private final String debugName;
        private final boolean java;

        private StatelessMode(String debugName) {
            this(debugName, false);
        }

        private StatelessMode(String debugName, boolean java) {
            this.debugName = debugName;
            this.java = java;
        }

        @Override
        public boolean isJava() {
            return this.java;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.debugName + "]";
        }
    }

    private static interface Mode {
        public static final Mode Import = new StatelessMode("Import");
        public static final Mode Param = new StatelessMode("Param");
        public static final Mode Text = new StatelessMode("Text");
        public static final Mode Code = new StatelessMode("Code");
        public static final Mode UnsafeCode = new StatelessMode("UnsafeCode");
        public static final Mode CodeStatement = new StatelessMode("CodeStatement");
        public static final Mode Condition = new StatelessMode("Condition");
        public static final Mode JavaCode = new StatelessMode("JavaCode", true);
        public static final Mode JavaCodeParam = new StatelessMode("JavaCodeParam", true);
        public static final Mode JavaCodeString = new StatelessMode("JavaCodeString");
        public static final Mode ConditionElse = new StatelessMode("ConditionElse");
        public static final Mode ForLoop = new StatelessMode("ForLoop");
        public static final Mode ForLoopCode = new StatelessMode("ForLoopCode");
        public static final Mode TagName = new StatelessMode("TagName");
        public static final Mode Comment = new StatelessMode("Comment");
        public static final Mode Content = new StatelessMode("Content");

        public boolean isJava();
    }

    static interface VisitorCallback {
        public void accept(int var1, String var2);
    }
}

