/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.annotation_indexer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hudson.annotation_indexer.FilterIterator;
import org.jvnet.hudson.annotation_indexer.Indexed;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index {
    private static final Logger LOGGER = Logger.getLogger(Index.class.getName());

    public static <T extends AnnotatedElement> Iterable<T> list(Class<? extends Annotation> type, ClassLoader cl, final Class<T> subType) throws IOException {
        final Iterable<AnnotatedElement> base = Index.list(type, cl);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new FilterIterator(base.iterator()){

                    protected boolean filter(Object o) {
                        return subType.isInstance(o);
                    }
                };
            }
        };
    }

    public static Iterable<AnnotatedElement> list(final Class<? extends Annotation> type, final ClassLoader cl) throws IOException {
        if (!type.isAnnotationPresent(Indexed.class)) {
            throw new IllegalArgumentException(type + " doesn't have @Indexed");
        }
        final TreeSet<String> ids = new TreeSet<String>();
        Enumeration<URL> res = cl.getResources("META-INF/annotations/" + type.getName());
        while (res.hasMoreElements()) {
            String line;
            URL url = res.nextElement();
            BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
            while ((line = r.readLine()) != null) {
                ids.add(line);
            }
        }
        return new Iterable<AnnotatedElement>(){

            @Override
            public Iterator<AnnotatedElement> iterator() {
                return new Iterator<AnnotatedElement>(){
                    private AnnotatedElement next;
                    private Iterator<String> iditr;
                    private List<AnnotatedElement> lookaheads;
                    {
                        this.iditr = ids.iterator();
                        this.lookaheads = new LinkedList<AnnotatedElement>();
                    }

                    @Override
                    public boolean hasNext() {
                        this.fetch();
                        return this.next != null;
                    }

                    @Override
                    public AnnotatedElement next() {
                        this.fetch();
                        AnnotatedElement r = this.next;
                        this.next = null;
                        return r;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private void fetch() {
                        while (this.next == null) {
                            if (!this.lookaheads.isEmpty()) {
                                this.next = this.lookaheads.remove(0);
                                return;
                            }
                            if (!this.iditr.hasNext()) {
                                return;
                            }
                            String name = this.iditr.next();
                            try {
                                Class<?> c = cl.loadClass(name);
                                if (c.isAnnotationPresent(type)) {
                                    this.lookaheads.add(c);
                                }
                                this.listAnnotatedElements(c.getDeclaredMethods());
                                this.listAnnotatedElements(c.getDeclaredFields());
                            }
                            catch (ClassNotFoundException e) {
                                LOGGER.log(Level.FINE, "Failed to load: " + name, e);
                            }
                        }
                    }

                    private void listAnnotatedElements(AnnotatedElement[] elements) {
                        for (AnnotatedElement m : elements) {
                            if (!m.isAnnotationPresent(type)) continue;
                            this.lookaheads.add(m);
                        }
                    }
                };
            }
        };
    }
}

