/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.core;

import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.impl.ScriptBlock;
import org.apache.commons.jelly.parser.XMLParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ParseTag
extends TagSupport {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jelly$tags$core$ParseTag == null ? (class$org$apache$commons$jelly$tags$core$ParseTag = ParseTag.class$("org.apache.commons.jelly.tags.core.ParseTag")) : class$org$apache$commons$jelly$tags$core$ParseTag));
    private String var;
    private String text;
    private XMLReader xmlReader;
    private XMLParser jellyParser;
    static /* synthetic */ Class class$org$apache$commons$jelly$tags$core$ParseTag;

    public void doTag(XMLOutput output) throws MissingAttributeException, JellyTagException {
        String text = this.getText();
        if (text != null) {
            this.parseText(text);
        } else {
            this.parseBody(output);
        }
        ScriptBlock script = this.getJellyParser().getScript();
        if (this.var != null) {
            this.context.setVariable(this.var, script);
        } else {
            script.run(this.context, output);
        }
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public XMLReader getXMLReader() throws ParserConfigurationException, SAXException {
        if (this.xmlReader == null) {
            this.xmlReader = this.createXMLReader();
        }
        return this.xmlReader;
    }

    public void setXMLReader(XMLReader xmlReader) {
        this.xmlReader = xmlReader;
    }

    public XMLParser getJellyParser() {
        if (this.jellyParser == null) {
            this.jellyParser = this.createJellyParser();
        }
        return this.jellyParser;
    }

    public void setJellyParser(XMLParser jellyParser) {
        this.jellyParser = jellyParser;
    }

    protected XMLReader createXMLReader() throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        return parser.getXMLReader();
    }

    protected void parseBody(XMLOutput output) throws JellyTagException {
        XMLParser handler = this.getJellyParser();
        XMLOutput newOutput = new XMLOutput(handler);
        try {
            handler.startDocument();
            this.invokeBody(newOutput);
            handler.endDocument();
        }
        catch (SAXException e) {
            throw new JellyTagException(e);
        }
    }

    protected void parseText(String text) throws JellyTagException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("About to parse: " + text));
        }
        try {
            XMLReader xmlReader = this.getXMLReader();
            xmlReader.setContentHandler(this.getJellyParser());
            xmlReader.parse(new InputSource(new StringReader(text)));
        }
        catch (Exception e) {
            throw new JellyTagException(e);
        }
    }

    protected XMLParser createJellyParser() {
        XMLParser answer = new XMLParser();
        answer.setContext(this.context);
        return answer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

