/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl.util.introspection;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.jexl.util.introspection.IntrospectionUtils;

public class MethodMap {
    private static final int MORE_SPECIFIC = 0;
    private static final int LESS_SPECIFIC = 1;
    private static final int INCOMPARABLE = 2;
    Map methodByNameMap = new Hashtable();

    public void add(Method method) {
        String methodName = method.getName();
        ArrayList<Method> l = this.get(methodName);
        if (l == null) {
            l = new ArrayList<Method>();
            this.methodByNameMap.put(methodName, l);
        }
        l.add(method);
    }

    public List get(String key) {
        return (List)this.methodByNameMap.get(key);
    }

    public Method find(String methodName, Object[] args) throws AmbiguousException {
        List methodList = this.get(methodName);
        if (methodList == null) {
            return null;
        }
        int l = args.length;
        Class[] classes = new Class[l];
        for (int i = 0; i < l; ++i) {
            Object arg = args[i];
            classes[i] = arg == null ? null : arg.getClass();
        }
        return MethodMap.getMostSpecific(methodList, classes);
    }

    private static Method getMostSpecific(List methods, Class[] classes) throws AmbiguousException {
        LinkedList applicables = MethodMap.getApplicables(methods, classes);
        if (applicables.isEmpty()) {
            return null;
        }
        if (applicables.size() == 1) {
            return (Method)applicables.getFirst();
        }
        LinkedList<Method> maximals = new LinkedList<Method>();
        Iterator applicable = applicables.iterator();
        while (applicable.hasNext()) {
            Method app = (Method)applicable.next();
            Class[] appArgs = app.getParameterTypes();
            boolean lessSpecific = false;
            Iterator maximal = maximals.iterator();
            while (!lessSpecific && maximal.hasNext()) {
                Method max = (Method)maximal.next();
                switch (MethodMap.moreSpecific(appArgs, max.getParameterTypes())) {
                    case 0: {
                        maximal.remove();
                        break;
                    }
                    case 1: {
                        lessSpecific = true;
                    }
                }
            }
            if (lessSpecific) continue;
            maximals.addLast(app);
        }
        if (maximals.size() > 1) {
            throw new AmbiguousException();
        }
        return (Method)maximals.getFirst();
    }

    private static int moreSpecific(Class[] c1, Class[] c2) {
        boolean c1MoreSpecific = false;
        boolean c2MoreSpecific = false;
        if (c1.length > c2.length) {
            return 0;
        }
        if (c2.length > c1.length) {
            return 1;
        }
        for (int i = 0; i < c1.length; ++i) {
            if (c1[i] == c2[i]) continue;
            boolean last = i == c1.length - 1;
            c1MoreSpecific = c1MoreSpecific || MethodMap.isStrictConvertible(c2[i], c1[i], last);
            c2MoreSpecific = c2MoreSpecific || MethodMap.isStrictConvertible(c1[i], c2[i], last);
        }
        if (c1MoreSpecific) {
            if (c2MoreSpecific) {
                return 2;
            }
            return 0;
        }
        if (c2MoreSpecific) {
            return 1;
        }
        return 2;
    }

    private static LinkedList getApplicables(List methods, Class[] classes) {
        LinkedList<Method> list = new LinkedList<Method>();
        Iterator imethod = methods.iterator();
        while (imethod.hasNext()) {
            Method method = (Method)imethod.next();
            if (!MethodMap.isApplicable(method, classes)) continue;
            list.add(method);
        }
        return list;
    }

    private static boolean isApplicable(Method method, Class[] classes) {
        block7: {
            Class<?>[] methodArgs;
            block6: {
                methodArgs = method.getParameterTypes();
                if (methodArgs.length > classes.length) {
                    return methodArgs.length == classes.length + 1 && methodArgs[methodArgs.length - 1].isArray();
                }
                if (methodArgs.length != classes.length) break block6;
                for (int i = 0; i < classes.length; ++i) {
                    if (MethodMap.isConvertible(methodArgs[i], classes[i], false)) continue;
                    if (i == classes.length - 1 && methodArgs[i].isArray()) {
                        return MethodMap.isConvertible(methodArgs[i], classes[i], true);
                    }
                    return false;
                }
                break block7;
            }
            if (methodArgs.length <= 0) break block7;
            Class<?> lastarg = methodArgs[methodArgs.length - 1];
            if (!lastarg.isArray()) {
                return false;
            }
            for (int i = 0; i < methodArgs.length - 1; ++i) {
                if (MethodMap.isConvertible(methodArgs[i], classes[i], false)) continue;
                return false;
            }
            Class<?> vararg = lastarg.getComponentType();
            for (int i = methodArgs.length - 1; i < classes.length; ++i) {
                if (MethodMap.isConvertible(vararg, classes[i], false)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isConvertible(Class formal, Class actual, boolean possibleVarArg) {
        return IntrospectionUtils.isMethodInvocationConvertible(formal, actual, possibleVarArg);
    }

    private static boolean isStrictConvertible(Class formal, Class actual, boolean possibleVarArg) {
        return IntrospectionUtils.isStrictMethodInvocationConvertible(formal, actual, possibleVarArg);
    }

    public static class AmbiguousException
    extends RuntimeException {
        private static final long serialVersionUID = -2314636505414551663L;
    }
}

