/*
 * Decompiled with CFR 0.152.
 */
package netx.jnlp;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class Version {
    private static String seperators = ".-_";
    private static String emptyString = new String("<EMPTY>");
    private String versionString;

    public Version(String versions) {
        this.versionString = versions;
    }

    public boolean isVersionId() {
        return -1 == this.versionString.indexOf(" ");
    }

    public boolean matches(String version) {
        return this.matches(new Version(version));
    }

    public boolean matches(Version version) {
        List versionStrings = version.getVersionStrings();
        for (int i = 0; i < versionStrings.size(); ++i) {
            if (this.matchesSingle((String)versionStrings.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean matchesAny(String version) {
        return this.matches(new Version(version));
    }

    public boolean matchesAny(Version version) {
        List versionStrings = version.getVersionStrings();
        for (int i = 0; i < versionStrings.size(); ++i) {
            if (!this.matchesSingle((String)versionStrings.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean matchesSingle(String version) {
        List versionStrings = this.getVersionStrings();
        for (int i = 0; i < versionStrings.size(); ++i) {
            if (!this.matches(version, (String)versionStrings.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean matches(String subversion, String version) {
        List subparts = this.getParts(subversion);
        List parts = this.getParts(version);
        int maxLength = Math.max(subversion.length(), version.length());
        if (version.endsWith("*")) {
            maxLength = parts.size();
        }
        this.normalize(new List[]{subparts, parts}, maxLength);
        if (this.equal(subparts, parts)) {
            return true;
        }
        return version.endsWith("+") && this.greater(subparts, parts);
    }

    protected boolean equal(List parts1, List parts2) {
        for (int i = 0; i < parts1.size(); ++i) {
            if (0 == this.compare((String)parts1.get(i), (String)parts2.get(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean greater(List parts1, List parts2) {
        for (int i = 0; i < parts1.size(); ++i) {
            if (this.compare((String)parts1.get(i), (String)parts2.get(i)) > 0) {
                return true;
            }
            if (this.compare((String)parts1.get(i), (String)parts2.get(i)) >= 0) continue;
            return false;
        }
        return false;
    }

    protected int compare(String part1, String part2) {
        Integer number1 = new Integer(0);
        Integer number2 = new Integer(0);
        try {
            if (part1 != emptyString) {
                number1 = Integer.valueOf(part1);
            }
            if (part2 != emptyString) {
                number2 = Integer.valueOf(part2);
            }
            return number1.compareTo(number2);
        }
        catch (NumberFormatException ex) {
            if (part1 == emptyString) {
                part1 = "";
            }
            if (part2 == emptyString) {
                part2 = "";
            }
            return part1.compareTo(part2);
        }
    }

    protected void normalize(List[] versions, int maxLength) {
        int i;
        int length = 0;
        for (i = 0; i < versions.length; ++i) {
            length = Math.max(length, versions[i].size());
        }
        if (length > maxLength) {
            length = maxLength;
        }
        for (i = 0; i < versions.length; ++i) {
            while (versions[i].size() > length) {
                versions[i].remove(versions[i].size() - 1);
            }
            while (versions[i].size() < length) {
                versions[i].add(emptyString);
            }
        }
    }

    protected List getVersionStrings() {
        ArrayList<String> strings = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(this.versionString, " ");
        while (st.hasMoreTokens()) {
            strings.add(st.nextToken());
        }
        return strings;
    }

    protected List getParts(String oneVersion) {
        ArrayList<String> strings = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(oneVersion, seperators + "+*");
        while (st.hasMoreTokens()) {
            strings.add(st.nextToken());
        }
        return strings;
    }

    public String toString() {
        return this.versionString;
    }
}

